/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.internal.dialogs;

import com.dbeaver.ui.internal.UICoreMessages;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.AbstractPopupPanel;
import org.jkiss.utils.CommonUtils;

public class ImportCertificateDialog
extends AbstractPopupPanel {
    private Text aliasText;
    private TextWithOpenFile certificateText;
    private String alias;
    private String certificate;

    public ImportCertificateDialog(Shell parent) {
        super(parent, UICoreMessages.pref_page_trust_button_import_dialog_title);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite placeholder = super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.heightHint = UIUtils.getFontHeight((Font)placeholder.getFont()) * 12;
        gd.widthHint = UIUtils.getFontHeight((Font)placeholder.getFont()) * 60;
        placeholder.setLayoutData((Object)gd);
        Composite composite = UIUtils.createComposite((Composite)placeholder, (int)2);
        composite.setLayoutData((Object)new GridData(1808));
        this.aliasText = UIUtils.createLabelText((Composite)composite, (String)UICoreMessages.pref_page_trust_button_import_dialog_cert_name, (String)"");
        this.aliasText.setLayoutData((Object)new GridData(768));
        UIUtils.createLabel((Composite)composite, (String)UICoreMessages.pref_page_trust_button_import_dialog_cert_path);
        this.certificateText = new TextWithOpenFile(composite, UICoreMessages.pref_page_trust_button_import_dialog_cert_open_message, new String[]{"*.cer", "*.crt", "*"});
        this.certificateText.setLayoutData((Object)new GridData(768));
        ModifyListener modifyListener = e -> {
            String certificatePath = this.certificateText.getText();
            boolean isValid = !CommonUtils.isEmpty((String)this.aliasText.getText()) && !CommonUtils.isEmpty((String)certificatePath) && this.checkPathValidity(certificatePath);
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(isValid);
            }
        };
        this.aliasText.addModifyListener(modifyListener);
        this.certificateText.getTextControl().addModifyListener(modifyListener);
        UIUtils.asyncExec(() -> {
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(false);
            }
        });
        return placeholder;
    }

    protected void okPressed() {
        this.alias = this.aliasText.getText();
        this.certificate = this.certificateText.getText();
        super.okPressed();
    }

    public String getAlias() {
        return this.alias;
    }

    public String getCertificate() {
        return this.certificate;
    }

    protected boolean checkPathValidity(String pathString) {
        try {
            return Files.exists(Path.of(pathString, new String[0]), new LinkOption[0]);
        }
        catch (InvalidPathException invalidPathException) {
            return false;
        }
    }
}

