/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.internal.resultset.xml;

import com.dbeaver.ui.internal.UICoreMessages;
import com.dbeaver.ui.internal.resultset.xml.XMLRenderer;
import com.dbeaver.ui.resultset.document.AbstractDocumentPresentation;
import com.dbeaver.ui.resultset.document.IDocumentFrame;
import com.dbeaver.ui.resultset.document.IDocumentRenderer;
import java.io.InputStream;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.impl.data.DBDDocumentContentProxy;
import org.jkiss.dbeaver.model.impl.data.DBDDocumentXML;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.ui.editors.BinaryEditorInput;
import org.jkiss.dbeaver.ui.editors.xml.XMLEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;

public class XMLPresentation
extends AbstractDocumentPresentation {
    private static final Log log = Log.getLog(XMLPresentation.class);

    @Override
    @NotNull
    protected IDocumentRenderer createRenderer(@NotNull IDocumentFrame frame) {
        return new XMLRenderer(frame);
    }

    @Override
    @NotNull
    protected IEditorInput createEditorInput(@NotNull DBDDocument document, boolean readOnly) {
        return new BinaryEditorInput("#document", this.convertDocumentToData(document), readOnly, GeneralUtils.UTF8_ENCODING);
    }

    @Override
    @NotNull
    protected IEditorPart createEditorPart() throws DBException {
        return new XMLEditor();
    }

    @Override
    @NotNull
    public DBDDocument createDocumentFromContent(@NotNull DBDContent content) {
        try {
            return new XMLContentDocument(content);
        }
        catch (DBException e) {
            log.error((Object)e);
            return null;
        }
    }

    @Override
    @NotNull
    protected DBDDocument createNewDocument() throws DBException {
        try {
            return new DBDDocumentXML(XMLUtils.createDocument());
        }
        catch (XMLException e) {
            throw new DBException(UICoreMessages.XMLPresentation_e_create_xml_new, (Throwable)e);
        }
    }

    private static class XMLContentDocument
    extends DBDDocumentContentProxy {
        public XMLContentDocument(DBDContent content) throws DBException {
            super(content);
        }

        @NotNull
        protected DBDDocument createDocumentFromContent(@NotNull DBDContent content) throws DBException {
            try {
                Document xmlDocument;
                block12: {
                    DBDContentStorage contents = content.getContents((DBRProgressMonitor)new VoidProgressMonitor());
                    if (contents != null) {
                        Throwable throwable = null;
                        Object var5_6 = null;
                        try (InputStream stream = contents.getContentStream();){
                            xmlDocument = XMLUtils.parseDocument((InputStream)stream);
                            break block12;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    xmlDocument = XMLUtils.createDocument();
                }
                return new DBDDocumentXML(xmlDocument);
            }
            catch (Exception e) {
                throw new DBException(UICoreMessages.XMLPresentation_e_create_xml, (Throwable)e);
            }
        }
    }
}

