/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.spelling;

import com.dbeaver.ui.editors.spelling.AddWordProposal;
import com.dbeaver.ui.editors.spelling.ChangeCaseProposal;
import com.dbeaver.ui.editors.spelling.DisableSpellCheckingProposal;
import com.dbeaver.ui.editors.spelling.SpellCheckEngine;
import com.dbeaver.ui.editors.spelling.WordCorrectionProposal;
import com.dbeaver.ui.editors.spelling.WordIgnoreProposal;
import com.dbeaver.ui.editors.spelling.engine.ISpellCheckEngine;
import com.dbeaver.ui.editors.spelling.engine.ISpellChecker;
import com.dbeaver.ui.editors.spelling.engine.ISpellEvent;
import com.dbeaver.ui.editors.spelling.engine.RankedWordProposal;
import com.dbeaver.ui.editors.spelling.internal.SpellingActivator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class DefaultSpellingProblem
extends SpellingProblem {
    private final ISpellEvent spellEvent;
    private final IDocument document;

    public DefaultSpellingProblem(ISpellEvent spellEvent, IDocument document) {
        Assert.isLegal((document != null ? 1 : 0) != 0);
        Assert.isLegal((spellEvent != null ? 1 : 0) != 0);
        this.spellEvent = spellEvent;
        this.document = document;
    }

    public int getOffset() {
        return this.spellEvent.getBegin();
    }

    public int getLength() {
        return this.spellEvent.getEnd() - this.spellEvent.getBegin() + 1;
    }

    public String getMessage() {
        if (this.isSentenceStart() && this.isDictionaryMatch()) {
            return "The word '" + this.spellEvent.getWord() + "' should have an initial upper case letter";
        }
        return "The word '" + this.spellEvent.getWord() + "' is not correctly spelled";
    }

    public ICompletionProposal[] getProposals() {
        return this.getProposals(null);
    }

    public ICompletionProposal[] getProposals(IQuickAssistInvocationContext context) {
        String[] arguments = this.getArguments();
        if (arguments == null) {
            return new ICompletionProposal[0];
        }
        if (arguments[0].indexOf(38) != -1 && this.isIgnoringAmpersand()) {
            return new ICompletionProposal[0];
        }
        int threshold = SpellingActivator.getDefault().getPreferences().getInt("spelling_proposal_threshold");
        int size = 0;
        List<RankedWordProposal> proposals = null;
        RankedWordProposal proposal = null;
        ICompletionProposal[] result = null;
        int index = 0;
        boolean fixed = false;
        boolean match = false;
        boolean sentence = false;
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.getSpellChecker();
        if (checker != null) {
            context = context == null ? new TextInvocationContext(null, this.getOffset(), this.getLength()) : new TextInvocationContext(context.getSourceViewer(), this.getOffset(), this.getLength());
            boolean bl = fixed = arguments[0].charAt(0) == '<' || arguments[0].charAt(0) == '@';
            if (sentence && match && !fixed) {
                result = new ICompletionProposal[]{new ChangeCaseProposal(arguments, this.getOffset(), this.getLength(), context, engine.getLocale())};
            } else {
                proposals = new ArrayList<RankedWordProposal>(checker.getProposals(arguments[0], sentence));
                size = proposals.size();
                if (threshold > 0 && size > threshold) {
                    Collections.sort(proposals);
                    proposals = proposals.subList(size - threshold - 1, size - 1);
                    size = proposals.size();
                }
                boolean extendable = !fixed ? checker.acceptsWords() || AddWordProposal.canAskToConfigure() : false;
                result = new ICompletionProposal[size + (extendable ? 3 : 2)];
                index = 0;
                while (index < size) {
                    proposal = proposals.get(index);
                    result[index] = new WordCorrectionProposal(proposal.getText(), arguments, this.getOffset(), this.getLength(), context, proposal.getRank());
                    ++index;
                }
                if (extendable) {
                    result[index++] = new AddWordProposal(arguments[0], context);
                }
                result[index++] = new WordIgnoreProposal(arguments[0], context);
                result[index++] = new DisableSpellCheckingProposal(context);
            }
        }
        return result;
    }

    private boolean isIgnoringAmpersand() {
        return SpellingActivator.getDefault().getPreferences().getBoolean("spelling_ignore_ampersand_in_properties");
    }

    public String[] getArguments() {
        String word;
        String prefix = "";
        String postfix = "";
        try {
            word = this.document.get(this.getOffset(), this.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        try {
            IRegion line = this.document.getLineInformationOfOffset(this.getOffset());
            prefix = this.document.get(line.getOffset(), this.getOffset() - line.getOffset());
            int postfixStart = this.getOffset() + this.getLength();
            postfix = this.document.get(postfixStart, line.getOffset() + line.getLength() - postfixStart);
        }
        catch (BadLocationException badLocationException) {}
        return new String[]{word, prefix, postfix, this.isSentenceStart() ? Boolean.toString(true) : Boolean.toString(false), this.isDictionaryMatch() ? Boolean.toString(true) : Boolean.toString(false)};
    }

    public boolean isDictionaryMatch() {
        return this.spellEvent.isMatch();
    }

    public boolean isSentenceStart() {
        return this.spellEvent.isStart();
    }
}

