/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.spelling;

import com.dbeaver.ui.editors.spelling.SpellCheckEngine;
import com.dbeaver.ui.editors.spelling.WordCorrectionProposal;
import com.dbeaver.ui.editors.spelling.engine.ISpellCheckEngine;
import com.dbeaver.ui.editors.spelling.engine.ISpellChecker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class WordIgnoreProposal
implements ICompletionProposal {
    private IQuickAssistInvocationContext fContext;
    private String fWord;

    public WordIgnoreProposal(String word, IQuickAssistInvocationContext context) {
        this.fWord = word;
        this.fContext = context;
    }

    public final void apply(IDocument document) {
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.getSpellChecker();
        if (checker != null) {
            checker.ignoreWord(this.fWord);
            ISourceViewer sourceViewer = this.fContext.getSourceViewer();
            if (sourceViewer != null) {
                SpellingProblem.removeAll((ISourceViewer)sourceViewer, (String)this.fWord);
            }
        }
    }

    public String getAdditionalProposalInfo() {
        return "Ignores '" + WordCorrectionProposal.getHtmlRepresentation(this.fWord) + "' during the current session";
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return "=Ignore '" + this.fWord + "' during the current session";
    }

    public Image getImage() {
        return null;
    }

    public final Point getSelection(IDocument document) {
        return new Point(this.fContext.getOffset(), this.fContext.getLength());
    }
}

