/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.license;

import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseType;
import com.dbeaver.lm.api.LMProduct;
import com.dbeaver.lm.api.LMUtils;
import com.dbeaver.model.DBPApplicationEAP;
import com.dbeaver.model.license.DBPLicenseService;
import com.dbeaver.model.license.app.LMAppUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;

public class LicenseEAPDialog
extends IconAndMessageDialog {
    public static final int IMPORT_BUTTON_ID = 1000;
    public static final int BUY_BUTTON_ID = 1001;
    public static final int DOWNLOAD_BUTTON_ID = 1002;
    private final boolean canWork;
    private final boolean isEABuild;
    @Nullable
    private final LocalDateTime buildDate;
    @Nullable
    private final LocalDateTime currentTime;

    public LicenseEAPDialog(Shell parentShell, boolean canWork, @Nullable LocalDateTime buildDate, @Nullable LocalDateTime currentTime) {
        super(parentShell);
        DBPApplicationEAP applicationEAP;
        DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
        this.isEABuild = dBPApplication instanceof DBPApplicationEAP && (applicationEAP = (DBPApplicationEAP)dBPApplication).isEarlyAccessBuild();
        this.canWork = canWork && this.isEABuild;
        this.buildDate = buildDate;
        this.currentTime = currentTime;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        LicenseEAPDialog.applyDialogFont((Control)composite);
        if (this.currentTime == null) {
            Composite msgPlaceholder = UIUtils.createPlaceholder((Composite)composite, (int)2, (int)5);
            this.message = "Unable to retrieve server time for license validation. Please check your internet connection or contact support.";
            this.getShell().setText("License Validation Error");
            super.createMessageArea(msgPlaceholder);
            return composite;
        }
        try {
            Object shortMessage;
            DBPLicenseService licenseService = LMAppUtils.getLicenseService();
            LMProduct product = LMAppUtils.getActiveProduct();
            LMLicense[] productLicenses = licenseService.getAllProductLicenses();
            LMLicense lastLicense = null;
            Date mostRecentDate = null;
            LMLicense[] lMLicenseArray = productLicenses;
            int n = productLicenses.length;
            int n2 = 0;
            while (n2 < n) {
                LMLicense license = lMLicenseArray[n2];
                if (mostRecentDate == null || license.getLicenseType() != LMLicenseType.TRIAL || license.getLicenseStartTime().compareTo(mostRecentDate) > 0) {
                    lastLicense = license;
                    mostRecentDate = license.getLicenseStartTime();
                }
                ++n2;
            }
            if (this.canWork && this.buildDate != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(LMUtils.HR_DATE_FORMAT.toPattern());
                shortMessage = "This version of " + product.getName() + " Early Access will stop working on " + this.buildDate.plusDays(31L).format(formatter);
            } else {
                shortMessage = "Your license does not permit using this DBeaver version";
            }
            this.getShell().setText((String)shortMessage);
            Composite msgPlaceholder = UIUtils.createPlaceholder((Composite)composite, (int)2, (int)5);
            this.message = this.isEABuild ? (this.canWork ? (String)shortMessage + "\n\nWe appreciate your participation in the Early Access Program and look forward to your feedback on new features and reports on any issues." : "This DBeaver version cannot be used in Early Access Program anymore as it was published more than 31 days ago.\n\nWe appreciate your participation in the Early Access Program and look forward to your feedback on new features and reports on any issues.") : "This version of DBeaver is not included in the Early Access Program, so it cannot be used with your current license.";
            super.createMessageArea(msgPlaceholder);
            Group licenseGroup = UIUtils.createControlGroup((Composite)composite, (String)"License", (int)2, (int)1808, (int)0);
            Text productText = UIUtils.createLabelText((Composite)licenseGroup, (String)"Product", (String)(product.getName() + " " + product.getVersion()), (int)2056);
            productText.setLayoutData((Object)new GridData(768));
            if (lastLicense != null) {
                Text licenseText = UIUtils.createLabelText((Composite)licenseGroup, (String)"License", (String)(lastLicense.getLicenseId() + " - " + lastLicense.getLicenseType().getDisplayName() + ", starts on " + LMUtils.HR_DATE_FORMAT.format(lastLicense.getLicenseStartTime())), (int)2056);
                licenseText.setLayoutData((Object)new GridData(768));
            }
            Group downloadGroup = UIUtils.createControlGroup((Composite)composite, (String)"Early Access Program", (int)2, (int)1808, (int)0);
            Label label = new Label((Composite)downloadGroup, 0);
            label.setText("To continue using DBeaver, you can buy a license or download the latest Early Access version.");
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
            Label labelNote = new Label((Composite)downloadGroup, 0);
            labelNote.setText("Please note that the Early Access license is for non-commercial use only.");
            GridData gd1 = new GridData(1808);
            gd1.horizontalSpan = 2;
            labelNote.setLayoutData((Object)gd1);
        }
        catch (LMException e) {
            DBWorkbench.getPlatformUI().showError("Error getting license info", "Error getting license info", (Throwable)e);
        }
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.currentTime != null) {
            Button button = this.createButton(parent, 1001, "Buy license", false);
            button.setLayoutData((Object)new GridData(768));
            this.createButton(parent, 1000, "Import license", false);
            if (this.isEABuild) {
                this.createButton(parent, 1002, "Download latest version", true);
            } else {
                this.createButton(parent, 1002, "Download Early Access", true);
            }
        }
        if (this.canWork) {
            this.createButton(parent, 0, "Remind me later", false);
        } else {
            this.createButton(parent, 1, "Exit", false);
        }
    }

    protected Image getImage() {
        if (this.canWork) {
            return DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_WARNING);
        }
        return DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_ERROR);
    }

    protected int getColumnCount() {
        return 1;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1000: 
            case 1002: {
                this.setReturnCode(buttonId);
                this.close();
                break;
            }
            case 1001: {
                String buyURL = Platform.getProduct().getProperty("productPurchaseURL");
                if (buyURL.isEmpty()) break;
                ShellUtils.launchProgram((String)buyURL);
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }
}

