/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.sql.plan.diagram.renders;

import com.dbeaver.model.sql.plan.emf.SQLPlanNode;
import com.dbeaver.ui.editors.sql.plan.diagram.renders.PlanNodeRenderInfo;
import com.dbeaver.ui.editors.sql.plan.diagram.util.StyleUtil;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.algorithms.styles.TextStyle;
import org.eclipse.graphiti.mm.algorithms.styles.TextStyleRegion;
import org.eclipse.graphiti.mm.algorithms.styles.UnderlineStyle;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.graphiti.util.IColorConstant;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNodeKind;
import org.jkiss.utils.CommonUtils;

public class PlanNodeRender {
    private static final String DEFAULT_FONT_NAME = "SansSerif";
    private static final int DEFAULT_FONT_SIZE = 8;
    private static final int CAPTION_FONT_SIZE = 10;
    public static final String DEFAULT_DURATION_TIMING = "ms";
    public static final int NODE_RECT_MIN_WIDTH = 120;
    public static final int NODE_RECT_MAX_WIDTH = 500;
    public static final int NODE_RECT_MIN_HEIGHT = 80;
    public static final int NODE_RECT_MAX_HEIGHT = 600;
    public static final int DETAILS_MAX_WIDTH = 450;
    public static final int DETAILS_MAX_HEIGHT = 500;
    public static final int MARGIN_SIZE = 2;
    public static final int DESCRIPTION_LEFT_MARGIN = 8;
    public static final int DETAILS_LEFT_MARGIN = 4;
    public static final int DETAILS_RIGHT_MARGIN = 16;
    public static final int CAPTION_RIGHT_MARGIN = 40;
    public static final int NODE_ICON_SIZE = 16;
    private final PlanNodeRenderInfo renderInfo;
    private final Diagram diagram;
    private int nodeWidth;
    private int nodeHeight;
    public static final Pattern DIGITS_PATTERN = Pattern.compile("([0-9\\.]+)[\\sa-z]");
    public static final Pattern DETAILS_HEADER_PATTERN = Pattern.compile(".+\\:\n");
    private static final IGaService gaService = Graphiti.getGaService();
    private static final IPeCreateService peCreateService = Graphiti.getPeCreateService();

    public PlanNodeRender(PlanNodeRenderInfo renderInfo) {
        this.renderInfo = renderInfo;
        this.diagram = renderInfo.getTargetDiagram();
    }

    public int getNodeWidth() {
        return this.nodeWidth;
    }

    public int getNodeHeight() {
        return this.nodeHeight;
    }

    private Color getStandardColor(IColorConstant colorConstant) {
        return gaService.manageColor(this.diagram, colorConstant);
    }

    private Font getDefaultFont() {
        return gaService.manageFont(this.diagram, DEFAULT_FONT_NAME, 8, false, false);
    }

    private Font getDefaultBoldFont() {
        return gaService.manageFont(this.diagram, DEFAULT_FONT_NAME, 8, false, true);
    }

    private Font getCaptionFont(Diagram diagram) {
        Font font = this.renderInfo.getNode().isCollapsed() ? gaService.manageFont(diagram, DEFAULT_FONT_NAME, 10, true, true) : gaService.manageFont(diagram, DEFAULT_FONT_NAME, 10, false, true);
        return font;
    }

    private String getNodeCaption() {
        String nodeTitle = this.renderInfo.getNode().getNodeType();
        nodeTitle = CommonUtils.isEmpty((String)nodeTitle) ? "?" : CommonUtils.toCamelCase((String)nodeTitle);
        return this.renderInfo.getNode().isCollapsed() ? "+" + nodeTitle + "+" : nodeTitle;
    }

    private String getNodeDescription() {
        return this.renderInfo.getNode().getNodeName();
    }

    private static PlanNodeRenderInfo getRenderInfo(PictogramElement pictogramElement) {
        if (pictogramElement == null || pictogramElement.getLink() == null) {
            return null;
        }
        for (Object o : pictogramElement.getLink().getBusinessObjects()) {
            if (!(o instanceof PlanNodeRenderInfo)) continue;
            return (PlanNodeRenderInfo)((Object)o);
        }
        return null;
    }

    private void renderCostBar() {
        SQLPlanNode node = this.renderInfo.getNode();
        if (!node.isHeavyRoute()) {
            return;
        }
        RoundedRectangle costBar = this.renderInfo.getCostBar();
        if (costBar == null) {
            costBar = gaService.createPlainRoundedRectangle((GraphicsAlgorithmContainer)peCreateService.createShape(this.renderInfo.getContainerShape(), false), 3, 3);
            costBar.setStyle(StyleUtil.getStyleForHeavyNode(this.diagram, node));
            Color color = StyleUtil.getColorForHeavyText(this.diagram, node);
            costBar.setForeground(color);
            costBar.setBackground(color);
            this.renderInfo.setCostBar(costBar);
        }
        int recHeight = this.renderInfo.getShape().getHeight();
        gaService.setLocationAndSize((GraphicsAlgorithm)costBar, 6, 6, 7, recHeight - 12);
    }

    private void costBarDetails(int Y, int height) {
        SQLPlanNode node = this.renderInfo.getNode();
        if (this.renderInfo.getCostBar() != null && node.isDetailsVisible()) {
            this.renderInfo.getCostBar().setY(Y);
            this.renderInfo.getCostBar().setHeight(height);
        }
    }

    private void renderShape() {
        SQLPlanNode node = this.renderInfo.getNode();
        GraphicsAlgorithm shape = this.renderInfo.getShape();
        if (node.isCollapsed()) {
            shape.setLineStyle(LineStyle.DASH);
        } else {
            shape.setLineStyle(LineStyle.SOLID);
        }
        shape.setBackground(gaService.manageColor(this.diagram, StyleUtil.NODE_BACKGROUND));
    }

    private String evalNodeIcon(SQLPlanNode node) {
        return switch (node.getSourceNode().getNodeKind()) {
            case DBCPlanNodeKind.SELECT -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.table";
            case DBCPlanNodeKind.TABLE_SCAN -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.table";
            case DBCPlanNodeKind.INDEX_SCAN -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.index";
            case DBCPlanNodeKind.JOIN -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.join";
            case DBCPlanNodeKind.HASH -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.hash";
            case DBCPlanNodeKind.UNION -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.join";
            case DBCPlanNodeKind.FILTER -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.filter";
            case DBCPlanNodeKind.AGGREGATE -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.agg";
            case DBCPlanNodeKind.SORT -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.sort";
            case DBCPlanNodeKind.RESULT -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.proc";
            case DBCPlanNodeKind.SET -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.table";
            case DBCPlanNodeKind.MERGE -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.agg";
            case DBCPlanNodeKind.GROUP -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.agg";
            case DBCPlanNodeKind.MATERIALIZE -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.agg";
            case DBCPlanNodeKind.FUNCTION -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.proc";
            case DBCPlanNodeKind.MODIFY -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.edit";
            default -> "com.dbeaver.ui.editors.sql.plan.diagram.nodeType.table";
        };
    }

    private void renderCaption() {
        Text text;
        int leftPos;
        SQLPlanNode node = this.renderInfo.getNode();
        Diagram diagram = this.renderInfo.getTargetDiagram();
        String nodeCaption = this.getNodeCaption();
        Font font = this.getCaptionFont(diagram);
        int recWidth = this.renderInfo.getShape().getWidth();
        IDimension captionSize = GraphitiUi.getUiLayoutService().calculateTextSize(nodeCaption, font, true);
        int n = leftPos = this.renderInfo.getCostBar() == null ? 0 : this.renderInfo.getCostBar().getX() + this.renderInfo.getCostBar().getWidth();
        if (captionSize.getHeight() < 18) {
            captionSize.setHeight(18);
        }
        if ((text = this.renderInfo.getCaptionText()) == null) {
            Shape shapeName = peCreateService.createShape(this.renderInfo.getContainerShape(), false);
            text = gaService.createPlainText((GraphicsAlgorithmContainer)shapeName, nodeCaption);
            this.renderInfo.setCaptionText(text);
            text.setForeground(this.getStandardColor((IColorConstant)StyleUtil.NODE_TEXT_FOREGROUND));
            text.setFilled(Boolean.valueOf(false));
            text.setFont(font);
            text.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
        } else {
            text.setValue(nodeCaption);
        }
        gaService.setLocationAndSize((GraphicsAlgorithm)text, leftPos + 6, 2, captionSize.getWidth() + 4, captionSize.getHeight() + 2);
        Image captionIcon = this.renderInfo.getCaptionIcon();
        if (captionIcon == null) {
            Shape shapeIcon = peCreateService.createShape(this.renderInfo.getContainerShape(), false);
            captionIcon = gaService.createImage((GraphicsAlgorithmContainer)shapeIcon, this.evalNodeIcon(node));
            captionIcon.setStretchH(Boolean.valueOf(true));
            captionIcon.setStretchV(Boolean.valueOf(true));
            captionIcon.setProportional(Boolean.valueOf(true));
            this.renderInfo.setCaptionIcon(captionIcon);
        }
        gaService.setLocationAndSize((GraphicsAlgorithm)captionIcon, recWidth - 16 - 2, 2, 16, 16);
        if (node.isCollapsed()) {
            textStyleRegion = gaService.createTextStyleRegion((AbstractText)text, 0, nodeCaption.length() + 1);
            TextStyle textStyle = gaService.createTextStyle(textStyleRegion, false, false, UnderlineStyle.UNDERLINE_ERROR);
            textStyle.setFont(font);
        } else {
            textStyleRegion = gaService.createTextStyleRegion((AbstractText)text, 0, nodeCaption.length() - 1);
            TextStyle textStyle = gaService.createTextStyle(textStyleRegion, false, false, UnderlineStyle.UNDERLINE_ERROR);
            textStyle.setFont(font);
        }
    }

    private String generateRows(boolean showDetails, SQLPlanNode node) {
        StringBuilder costText = new StringBuilder();
        if (showDetails) {
            costText.append("Rows: ");
        }
        String rowsValuePlain = String.valueOf(node.getRows());
        String rowsValuePercent = String.format(" (%.2f%%)", node.getPercent() * 100.0);
        costText.append(rowsValuePlain).append(rowsValuePercent);
        return costText.toString();
    }

    private String generateDuration(boolean showDetails, SQLPlanNode node) {
        String durationTiming;
        StringBuilder costText = new StringBuilder();
        if (showDetails) {
            costText.append("Time: ");
        }
        if ((durationTiming = (String)node.getPlan().getSourcePlan().getPlanFeature("plan.duration.measure")) == null) {
            durationTiming = DEFAULT_DURATION_TIMING;
        }
        String durationValuePlain = String.valueOf((long)node.getDuration());
        costText.append(durationValuePlain).append(durationTiming);
        return costText.toString();
    }

    private String generateCostRows(SQLPlanNode node) {
        DBCPlan sourcePlan = node.getPlan().getSourcePlan();
        boolean showDetails = this.renderInfo.getNode().isDetailsVisible();
        StringBuilder costText = new StringBuilder();
        if (Boolean.TRUE.equals(sourcePlan.getPlanFeature("plan.cost"))) {
            if (showDetails) {
                costText.append("Cost: ");
            }
            costText.append(CommonUtils.niceFormatDouble((double)node.getCost()));
        }
        if (Boolean.TRUE.equals(sourcePlan.getPlanFeature("plan.duration"))) {
            costText.append("\n");
            costText.append(this.generateDuration(showDetails, node));
        }
        if (Boolean.TRUE.equals(sourcePlan.getPlanFeature("plan.rows"))) {
            costText.append("\n");
            costText.append(this.generateRows(showDetails, node));
        }
        return costText.toString();
    }

    private void renderCost() {
        SQLPlanNode node = this.renderInfo.getNode();
        String nodeCost = this.generateCostRows(node);
        Font font = this.getDefaultFont();
        IDimension costRectSize = GraphitiUi.getUiLayoutService().calculateTextSize(nodeCost, this.getDefaultBoldFont(), true);
        AbstractText textCost = this.renderInfo.getCostText();
        if (textCost == null) {
            Shape shapeName = peCreateService.createShape(this.renderInfo.getContainerShape(), false);
            textCost = gaService.createMultiText((GraphicsAlgorithmContainer)shapeName, nodeCost);
            this.renderInfo.setCostText(textCost);
            textCost.setFont(font);
            textCost.setFilled(Boolean.valueOf(false));
            textCost.setForeground(this.getStandardColor((IColorConstant)StyleUtil.NODE_TEXT_FOREGROUND));
            textCost.setVerticalAlignment(Orientation.ALIGNMENT_TOP);
            textCost.setHorizontalAlignment(Orientation.ALIGNMENT_RIGHT);
        } else {
            textCost.setValue(nodeCost);
        }
        if (!CommonUtils.isEmpty((Collection)textCost.getStyleRegions())) {
            textCost.getStyleRegions().clear();
        }
        Matcher matcher = DIGITS_PATTERN.matcher(nodeCost);
        while (matcher.find()) {
            TextStyleRegion textStyleRegion = gaService.createTextStyleRegion(textCost, matcher.start(1), matcher.end(1) - 1);
            TextStyle textStyle = gaService.createTextStyle(textStyleRegion, false, false, UnderlineStyle.UNDERLINE_ERROR);
            textStyle.setFont(this.getDefaultBoldFont());
        }
        int recWidth = this.renderInfo.getShape().getWidth();
        int recHeight = this.renderInfo.getShape().getHeight();
        gaService.setLocationAndSize((GraphicsAlgorithm)textCost, recWidth - 4 - costRectSize.getWidth() - 6, recHeight - (costRectSize.getHeight() + 6), costRectSize.getWidth() + 6, costRectSize.getHeight() + 2 + 4);
    }

    private void renderDescription() {
        String description = this.getNodeDescription();
        if (description == null) {
            return;
        }
        Font font = this.renderInfo.getNode().isDetailsVisible() ? this.getDefaultBoldFont() : this.getDefaultFont();
        IDimension rowsRectSize = GraphitiUi.getUiLayoutService().calculateTextSize(description, font);
        int leftPos = this.renderInfo.getCostBar() == null ? 0 : this.renderInfo.getCostBar().getX() + this.renderInfo.getCostBar().getWidth();
        Text titleText = this.renderInfo.getDescriptionText();
        if (titleText == null) {
            Shape shapeName = peCreateService.createShape(this.renderInfo.getContainerShape(), false);
            titleText = gaService.createPlainText((GraphicsAlgorithmContainer)shapeName, description);
            this.renderInfo.setDescriptionText(titleText);
            titleText.setFilled(Boolean.valueOf(false));
            titleText.setForeground(this.getStandardColor((IColorConstant)StyleUtil.NODE_TEXT_FOREGROUND));
            titleText.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
        } else {
            titleText.setValue(description);
        }
        titleText.setFont(font);
        gaService.setLocationAndSize((GraphicsAlgorithm)titleText, leftPos + 8, this.renderInfo.getCaptionText().getHeight() + 2, rowsRectSize.getWidth(), rowsRectSize.getHeight() + 2);
    }

    private void renderDetails() {
        String details = this.getNodeDetails();
        if (details.isEmpty()) {
            return;
        }
        boolean detailsVisible = this.renderInfo.getNode().isDetailsVisible();
        Text detailsText = this.renderInfo.getDetailsText();
        if (!detailsVisible) {
            this.hideItem((GraphicsAlgorithm)detailsText);
            this.hideItem((GraphicsAlgorithm)this.renderInfo.getDetailsTopLine());
            this.hideItem((GraphicsAlgorithm)this.renderInfo.getDetailsBottomLine());
        } else {
            Font font = this.getDefaultFont();
            IDimension detailsRectSize = GraphitiUi.getUiLayoutService().calculateTextSize(details, font, true);
            detailsRectSize.setHeight(detailsRectSize.getHeight() + 4);
            if (detailsRectSize.getWidth() > 450) {
                detailsRectSize.setWidth(450);
            }
            if (detailsRectSize.getHeight() > 500) {
                detailsRectSize.setHeight(500);
            }
            if (detailsText == null || detailsText.getPictogramElement() == null) {
                Shape shapeName = peCreateService.createShape(this.renderInfo.getContainerShape(), false);
                detailsText = gaService.createPlainText((GraphicsAlgorithmContainer)shapeName, details);
                this.renderInfo.setDetailsText(detailsText);
                detailsText.setFont(font);
                detailsText.setFilled(Boolean.valueOf(false));
                detailsText.setForeground(this.getStandardColor((IColorConstant)StyleUtil.NODE_TEXT_FOREGROUND));
                detailsText.setVerticalAlignment(Orientation.ALIGNMENT_TOP);
                detailsText.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
            } else {
                detailsText.getPictogramElement().setVisible(true);
                detailsText.setValue(details);
            }
            if (!CommonUtils.isEmpty((Collection)detailsText.getStyleRegions())) {
                detailsText.getStyleRegions().clear();
            }
            Matcher matcher = DETAILS_HEADER_PATTERN.matcher(details);
            while (matcher.find()) {
                TextStyleRegion textStyleRegion = gaService.createTextStyleRegion((AbstractText)detailsText, matcher.start(), matcher.end() - 1);
                TextStyle textStyle = gaService.createTextStyle(textStyleRegion, false, false, UnderlineStyle.UNDERLINE_ERROR);
                textStyle.setFont(this.getDefaultBoldFont());
            }
            int topPos = this.renderInfo.getCaptionText().getHeight() + 2;
            if (this.renderInfo.getDescriptionText() != null) {
                topPos += this.renderInfo.getDescriptionText().getHeight() + 2;
            }
            int leftPos = this.renderInfo.getCostBar() == null ? 0 : this.renderInfo.getCostBar().getX() + this.renderInfo.getCostBar().getWidth();
            gaService.setLocationAndSize((GraphicsAlgorithm)detailsText, leftPos + 4, topPos + 2, detailsRectSize.getWidth() + leftPos, detailsRectSize.getHeight() + 2);
            Polyline topLine = this.renderInfo.getDetailsTopLine();
            if (topLine == null) {
                Shape topLineShape = peCreateService.createShape(this.renderInfo.getContainerShape(), false);
                int[] nArray = new int[4];
                nArray[1] = topPos;
                nArray[2] = this.renderInfo.getShape().getWidth();
                nArray[3] = topPos;
                topLine = gaService.createPlainPolyline((GraphicsAlgorithmContainer)topLineShape, nArray);
                topLine.setStyle(StyleUtil.getStyleForNode(this.renderInfo.getTargetDiagram(), this.renderInfo.getNode()));
                this.renderInfo.setDetailsTopLine(topLine);
            } else {
                if (((Point)topLine.getPoints().get(1)).getX() != this.renderInfo.getShape().getWidth()) {
                    ((Point)topLine.getPoints().get(1)).setX(this.renderInfo.getShape().getWidth());
                }
                topLine.getPictogramElement().setVisible(true);
            }
            Polyline bottomLine = this.renderInfo.getDetailsBottomLine();
            int bottomPos = this.renderInfo.getCostText() != null ? this.renderInfo.getCostText().getY() - 2 : topPos + detailsRectSize.getHeight() - 2;
            if (bottomLine == null) {
                Shape bottomLineShape = peCreateService.createShape(this.renderInfo.getContainerShape(), false);
                int[] nArray = new int[4];
                nArray[1] = bottomPos;
                nArray[2] = this.renderInfo.getShape().getWidth();
                nArray[3] = bottomPos;
                bottomLine = gaService.createPlainPolyline((GraphicsAlgorithmContainer)bottomLineShape, nArray);
                bottomLine.setStyle(StyleUtil.getStyleForNode(this.renderInfo.getTargetDiagram(), this.renderInfo.getNode()));
                this.renderInfo.setDetailsBottomLine(bottomLine);
            } else {
                if (((Point)bottomLine.getPoints().get(1)).getX() != this.renderInfo.getShape().getWidth()) {
                    ((Point)bottomLine.getPoints().get(1)).setX(this.renderInfo.getShape().getWidth());
                }
                ((Point)bottomLine.getPoints().get(0)).setY(bottomPos);
                ((Point)bottomLine.getPoints().get(1)).setY(bottomPos);
                bottomLine.getPictogramElement().setVisible(true);
            }
            this.costBarDetails(topPos + 6, bottomPos - (topPos + 6) - 4);
        }
    }

    private String getNodeDetails() {
        return this.renderInfo.getNodeDetails();
    }

    private void hideItem(GraphicsAlgorithm item) {
        if (item != null) {
            item.getPictogramElement().setVisible(false);
            gaService.setSize(item, 0, 0);
        }
    }

    public void render() {
        DBCPlan sourcePlan = this.renderInfo.getNode().getPlan().getSourcePlan();
        if (Boolean.TRUE.equals(sourcePlan.getPlanFeature("plan.cost")) || Boolean.TRUE.equals(sourcePlan.getPlanFeature("plan.rows")) || Boolean.TRUE.equals(sourcePlan.getPlanFeature("plan.duration"))) {
            this.renderCost();
            this.renderCostBar();
        }
        this.renderCaption();
        this.renderDescription();
        this.renderDetails();
        this.renderShape();
    }

    public static void render(PictogramElement pictogramElement) {
        PlanNodeRenderInfo renderInfo = PlanNodeRender.getRenderInfo(pictogramElement);
        if (renderInfo != null) {
            PlanNodeRender nodeRender = new PlanNodeRender(renderInfo);
            nodeRender.render();
        }
    }

    public void computeSize() {
        int width = 4;
        int height = 4;
        SQLPlanNode node = this.renderInfo.getNode();
        String nodeCaption = this.getNodeCaption();
        Font captionFont = this.getCaptionFont(this.diagram);
        Font defFont = this.getDefaultFont();
        Font defBoldFont = this.getDefaultBoldFont();
        IDimension captionSize = GraphitiUi.getUiLayoutService().calculateTextSize(nodeCaption, captionFont, true);
        width += captionSize.getWidth() + 40;
        height += captionSize.getHeight();
        height += GraphitiUi.getUiLayoutService().calculateTextSize(this.generateCostRows(node), defBoldFont, true).getHeight() + 4;
        if (!CommonUtils.isEmpty((String)this.getNodeDescription())) {
            IDimension descSize = GraphitiUi.getUiLayoutService().calculateTextSize(this.getNodeDescription(), defFont);
            height += descSize.getHeight() + 2;
            width = Math.max(width, descSize.getWidth() + 8);
        }
        if (node.isDetailsVisible()) {
            IDimension detailsRectSize = GraphitiUi.getUiLayoutService().calculateTextSize(this.getNodeDetails(), defFont, true);
            height += detailsRectSize.getHeight() + 8 + 6;
            width = Math.max(width, detailsRectSize.getWidth() + 4 + 16);
        }
        this.nodeWidth = Math.min(500, Math.max(120, width));
        this.nodeHeight = Math.min(600, Math.max(80, height));
    }
}

