/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.commands;

import com.dbeaver.ee.vqb.ui.commands.VQBDiagramCommand;
import com.dbeaver.ee.vqb.ui.part.QueryColumnPart;
import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.erd.ERDEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.editors.erd.command.AttributeCheckCommand;
import org.jkiss.dbeaver.ui.editors.erd.part.AttributePart;

public class QueryColumnCheckCommand
extends AttributeCheckCommand<QueryColumnPart>
implements VQBDiagramCommand {
    private static final Log log = Log.getLog(QueryColumnCheckCommand.class);
    private VQBQueryInfo queryInfo;

    public QueryColumnCheckCommand(VQBQueryInfo queryInfo, QueryColumnPart part, boolean newValue) {
        super((AttributePart)part, newValue);
        this.queryInfo = queryInfo;
    }

    public void execute() {
        super.execute();
        this.execute(false);
    }

    public void undo() {
        super.undo();
        this.execute(true);
    }

    public void execute(boolean undo) {
        boolean checked;
        PlainSelect plainSelect = this.queryInfo.getPlainSelect();
        if (plainSelect == null) {
            log.debug((Object)"Can't check columns for non plain select");
            return;
        }
        SelectItem selectItem = (SelectItem)((QueryColumnPart)this.part).getAttribute().getUserData();
        boolean bl = checked = undo ? this.getOldValue() : this.getNewValue();
        if (!checked) {
            if (selectItem != null) {
                plainSelect.getSelectItems().remove(selectItem);
                ((QueryColumnPart)this.part).getAttribute().setUserData(null);
                GroupByElement groupBy = plainSelect.getGroupBy();
                if (groupBy != null) {
                    VQBUtils.removeExpressionFromGrouping((PlainSelect)plainSelect, (SelectItem)selectItem, (GroupByElement)groupBy);
                }
            }
            if (plainSelect.getSelectItems().isEmpty()) {
                plainSelect.getSelectItems().add(new SelectItem((Expression)new AllColumns()));
            }
        } else {
            List selectItems = VQBUtils.getOrCreateSelectItems((PlainSelect)plainSelect);
            if (selectItems.size() == 1 && ((SelectItem)selectItems.get(0)).getExpression() instanceof AllColumns) {
                selectItems.clear();
            }
            ERDEntity erdEntity = ((QueryColumnPart)this.part).getEntity();
            Table table = VQBUtils.getTableFromEntity((ERDEntity)erdEntity);
            selectItem = new SelectItem((Expression)new Column(table, DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)((QueryColumnPart)this.part).getAttribute().getObject()))));
            selectItems.add(selectItem);
            ((QueryColumnPart)this.part).getAttribute().setUserData((Object)selectItem);
        }
    }
}

