/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.tableau.actions;

import com.dbeaver.model.tableau.TBUtils;
import com.dbeaver.model.tableau.navigator.DBNTableauDataSourceConnectionNode;
import com.dbeaver.model.tableau.tds.TDSConnection;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectDataSourceDialog;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class NavigatorHandlerAssociateDataSource
extends NavigatorHandlerObjectBase {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBNTableauDataSourceConnectionNode selectedConnectionNode = null;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            for (Object o : (IStructuredSelection)selection) {
                DBNNode node = (DBNNode)RuntimeUtils.getObjectAdapter(o, DBNNode.class);
                if (!(node instanceof DBNTableauDataSourceConnectionNode)) continue;
                selectedConnectionNode = (DBNTableauDataSourceConnectionNode)node;
                break;
            }
        }
        if (selectedConnectionNode == null) {
            return null;
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        NavigatorHandlerAssociateDataSource.linkConnectionWithDataSource(shell, selectedConnectionNode);
        return null;
    }

    public static boolean linkConnectionWithDataSource(Shell shell, DBNTableauDataSourceConnectionNode selectedConnectionNode) {
        DBPProject project = selectedConnectionNode.getOwnerProject();
        SelectDataSourceDialog dataSourceDialog = new SelectDataSourceDialog(shell, project, null);
        if (dataSourceDialog.open() != 0) {
            return false;
        }
        DBPDataSourceContainer dataSourceContainer = dataSourceDialog.getDataSource();
        if (dataSourceContainer == null) {
            return false;
        }
        return NavigatorHandlerAssociateDataSource.linkConnectionWithDataSource(selectedConnectionNode, dataSourceContainer);
    }

    public static boolean linkConnectionWithDataSource(DBNTableauDataSourceConnectionNode selectedConnectionNode, DBPDataSourceContainer dataSourceContainer) {
        try {
            UIUtils.runInProgressService(monitor -> {
                try {
                    TBUtils.linkDataSourceWithConnection((DBRProgressMonitor)monitor, (DBPDataSourceContainer)dataSourceContainer, (TDSConnection)selectedConnectionNode.getNodeObject());
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Link error", "Error linking connection", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        selectedConnectionNode.getModel().fireNodeUpdate((Object)selectedConnectionNode, (DBNNode)selectedConnectionNode, DBNEvent.NodeChange.REFRESH);
        return true;
    }

    public static boolean unlinkConnectionFromDataSource(DBNTableauDataSourceConnectionNode node, DBPDataSourceContainer dataSourceContainer) {
        try {
            UIUtils.runInProgressService(monitor -> {
                try {
                    TBUtils.unlinkDataSourceWithConnection((DBRProgressMonitor)monitor, (DBPDataSourceContainer)dataSourceContainer, (TDSConnection)node.getNodeObject());
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Link error", "Error linking connection", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        node.getModel().fireNodeUpdate((Object)node, (DBNNode)node, DBNEvent.NodeChange.REFRESH);
        return true;
    }
}

