/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.tableau.pref;

import com.dbeaver.model.tableau.TBDataSource;
import com.dbeaver.model.tableau.TBDataSourceRevision;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class TableauDataSourceEditDialog
extends BaseDialog {
    @NotNull
    private final TBDataSource dataSource;

    public TableauDataSourceEditDialog(@NotNull Shell shell, @NotNull TBDataSource dataSource) {
        super(shell, "Edit Tableau Data Source", null);
        this.dataSource = dataSource;
        this.setShellStyle(67696);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        CTabFolder tabFolder = new CTabFolder(composite, 128);
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.createInfoTab(tabFolder);
        this.createRevisions(tabFolder);
        tabFolder.setSelection(0);
        return composite;
    }

    private void createInfoTab(CTabFolder tabFolder) {
        CTabItem item = new CTabItem(tabFolder, 0);
        item.setText("Information");
        Composite infoPanel = UIUtils.createComposite((Composite)tabFolder, (int)2);
        UIUtils.createLabelText((Composite)infoPanel, (String)"ID", (String)this.dataSource.getId(), (int)2056);
        UIUtils.createLabelText((Composite)infoPanel, (String)"Name", (String)this.dataSource.getName(), (int)2056);
        UIUtils.createLabelText((Composite)infoPanel, (String)"Description", (String)this.dataSource.getDescription(), (int)2056);
        UIUtils.createLabelText((Composite)infoPanel, (String)"Created At", (String)this.dataSource.getCreatedAt(), (int)2056);
        UIUtils.createLabelText((Composite)infoPanel, (String)"Updated At", (String)this.dataSource.getUpdatedAt(), (int)2056);
        UIUtils.createLabelText((Composite)infoPanel, (String)"Project", (String)this.dataSource.getProject().getName(), (int)2056);
        if (!CommonUtils.isEmpty((String)this.dataSource.getWebpageURL())) {
            UIUtils.createControlLabel((Composite)infoPanel, (String)"Web page");
            UIUtils.createLink((Composite)infoPanel, (String)("<a>" + this.dataSource.getWebpageURL() + "</a>"), (SelectionListener)SelectionListener.widgetSelectedAdapter(selectionEvent -> ShellUtils.launchProgram((String)this.dataSource.getWebpageURL())));
        }
        item.setControl((Control)infoPanel);
    }

    private void createRevisions(CTabFolder tabFolder) {
        CTabItem item = new CTabItem(tabFolder, 0);
        item.setText("Revisions");
        Composite revPanel = UIUtils.createComposite((Composite)tabFolder, (int)1);
        revPanel.setLayoutData((Object)new GridData(1808));
        Table revTable = new Table(revPanel, 67584);
        revTable.setLayoutData((Object)new GridData(1808));
        revTable.setHeaderVisible(true);
        UIUtils.createTableColumn((Table)revTable, (int)16384, (String)"Number");
        UIUtils.createTableColumn((Table)revTable, (int)16384, (String)"Time");
        UIUtils.createTableColumn((Table)revTable, (int)16384, (String)"Publisher");
        UIUtils.createTableColumn((Table)revTable, (int)16384, (String)"Size");
        this.loadRevisions(revTable);
        item.setControl((Control)revPanel);
    }

    private void loadRevisions(Table revTable) {
        try {
            UIUtils.runInProgressDialog(monitor -> {
                try {
                    List revisions = this.dataSource.getRevisions(monitor);
                    UIUtils.syncExec(() -> {
                        for (TBDataSourceRevision rev : revisions) {
                            TableItem item = new TableItem(revTable, 0);
                            item.setData((Object)rev);
                            item.setText(0, rev.getName());
                            item.setText(1, rev.getPublishedAt());
                            item.setText(2, rev.getPublisher());
                            item.setText(3, rev.getSize() == null ? "N/A" : NumberFormat.getInstance().format(rev.getSize()));
                        }
                        UIUtils.packColumns((Table)revTable);
                    });
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Revisions load error", "Error loading datasource revisions", (Throwable)e);
        }
    }
}

