/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.tableau.pref;

import com.dbeaver.model.tableau.auth.TBAuthConfiguration;
import com.dbeaver.model.tableau.auth.TBAuthProfile;
import com.dbeaver.ui.tableau.pref.TableauProfileEditDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.utils.CommonUtils;

public class TableauPreferencePage
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    private static final Log log = Log.getLog(TableauPreferencePage.class);
    public static final String PAGE_ID = "com.dbeaver.preferences.tableau";
    private ListViewer profilesViewer;
    private final List<TBAuthProfile> profiles = new ArrayList<TBAuthProfile>();
    private Button tableauEnabledCheck;
    private Button autoAssocConnectionsCheck;

    protected void performDefaults() {
        this.profiles.clear();
        this.profiles.addAll(TBAuthConfiguration.getConfiguration().getGlobalProfiles());
        this.profilesViewer.refresh();
        this.profilesViewer.getList().notifyListeners(13, new Event());
    }

    public boolean performOk() {
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        preferenceStore.setValue("tableau.enabled", this.tableauEnabledCheck.getSelection());
        preferenceStore.setValue("tableau.autoAssociateConnections", this.autoAssocConnectionsCheck.getSelection());
        return true;
    }

    @Nullable
    private TBAuthProfile editProfile(@Nullable TBAuthProfile profile) {
        TableauProfileEditDialog dialog = new TableauProfileEditDialog(this.getShell(), profile);
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        Composite placeholder = UIUtils.createPlaceholder((Composite)parent, (int)1);
        placeholder.setLayoutData((Object)new GridData(1808));
        Group group = UIUtils.createControlGroup((Composite)placeholder, (String)"Settings", (int)2, (int)768, (int)300);
        this.tableauEnabledCheck = UIUtils.createCheckbox((Composite)group, (String)"Enable Tableau integration", (String)"Enable Tableau in connections and UI", (boolean)false, (int)1);
        this.tableauEnabledCheck.setSelection(preferenceStore.getBoolean("tableau.enabled"));
        group = UIUtils.createControlGroup((Composite)placeholder, (String)"Tableau profiles", (int)2, (int)768, (int)300);
        this.profilesViewer = new ListViewer((Composite)group, 2820);
        this.profilesViewer.getList().setLayoutData((Object)new GridData(4, 4, true, true));
        this.profilesViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.profilesViewer.setInput(this.profiles);
        this.profilesViewer.addDoubleClickListener(event -> this.editSelectedProfile());
        ToolBar toolbar = new ToolBar((Composite)group, 512);
        toolbar.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 1).create());
        UIUtils.createToolItem((ToolBar)toolbar, (String)"Add profile", (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TBAuthProfile profile = TableauPreferencePage.this.editProfile(null);
                if (profile != null) {
                    try {
                        TBAuthConfiguration.getConfiguration().addProfile(profile);
                    }
                    catch (DBException ex) {
                        DBWorkbench.getPlatformUI().showError("Configuration save error", "Error adding Tableau profile", (Throwable)ex);
                        return;
                    }
                    TableauPreferencePage.this.profiles.add(profile);
                    TableauPreferencePage.this.profilesViewer.refresh();
                }
            }
        });
        ToolItem removeItem = UIUtils.createToolItem((ToolBar)toolbar, (String)"Remove profile", (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = TableauPreferencePage.this.profilesViewer.getList().getSelectionIndex();
                TBAuthProfile profile = TableauPreferencePage.this.profiles.get(index);
                if (!UIUtils.confirmAction((Shell)TableauPreferencePage.this.getShell(), (String)"Profile delete", (String)("Are you sure you want to delete profile '" + profile.getName() + "'"))) {
                    return;
                }
                try {
                    TableauPreferencePage.this.profiles.remove(index);
                    TBAuthConfiguration.getConfiguration().deleteProfile(profile);
                }
                catch (DBException ex) {
                    DBWorkbench.getPlatformUI().showError("Configuration save error", "Error adding Tableau profile", (Throwable)ex);
                    return;
                }
                TableauPreferencePage.this.profilesViewer.refresh();
                TableauPreferencePage.this.profilesViewer.getList().select(CommonUtils.clamp((int)index, (int)0, (int)(TableauPreferencePage.this.profilesViewer.getList().getItemCount() - 1)));
                TableauPreferencePage.this.profilesViewer.getList().notifyListeners(13, new Event());
            }
        });
        ToolItem editItem = UIUtils.createToolItem((ToolBar)toolbar, (String)"Edit profile", (DBPImage)UIIcon.EDIT, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableauPreferencePage.this.editSelectedProfile();
            }
        });
        Composite buttonComposite = UIUtils.createComposite((Composite)group, (int)2);
        buttonComposite.setLayoutData((Object)new GridData(768));
        UIUtils.createEmptyLabel((Composite)buttonComposite, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        Button connectionTestButton = UIUtils.createDialogButton((Composite)buttonComposite, (String)"Test connection", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TBAuthProfile profile = (TBAuthProfile)TableauPreferencePage.this.profilesViewer.getStructuredSelection().getFirstElement();
                try {
                    UIUtils.getDialogRunnableContext().run(true, true, monitor -> {
                        String serverInfo = TableauPreferencePage.this.testConnection(monitor, profile);
                        DBWorkbench.getPlatformUI().showMessageBox("Success", "Connected to Tableau server: " + serverInfo, false);
                    });
                }
                catch (InvocationTargetException e) {
                    DBWorkbench.getPlatformUI().showError("Connection error", "Error while connection to Tableau server", e.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.profilesViewer.addSelectionChangedListener(event -> {
            boolean enabled = !this.profilesViewer.getStructuredSelection().isEmpty();
            removeItem.setEnabled(enabled);
            editItem.setEnabled(enabled);
            connectionTestButton.setEnabled(enabled);
        });
        group = UIUtils.createControlGroup((Composite)placeholder, (String)"Configuration", (int)2, (int)768, (int)300);
        this.autoAssocConnectionsCheck = UIUtils.createCheckbox((Composite)group, (String)"Automatically associate Tableau connections", (String)"Automatically associate Tableau connections with DBeaver data sources", (boolean)false, (int)1);
        this.autoAssocConnectionsCheck.setSelection(preferenceStore.getBoolean("tableau.autoAssociateConnections"));
        UIUtils.createInfoLabel((Composite)placeholder, (String)"Show Tableau sites manager", () -> {
            try {
                UIUtils.getActiveWorkbenchWindow().getActivePage().showView("com.dbeaver.tableau.sites");
            }
            catch (PartInitException e1) {
                DBWorkbench.getPlatformUI().showError("Show view", "Error opening Tableau view", (Throwable)e1);
            }
        });
        this.performDefaults();
        return placeholder;
    }

    private void editSelectedProfile() {
        TBAuthProfile original = (TBAuthProfile)this.profilesViewer.getStructuredSelection().getFirstElement();
        if (original == null) {
            return;
        }
        try {
            original.resolveCredentials();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Configuration load error", "Error resolving Tableau profile secrets", (Throwable)e);
        }
        original.getName();
        TBAuthProfile profile = this.editProfile(original);
        if (profile != null) {
            int index = this.profiles.indexOf(original);
            this.profiles.set(index, profile);
            try {
                TBAuthConfiguration.getConfiguration().updateProfile(profile);
            }
            catch (DBException ex) {
                DBWorkbench.getPlatformUI().showError("Configuration save error", "Error adding Tableau profile", (Throwable)ex);
                return;
            }
            this.profilesViewer.refresh();
            this.profilesViewer.getList().select(index);
            this.profilesViewer.getList().notifyListeners(13, new Event());
        }
    }

    public void init(IWorkbench workbench) {
    }

    private String testConnection(@NotNull DBRProgressMonitor monitor, @NotNull TBAuthProfile profile) throws InvocationTargetException {
        monitor.beginTask("Test Tableau connection " + profile.getName(), 1);
        try {
            String string = profile.testConnection(monitor);
            return string;
        }
        catch (DBException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            monitor.done();
        }
    }
}

