/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.debug.internal.impl;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.debug.DBGBreakpointDescriptor;
import org.jkiss.utils.CommonUtils;

public class PostgreDebugBreakpointDescriptor
implements DBGBreakpointDescriptor {
    private final Object oid;
    private final long lineNo;
    private final boolean onStart;
    private final long targetId;
    private final boolean all;

    public PostgreDebugBreakpointDescriptor(Object oid, long lineNo) {
        this.oid = oid;
        this.lineNo = lineNo;
        this.onStart = lineNo < 0L;
        this.targetId = -1L;
        this.all = true;
    }

    public Object getObjectId() {
        return this.oid;
    }

    public long getLineNo() {
        return this.lineNo;
    }

    public boolean isOnStart() {
        return this.onStart;
    }

    public long getTargetId() {
        return this.targetId;
    }

    public boolean isAll() {
        return this.all;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PG.ATTR_FUNCTION_OID", String.valueOf(this.oid));
        map.put("onStart", this.onStart);
        map.put("targetId", String.valueOf(this.targetId));
        map.put("all", this.all);
        return map;
    }

    public static DBGBreakpointDescriptor fromMap(Map<String, Object> attributes) {
        long oid = CommonUtils.toLong((Object)attributes.get("PG.ATTR_FUNCTION_OID"));
        long parsed = CommonUtils.toLong((Object)attributes.get("lineNumber"));
        return new PostgreDebugBreakpointDescriptor(oid, parsed);
    }

    public String toString() {
        return "PostgreDebugBreakpointDescriptor [obj=" + String.valueOf(this.oid) + ", properties=" + String.valueOf(this.toMap()) + "]";
    }
}

