/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model;

import com.dbeaver.data.compare.model.DCChangeRelation;
import com.dbeaver.data.compare.model.tasks.DCCompareTaskSettings;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.transfer.DTUtils;

public class DCInput
implements AutoCloseable {
    private final DBCExecutionContext executionContext;
    private final DBSDataContainer container;
    private final DBSAttributeBase[] keys;
    private final DBDDataFilter filter;
    private final boolean useIsolatedExecutionContext;

    private DCInput(@NotNull DBCExecutionContext executionContext, @NotNull DBSDataContainer container, @NotNull DBSAttributeBase[] keys, @NotNull DBDDataFilter filter, boolean useIsolatedExecutionContext) {
        this.executionContext = executionContext;
        this.container = container;
        this.keys = keys;
        this.filter = filter;
        this.useIsolatedExecutionContext = useIsolatedExecutionContext;
    }

    @NotNull
    public static DCInput create(@NotNull DBRProgressMonitor monitor, @NotNull DCCompareTaskSettings settings, @NotNull DCChangeRelation relation) throws DBException {
        DBCTransactionManager txnManager;
        DBSDataContainer container = relation.isSource() ? settings.getLeftContainer() : settings.getRightContainer();
        DBSAttributeBase[] keys = relation.isSource() ? settings.getLeftKeys() : settings.getRightKeys();
        DBDDataFilter filter = DCInput.createFilter(monitor, container, keys);
        boolean useIsolatedExecutionContext = DCInput.useIsolatedExecutionContext(settings, container);
        DBCExecutionContext executionContext = DCInput.obtainExecutionContext(monitor, container, useIsolatedExecutionContext);
        if (useIsolatedExecutionContext && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)executionContext)) != null && txnManager.isAutoCommit()) {
            txnManager.setAutoCommit(monitor, false);
        }
        return new DCInput(executionContext, container, keys, filter, useIsolatedExecutionContext);
    }

    @NotNull
    public String getName() {
        if (!(this.container instanceof SQLQueryContainer)) {
            return DBUtils.getObjectFullName((DBPNamedObject)this.container, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        String name = "<Query>";
        return name + " (" + this.container.getDataSource().getName() + ")";
    }

    @NotNull
    public String getDescription() {
        return DBUtils.getObjectFullName((DBPNamedObject)this.container, (DBPEvaluationContext)DBPEvaluationContext.UI);
    }

    @NotNull
    public DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    public DBSDataContainer getContainer() {
        return this.container;
    }

    @NotNull
    public DBSAttributeBase[] getKeys() {
        return this.keys;
    }

    @NotNull
    public DBDDataFilter getFilter() {
        return this.filter;
    }

    @Override
    public void close() {
        if (this.useIsolatedExecutionContext) {
            DBUtils.closeSafely((AutoCloseable)this.executionContext);
        }
    }

    @NotNull
    private static DBDDataFilter createFilter(@NotNull DBRProgressMonitor monitor, @NotNull DBSDataContainer container, @NotNull DBSAttributeBase[] keys) throws DBException {
        ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>();
        DBDDataFilter filter = new DBDDataFilter(constraints);
        for (DBSAttributeBase attribute : DTUtils.getAttributes((DBRProgressMonitor)monitor, (DBSDataContainer)container, (Object)container)) {
            constraints.add(new DBDAttributeConstraint(attribute, constraints.size() + 1));
        }
        DBSAttributeBase[] dBSAttributeBaseArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            DBSAttributeBase key = dBSAttributeBaseArray[n2];
            DBDAttributeConstraint constraint = filter.getConstraint(key, true);
            if (constraint != null) {
                constraint.setOrderPosition(filter.getMaxOrderingPosition() + 1);
            }
            ++n2;
        }
        return new DBDDataFilter(constraints);
    }

    @NotNull
    private static DBCExecutionContext obtainExecutionContext(@NotNull DBRProgressMonitor monitor, @NotNull DBSDataContainer container, boolean isolated) throws DBException {
        return isolated ? DBUtils.getObjectOwnerInstance((DBSObject)container).openIsolatedContext(monitor, "Data compare", null) : DBUtils.getDefaultContext((DBSObject)container, (boolean)false);
    }

    private static boolean useIsolatedExecutionContext(@NotNull DCCompareTaskSettings settings, @NotNull DBSDataContainer container) {
        DBPDataSourceContainer dataSourceContainer = DBUtils.getContainer((DBSObject)container);
        return settings.isOpenNewConnections() || dataSourceContainer == null || !dataSourceContainer.getDriver().isEmbedded();
    }
}

