/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.impl;

import com.dbeaver.data.compare.model.DCInput;
import com.dbeaver.data.compare.model.DCSettings;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.GeneralUtils;

class DCDataReceiver
extends AbstractJob
implements DBDDataReceiver {
    private static final Log log = Log.getLog(DCDataReceiver.class);
    private final DBCStatistics statistics = new DBCStatistics();
    private final DCSettings settings;
    private final DCInput input;
    private final Deque<Row> queue;
    private final int capacity;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();
    private DBDAttributeBinding[] keys;
    private DBDAttributeBinding[] attributes;
    private DBDValueHandler[] handlers;
    private boolean closed;

    DCDataReceiver(@NotNull DCSettings settings, @NotNull DCInput input) {
        super("Data Compare Receiver [" + input.getName() + "]");
        this.settings = settings;
        this.input = input;
        this.capacity = settings.getFetchSize() > 0 ? settings.getFetchSize() : 100;
        this.queue = new ArrayDeque<Row>(this.capacity);
    }

    @NotNull
    public DBCStatistics getStatistics() {
        return this.statistics;
    }

    protected IStatus run(DBRProgressMonitor monitor) {
        DBSDataContainer dataContainer = this.input.getContainer();
        DBDDataFilter filter = this.input.getFilter();
        DBCExecutionContext executionContext = this.input.getExecutionContext();
        AbstractExecutionSource executionSource = new AbstractExecutionSource(dataContainer, executionContext, (Object)this);
        try {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (DBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Data compare data read");){
                    session.enableLogging(false);
                    Log.setLogWriter((OutputStream)this.settings.getOutputLogStream());
                    monitor.beginTask("Read data to compare", 1);
                    this.statistics.accumulate(dataContainer.readData((DBCExecutionSource)executionSource, session, (DBDDataReceiver)this, filter, 0L, 0L, 0L, this.settings.getFetchSize()));
                    monitor.worked(1);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (TerminationException terminationException) {
                monitor.done();
                Log.setLogWriter(null);
            }
            catch (Throwable e) {
                this.closed = true;
                IStatus iStatus = GeneralUtils.makeErrorStatus((String)"Error reading data", (Throwable)e);
                monitor.done();
                Log.setLogWriter(null);
                return iStatus;
            }
        }
        finally {
            monitor.done();
            Log.setLogWriter(null);
        }
        return Status.OK_STATUS;
    }

    protected void canceling() {
        Thread thread = this.getThread();
        if (thread != null) {
            thread.interrupt();
        } else {
            log.warn((Object)("Can't interrupt job " + this.getName() + " - no thread"));
        }
    }

    public void fetchStart(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
        this.attributes = DBUtils.getAttributeBindings((DBCSession)session, (DBSDataContainer)this.input.getContainer(), (DBCResultSetMetaData)resultSet.getMeta());
        this.keys = (DBDAttributeBinding[])Arrays.stream(this.input.getKeys()).map(x -> DBUtils.findBinding((DBDAttributeBinding[])this.attributes, (DBSAttributeBase)x)).toArray(DBDAttributeBinding[]::new);
        this.handlers = (DBDValueHandler[])Arrays.stream(this.attributes).map(x -> DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)x)).toArray(DBDValueHandler[]::new);
    }

    public void fetchRow(@NotNull DBCSession session, @NotNull DBCResultSet resultSet) throws DBCException {
        if (this.isCanceled() || this.closed) {
            throw new TerminationException();
        }
        Object[] values = new Object[this.attributes.length];
        int index = 0;
        while (index < this.attributes.length) {
            values[index] = this.handlers[index].getValueFromObject(session, (DBSTypedObject)this.attributes[index], resultSet.getAttributeValue(index), false, false);
            ++index;
        }
        try {
            this.put(new Row(values));
        }
        catch (InterruptedException interruptedException) {
            throw new TerminationException();
        }
    }

    public void fetchEnd(@NotNull DBCSession session, @NotNull DBCResultSet resultSet) {
        try {
            this.lock.lockInterruptibly();
            try {
                this.closed = true;
                this.notEmpty.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public void close() {
        this.closed = true;
    }

    @NotNull
    public DCInput getInput() {
        return this.input;
    }

    @Nullable
    public Row take() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.queue.isEmpty() && !this.closed) {
                this.notEmpty.await();
            }
            Row row = this.queue.pollFirst();
            this.notFull.signal();
            Row row2 = row;
            return row2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void put(@NotNull Row row) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.queue.size() == this.capacity) {
                this.notFull.await();
            }
            this.queue.offer(row);
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    static /* synthetic */ DBDAttributeBinding[] access$0(DCDataReceiver dCDataReceiver) {
        return dCDataReceiver.attributes;
    }

    public class Row {
        private final Object[] values;

        public Row(Object[] values) {
            this.values = values;
        }

        public int compareKeys(@NotNull Row other) {
            int index = 0;
            while (index < DCDataReceiver.this.keys.length) {
                Object targetValue;
                Object sourceValue = DBUtils.getAttributeValue((DBDAttributeBinding)DCDataReceiver.this.keys[index], (DBDAttributeBinding[])DCDataReceiver.this.attributes, (Object[])this.values);
                int result = DBUtils.compareDataValues((Object)sourceValue, (Object)(targetValue = DBUtils.getAttributeValue((DBDAttributeBinding)other.getKey(index), (DBDAttributeBinding[])other.getAttributes(), (Object[])other.values)));
                if (result != 0) {
                    return result;
                }
                ++index;
            }
            return 0;
        }

        @NotNull
        public Map<DBDAttributeValue, DBDAttributeValue> compareValues(@NotNull Row other) {
            LinkedHashMap<DBDAttributeValue, DBDAttributeValue> differences = new LinkedHashMap<DBDAttributeValue, DBDAttributeValue>();
            for (Map.Entry<DBSAttributeBase, DBSAttributeBase> mapping : DCDataReceiver.this.settings.getMappings().entrySet()) {
                Object targetValue;
                Object sourceValue = DBUtils.getAttributeValue((DBDAttributeBinding)Objects.requireNonNull(DBUtils.findBinding((DBDAttributeBinding[])DCDataReceiver.this.attributes, (DBSAttributeBase)mapping.getKey())), (DBDAttributeBinding[])DCDataReceiver.this.attributes, (Object[])this.values);
                if (DBUtils.compareDataValues((Object)sourceValue, (Object)(targetValue = DBUtils.getAttributeValue((DBDAttributeBinding)Objects.requireNonNull(DBUtils.findBinding((DBDAttributeBinding[])other.getAttributes(), (DBSAttributeBase)mapping.getValue())), (DBDAttributeBinding[])other.getAttributes(), (Object[])other.values))) == 0) continue;
                differences.put(new DBDAttributeValue(mapping.getKey(), sourceValue), new DBDAttributeValue(mapping.getValue(), targetValue));
            }
            return differences;
        }

        @NotNull
        public DBDAttributeValue[] getAllValues(@NotNull Collection<DBSAttributeBase> mappings) {
            ArrayList<DBDAttributeValue> result = new ArrayList<DBDAttributeValue>(DCDataReceiver.this.keys.length + mappings.size());
            DBDAttributeBinding[] dBDAttributeBindingArray = DCDataReceiver.this.keys;
            int n = DCDataReceiver.this.keys.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding key = dBDAttributeBindingArray[n2];
                result.add(new DBDAttributeValue((DBSAttributeBase)key, DBUtils.getAttributeValue((DBDAttributeBinding)key, (DBDAttributeBinding[])DCDataReceiver.this.attributes, (Object[])this.values)));
                ++n2;
            }
            for (DBSAttributeBase mapping : mappings) {
                result.add(new DBDAttributeValue(mapping, DBUtils.getAttributeValue((DBDAttributeBinding)Objects.requireNonNull(DBUtils.findBinding((DBDAttributeBinding[])DCDataReceiver.this.attributes, (DBSAttributeBase)mapping)), (DBDAttributeBinding[])DCDataReceiver.this.attributes, (Object[])this.values)));
            }
            return (DBDAttributeValue[])result.toArray(DBDAttributeValue[]::new);
        }

        @NotNull
        public DBDAttributeValue[] getKeyValues() {
            DBDAttributeValue[] result = new DBDAttributeValue[DCDataReceiver.this.keys.length];
            int i = 0;
            while (i < result.length) {
                result[i] = new DBDAttributeValue((DBSAttributeBase)DCDataReceiver.this.keys[i], DBUtils.getAttributeValue((DBDAttributeBinding)DCDataReceiver.this.keys[i], (DBDAttributeBinding[])DCDataReceiver.this.attributes, (Object[])this.values));
                ++i;
            }
            return result;
        }

        @NotNull
        private DBDAttributeBinding getKey(int index) {
            return DCDataReceiver.this.keys[index];
        }

        @NotNull
        private DBDAttributeBinding[] getAttributes() {
            return DCDataReceiver.this.attributes;
        }

        public String toString() {
            return Arrays.stream(DCDataReceiver.this.keys).map(key -> key.getValueHandler().getValueDisplayString((DBSTypedObject)key, DBUtils.getAttributeValue((DBDAttributeBinding)key, (DBDAttributeBinding[])DCDataReceiver.this.attributes, (Object[])this.values), DBDDisplayFormat.UI)).collect(Collectors.joining(", "));
        }
    }

    private static class TerminationException
    extends DBCException {
        public TerminationException() {
            super(null);
        }
    }
}

