/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.impl.exporter;

import com.dbeaver.data.compare.model.DCChangeRelation;
import com.dbeaver.data.compare.model.DCChangeSet;
import com.dbeaver.data.compare.model.exporter.DCExporter;
import com.dbeaver.data.compare.model.exporter.DCExporterSite;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObjectWithOrdinalPosition;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.DefaultValueHandler;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class DCExporterHTML
implements DCExporter {
    private static final Comparator<DBSAttributeBase> COMPARATOR = Comparator.comparingInt(DBPObjectWithOrdinalPosition::getOrdinalPosition);
    private static final String STYLE_SHEET = "table {\n    border-collapse: collapse;\n    font-family: monospace;\n}\nth, td {\n    border: 1px solid black;\n    padding: 8px;\n    text-align: left;\n    color: black;\n    text-align: left;\n}\nth {\n    background-color: #aaf;\n    padding-bottom: 4px;\n    padding-top: 5px;\n    text-align: left;\n}\ntr {\n    background-color: white;\n}\ncaption {\n  padding: 10px;\n  font-weight: bold;\n}\n.key:after {\n    content: '\u2193';\n    padding-left: 5px;\n}\n.skip:before {\n    content: '...';\n    color: gray;\n}\n.add {\n   background-color: #7fff7f;\n}\n.remove {\n   background-color: #ff7f7f;\n}\n.modify {\n   background-color: #7f7fff;\n}";
    private final SortedMap<DBSAttributeBase, DBSAttributeBase> mappingBySource = new TreeMap<DBSAttributeBase, DBSAttributeBase>(COMPARATOR);
    private final SortedMap<DBSAttributeBase, DBSAttributeBase> mappingByTarget = new TreeMap<DBSAttributeBase, DBSAttributeBase>(COMPARATOR);
    private final Map<DBSAttributeBase, DBDValueHandler> handlers = new IdentityHashMap<DBSAttributeBase, DBDValueHandler>();
    private DCExporterSite site;

    @Override
    public void init(@NotNull DCExporterSite site) {
        this.site = site;
        for (Map.Entry<DBSAttributeBase, DBSAttributeBase> entry : site.getSettings().getMappings().entrySet()) {
            this.mappingBySource.put(entry.getKey(), entry.getValue());
            this.mappingByTarget.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public void exportHeader(@NotNull DBCSession session) throws IOException {
        this.writeln("<!DOCTYPE html>");
        this.writeln("<html>");
        this.writeln("<head><style>table {\n    border-collapse: collapse;\n    font-family: monospace;\n}\nth, td {\n    border: 1px solid black;\n    padding: 8px;\n    text-align: left;\n    color: black;\n    text-align: left;\n}\nth {\n    background-color: #aaf;\n    padding-bottom: 4px;\n    padding-top: 5px;\n    text-align: left;\n}\ntr {\n    background-color: white;\n}\ncaption {\n  padding: 10px;\n  font-weight: bold;\n}\n.key:after {\n    content: '\u2193';\n    padding-left: 5px;\n}\n.skip:before {\n    content: '...';\n    color: gray;\n}\n.add {\n   background-color: #7fff7f;\n}\n.remove {\n   background-color: #ff7f7f;\n}\n.modify {\n   background-color: #7f7fff;\n}</style></head>");
        this.writeln("<body>");
        this.writeln("<table>");
        this.writeln("<caption>" + CommonUtils.escapeHtml((String)this.site.getInput().getName()) + "</caption>");
        this.writeln("<thead>");
        this.writeln("<tr>");
        this.writeln("<th>@@</th>");
        DBSAttributeBase[] dBSAttributeBaseArray = this.site.getInput().getKeys();
        int n = dBSAttributeBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBSAttributeBase attr = dBSAttributeBaseArray[n2];
            this.writeln("<th class=\"key\">" + CommonUtils.escapeHtml((String)attr.getName()) + "</th>");
            ++n2;
        }
        for (DBSAttributeBase attr : this.getMappings(this.site.getRelation()).keySet()) {
            this.writeln("<th colspan=\"2\">" + CommonUtils.escapeHtml((String)attr.getName()) + "</th>");
        }
        this.writeln("</tr>");
        this.writeln("</thead>");
        this.writeln("<tbody>");
    }

    @Override
    public void exportRow(@NotNull DBCSession session, @NotNull DCChangeSet change) throws IOException {
        DCChangeRelation relation = this.site.getRelation();
        switch (change.getChangeType().getRelativeTo(relation)) {
            case INSERT: {
                this.writeln("<tr class=\"add\">");
                this.writeln("<td>" + CommonUtils.escapeHtml((String)"+++") + "</td>");
                DBDAttributeValue[] dBDAttributeValueArray = change.getKeys();
                int n = dBDAttributeValueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DBDAttributeValue dBDAttributeValue = dBDAttributeValueArray[n2];
                    this.writeln("<td>" + this.getValueString(dBDAttributeValue) + "</td>");
                    ++n2;
                }
                for (DBSAttributeBase dBSAttributeBase : this.getMappings(relation.opposite()).keySet()) {
                    this.writeln("<td colspan=\"2\">" + this.getValueString(change.getValue(dBSAttributeBase, relation.opposite())) + "</td>");
                }
                break;
            }
            case DELETE: {
                this.writeln("<tr class=\"remove\">");
                this.writeln("<td>" + CommonUtils.escapeHtml((String)"---") + "</td>");
                DBDAttributeValue[] dBDAttributeValueArray = change.getKeys();
                int n = dBDAttributeValueArray.length;
                int n3 = 0;
                while (n3 < n) {
                    DBDAttributeValue dBDAttributeValue = dBDAttributeValueArray[n3];
                    this.writeln("<td>" + this.getValueString(dBDAttributeValue) + "</td>");
                    ++n3;
                }
                Iterator<DBSAttributeBase> iterator = this.getMappings(relation).keySet().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    this.writeln("<td colspan=\"2\" class=\"skip\"></td>");
                }
                break;
            }
            case UPDATE: {
                this.writeln("<tr>");
                this.writeln("<td class=\"modify\">" + CommonUtils.escapeHtml((String)"->") + "</td>");
                DBDAttributeValue[] dBDAttributeValueArray = change.getKeys();
                int n = dBDAttributeValueArray.length;
                int n4 = 0;
                while (n4 < n) {
                    DBDAttributeValue dBDAttributeValue = dBDAttributeValueArray[n4];
                    this.writeln("<td>" + this.getValueString(dBDAttributeValue) + "</td>");
                    ++n4;
                }
                for (Map.Entry<DBSAttributeBase, DBSAttributeBase> entry : this.getMappings(relation).entrySet()) {
                    if (change.hasValue(entry.getKey(), relation)) {
                        this.writeln("<td class=\"modify\">" + this.getValueString(change.getValue(entry.getKey(), relation)) + "</td>");
                        this.writeln("<td class=\"modify\">" + this.getValueString(change.getValue(entry.getValue(), relation.opposite())) + "</td>");
                        continue;
                    }
                    this.writeln("<td colspan=\"2\" class=\"skip\"></td>");
                }
                break;
            }
        }
        this.writeln("</tr>");
    }

    @Override
    public void exportFooter(@NotNull DBCSession session) throws IOException {
        this.writeln("</tbody>");
        this.writeln("</table>");
        this.writeln("</body>");
        this.writeln("</html>");
    }

    private void writeln(@NotNull String text) throws IOException {
        Writer writer = this.site.getWriter();
        writer.write(text);
        writer.write(10);
    }

    @NotNull
    private Map<DBSAttributeBase, DBSAttributeBase> getMappings(@NotNull DCChangeRelation relation) {
        return relation.isSource() ? this.mappingBySource : this.mappingByTarget;
    }

    @Nullable
    private String getValueString(@NotNull DBDAttributeValue value) {
        Object object = value.getValue();
        if (DBUtils.isNullValue((Object)object)) {
            return null;
        }
        if (object instanceof DBDContent) {
            return "[BLOB]";
        }
        DBDValueHandler handler = this.getValueHandler(value.getAttribute());
        String string = handler.getValueDisplayString((DBSTypedObject)value.getAttribute(), object, DBDDisplayFormat.NATIVE);
        return CommonUtils.escapeHtml((String)string);
    }

    @NotNull
    private DBDValueHandler getValueHandler(@NotNull DBSAttributeBase attribute) {
        return this.handlers.computeIfAbsent(attribute, DCExporterHTML::createValueHandler);
    }

    @NotNull
    private static DBDValueHandler createValueHandler(@NotNull DBSAttributeBase attribute) {
        DBSObject object;
        if (attribute instanceof DBSObject && (object = (DBSObject)attribute).getDataSource() != null) {
            return DBUtils.findValueHandler((DBPDataSource)object.getDataSource(), (DBSTypedObject)attribute);
        }
        return DefaultValueHandler.INSTANCE;
    }
}

