/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.tasks;

import com.dbeaver.data.compare.model.DCChangeOrder;
import com.dbeaver.data.compare.model.DCChangeRelation;
import com.dbeaver.data.compare.model.DCInput;
import com.dbeaver.data.compare.model.DCSettings;
import com.dbeaver.data.compare.model.DCSummary;
import com.dbeaver.data.compare.model.DCUtils;
import com.dbeaver.data.compare.model.exporter.DCExporterDescriptor;
import com.dbeaver.data.compare.model.impl.DCCompareEngineImpl;
import com.dbeaver.data.compare.model.tasks.DCCompareTaskSettings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class DCCompareTaskHandler
implements DBTTaskHandler {
    @NotNull
    public DBTTaskRunStatus executeTask(@NotNull DBRRunnableContext runnableContext, final @NotNull DBTTask task, @NotNull Locale locale, final @NotNull Log log, final @NotNull PrintStream logStream, final @NotNull DBTTaskExecutionListener listener) {
        final DCCompareTaskSettings taskSettings = new DCCompareTaskSettings();
        taskSettings.loadConfiguration(runnableContext, task.getProperties(), task.getProject());
        DBCStatistics statistics = new DBCStatistics();
        try {
            runnableContext.run(true, true, monitor -> {
                DBSDataContainer leftContainer = taskSettings.getLeftContainer();
                DBSDataContainer rightContainer = taskSettings.getRightContainer();
                if (leftContainer == null || rightContainer == null) {
                    DBWorkbench.getPlatformUI().showError("Data Compare", "Containers are missing");
                    return;
                }
                DBSAttributeBase[] leftColumns = taskSettings.getLeftKeys();
                DBSAttributeBase[] rightColumns = taskSettings.getRightKeys();
                if (leftColumns == null || rightColumns == null) {
                    DBWorkbench.getPlatformUI().showError("Data Compare", "Constraint columns are missing");
                    return;
                }
                if (!(taskSettings.isIncludeModifiedRows() || taskSettings.isIncludeDeletedRows() || taskSettings.isIncludeInsertedRows())) {
                    DBWorkbench.getPlatformUI().showError("Data Compare", "At least one row state must be included");
                    return;
                }
                final DCSummary[] summary = new DCSummary[1];
                AbstractJob job = new AbstractJob("Perform data compare"){

                    protected IStatus run(DBRProgressMonitor ignored) {
                        try {
                            Log.setLogWriter((OutputStream)logStream);
                            listener.taskStarted(task);
                            summary[0] = DCCompareTaskHandler.perform(monitor, task, log, logStream, taskSettings);
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        catch (Throwable e) {
                            IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                            return iStatus;
                        }
                        finally {
                            monitor.done();
                            Log.setLogWriter(null);
                        }
                    }
                };
                job.schedule();
                try {
                    while (!job.isFinished()) {
                        job.join(50L, monitor.getNestedMonitor());
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    job.cancel();
                }
                if (job.getResult() != null) {
                    DCSummary result = summary[0];
                    if (result != null) {
                        statistics.accumulate(result.getStatistics());
                    }
                    listener.taskFinished(task, (Object)result, job.getResult().getException(), (Object)taskSettings);
                } else {
                    listener.taskFinished(task, null, null, (Object)taskSettings);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Data Compare", "Error comparing data", e.getTargetException());
        }
        catch (InterruptedException e) {
            log.debug((Object)"Canceled by user", (Throwable)e);
        }
        return DBTTaskRunStatus.makeStatisticsStatus((DBCStatistics)statistics);
    }

    @NotNull
    private static DCSummary perform(@NotNull DBRProgressMonitor monitor, @NotNull DBTTask task, @NotNull Log log, @NotNull PrintStream logStream, @NotNull DCCompareTaskSettings taskSettings) throws DBException, IOException {
        DCInput leftInput = DCInput.create(monitor, taskSettings, DCChangeRelation.SOURCE);
        DCInput rightInput = DCInput.create(monitor, taskSettings, DCChangeRelation.TARGET);
        DCSettings settings = new DCSettings(leftInput, rightInput, taskSettings.getMappings());
        settings.setComparedRowsLimit(taskSettings.getComparedRowsLimit());
        settings.setDifferentRowsLimit(taskSettings.getDifferentRowsLimit());
        settings.setFetchSize(taskSettings.getFetchSize());
        settings.setStoreResultsInMemory(taskSettings.isStoreResultsInMemory());
        settings.setIncludeModifiedRows(taskSettings.isIncludeModifiedRows());
        settings.setIncludeDeletedRows(taskSettings.isIncludeDeletedRows());
        settings.setIncludeInsertedRows(taskSettings.isIncludeInsertedRows());
        settings.setOpenNewConnections(taskSettings.isOpenNewConnections());
        settings.setQueryRowsCount(taskSettings.isQueryRowsCount());
        settings.setOutputLogStream(logStream);
        log.debug((Object)"");
        log.debug((Object)"--- Starting data compare ---");
        DCCompareEngineImpl engine = new DCCompareEngineImpl();
        DCSummary summary = engine.compare(monitor, settings);
        log.debug((Object)"");
        log.debug((Object)"--- Data compare result ---");
        log.debug((Object)("Compare Time: " + RuntimeUtils.formatExecutionTime((long)summary.getCompareTime())));
        log.debug((Object)MessageFormat.format("Inserted Rows Count: {0,number}", summary.getInsertedRowsCount()));
        log.debug((Object)MessageFormat.format("Deleted Rows Count: {0,number}", summary.getDeletedRowsCount()));
        log.debug((Object)MessageFormat.format("Modified Rows Count: {0,number}", summary.getModifiedRowsCount()));
        log.debug((Object)MessageFormat.format("Total Compared Rows Count: {0,number}", summary.getTotalComparedRowsCount()));
        log.debug((Object)MessageFormat.format("Total Different Rows Count: {0,number}", summary.getTotalDifferentRowsCount()));
        if (!CommonUtils.isEmptyTrimmed((String)taskSettings.getOutputFilePath())) {
            DCExporterDescriptor descriptor = taskSettings.getExporterDescriptor();
            DCChangeRelation relation = taskSettings.getOutputRelation();
            DCChangeOrder order = taskSettings.getOutputOrder();
            Path path = DBFUtils.resolvePathFromString((DBRProgressMonitor)monitor, (DBPProject)task.getProject(), (String)taskSettings.getOutputFilePath());
            DCUtils.exportChanges(monitor, summary, descriptor, path, relation, order);
        }
        if (DBWorkbench.getPlatform().getApplication().isHeadlessMode() || !taskSettings.isOpenViewerOnFinish()) {
            leftInput.close();
            rightInput.close();
        }
        return summary;
    }
}

