/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.editor;

import com.dbeaver.data.compare.model.DCChangeRelation;
import com.dbeaver.data.compare.model.DCChangeSet;
import com.dbeaver.data.compare.model.DCChangeType;
import com.dbeaver.data.compare.model.DCInput;
import com.dbeaver.data.compare.model.DCSettings;
import com.dbeaver.data.compare.model.DCSummary;
import com.dbeaver.data.compare.model.impl.DCChangeListMemory;
import com.dbeaver.data.compare.ui.dialog.ExportChangesDialog;
import com.dbeaver.data.compare.ui.editor.DCCompareEditorItem;
import com.dbeaver.data.compare.ui.editor.DCCompareViewerPane;
import com.dbeaver.data.compare.ui.internal.DCMessages;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class DCCompareViewer
extends ContentMergeViewer {
    private static final Log log = Log.getLog(DCCompareViewer.class);
    private static final int CENTER_WIDTH = 32;
    private static final int RESOLVE_SIZE = 5;
    private AncestorPane ancestorPane;
    private DCCompareViewerPane leftPane;
    private DCCompareViewerPane rightPane;
    private final Font largeFont;
    private final Set<DCCompareViewerPane> finishedViewers = new HashSet<DCCompareViewerPane>();

    public DCCompareViewer(@NotNull Composite parent, @NotNull CompareConfiguration configuration) {
        super(0, ResourceBundle.getBundle("com.dbeaver.data.compare.ui.internal.DCMessages"), configuration);
        this.buildControl(parent);
        Font normalFont = parent.getFont();
        FontData[] fontData = normalFont.getFontData();
        fontData[0].setStyle(fontData[0].getStyle() | 1);
        fontData[0].setHeight(fontData[0].getHeight() + 4);
        this.largeFont = new Font(normalFont.getDevice(), fontData[0]);
        parent.addDisposeListener(e -> UIUtils.dispose((Resource)this.largeFont));
    }

    protected void createControls(Composite composite) {
        this.ancestorPane = new AncestorPane(composite);
        this.leftPane = new DCCompareViewerPane(composite, this, DCChangeRelation.SOURCE);
        this.rightPane = new DCCompareViewerPane(composite, this, DCChangeRelation.TARGET);
    }

    protected void createToolItems(ToolBarManager tbm) {
        try {
            ImageDescriptor swapIcon = DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.LINK_TO_EDITOR);
            ImageDescriptor propertiesIcon = DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SHOW_MAIN_DETAILS);
            ActionContributionItem swapItem = (ActionContributionItem)tbm.getItems()[2];
            swapItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
            swapItem.getAction().setImageDescriptor(swapIcon);
            swapItem.getAction().setDisabledImageDescriptor(swapIcon);
            swapItem.getAction().setHoverImageDescriptor(swapIcon);
            ActionContributionItem ancestorItem = (ActionContributionItem)tbm.getItems()[3];
            ancestorItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
            ancestorItem.getAction().setImageDescriptor(propertiesIcon);
            ancestorItem.getAction().setDisabledImageDescriptor(propertiesIcon);
            ancestorItem.getAction().setHoverImageDescriptor(propertiesIcon);
        }
        catch (Throwable e) {
            log.debug((Object)"Error changing toolbar icons", e);
        }
        tbm.insertBefore("modes", (IContributionItem)ActionUtils.makeActionContribution((IAction)new Action(){
            {
                this.setText("Export Changes...");
                this.setToolTipText("Shows a preview and allows to export changes to a file");
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_PREVIEW));
            }

            public void run() {
                new ExportChangesDialog(DCCompareViewer.this, DCCompareViewer.this.getSummary()).open();
            }
        }, (boolean)true));
    }

    protected Control createCenterControl(Composite parent) {
        Canvas canvas = new Canvas(parent, 0x20000000);
        canvas.addPaintListener(e -> {
            e.gc.setAntialias(1);
            this.paintCenter((Control)canvas, e.gc);
        });
        try {
            Class<?> cls = Class.forName(ContentMergeViewer.class.getName() + "$Resizer");
            Constructor<?> constructor = cls.getConstructor(ContentMergeViewer.class, Control.class, Integer.TYPE);
            constructor.setAccessible(true);
            constructor.newInstance(new Object[]{this, canvas, 1});
        }
        catch (Throwable e2) {
            log.error((Object)"Error creating resizer", e2);
        }
        return canvas;
    }

    private void paintCenter(@NotNull Control control, @NotNull GC gc) {
        if (!this.getSummary().getSettings().isStoreResultsInMemory()) {
            return;
        }
        Spreadsheet leftSpreadsheet = this.leftPane.getSpreadsheet();
        Spreadsheet rightSpreadsheet = this.rightPane.getSpreadsheet();
        if (leftSpreadsheet == null || rightSpreadsheet == null) {
            return;
        }
        Point size = control.getSize();
        Color normalColor = control.getDisplay().getSystemColor(18);
        gc.setBackground(control.getBackground());
        gc.fillRectangle(1, 0, size.x - 2, size.y);
        gc.setBackground(normalColor);
        gc.fillRectangle(0, 0, 1, size.y);
        gc.fillRectangle(size.x - 1, 0, 1, size.y);
        int visibleHeight = rightSpreadsheet.getClientArea().height;
        int leftTopLine = leftSpreadsheet.getTopIndex();
        int leftBottomLine = leftSpreadsheet.getBottomIndex();
        int rightTopLine = rightSpreadsheet.getTopIndex();
        int rightBottomLine = rightSpreadsheet.getBottomIndex();
        int lh = leftSpreadsheet.getItemHeight();
        int rh = rightSpreadsheet.getItemHeight();
        DCChangeListMemory changeList = (DCChangeListMemory)this.getSummary().getChangeList();
        for (DCChangeSet changeSet : changeList.getChangeSets()) {
            int ry;
            int ly;
            if (changeSet.getChangeType() != DCChangeType.UPDATE) continue;
            ResultSetRow leftRow = this.leftPane.getResultSetRow(changeSet);
            ResultSetRow rightRow = this.rightPane.getResultSetRow(changeSet);
            if (leftRow == null || rightRow == null) continue;
            int leftRowNum = leftRow.getVisualNumber();
            int rightRowNum = rightRow.getVisualNumber();
            if (leftRowNum < leftTopLine || leftRowNum > leftBottomLine || rightRowNum < rightTopLine || rightRowNum > rightBottomLine || Math.max((ly = DCCompareViewer.getRowPosition(leftSpreadsheet, leftRow)) + lh, (ry = DCCompareViewer.getRowPosition(rightSpreadsheet, rightRow)) + rh) < 0) continue;
            if (Math.min(ly, ry) >= visibleHeight) break;
            boolean isSelected = leftSpreadsheet.isRowSelected(leftRowNum) || rightSpreadsheet.isRowSelected(rightRowNum);
            Color fillColor = isSelected ? normalColor : control.getBackground();
            Color strokeColor = control.getForeground();
            gc.setBackground(fillColor);
            gc.fillRectangle(0, ly, 3, lh);
            gc.fillRectangle(size.x - 3, ry, 3, rh);
            gc.setLineWidth(0);
            gc.setForeground(strokeColor);
            gc.drawRectangle(-1, ly, 3, lh - 1);
            gc.drawRectangle(size.x - 3, ry, 3, rh - 1);
            Path path = new Path((Device)control.getDisplay());
            try {
                path.moveTo(3.0f, (float)ly + (float)lh / 2.0f);
                path.cubicTo((float)size.x / 2.0f, (float)ly + (float)lh / 2.0f, (float)size.x / 2.0f, (float)ry + (float)rh / 2.0f, (float)size.x - 3.0f, (float)ry + (float)rh / 2.0f);
                gc.drawPath(path);
            }
            finally {
                path.dispose();
            }
            int cx = (size.x - 5) / 2;
            int cy = (ly + lh / 2 + (ry + rh / 2) - 5) / 2;
            gc.setBackground(fillColor);
            gc.fillRectangle(cx, cy, 5, 5);
            gc.setForeground(strokeColor);
            gc.drawRectangle(cx, cy, 5, 5);
        }
    }

    private static int getRowPosition(Spreadsheet spreadsheet, ResultSetRow row) {
        return spreadsheet.getHeaderHeight() + (row.getVisualNumber() - spreadsheet.getTopIndex()) * (spreadsheet.getItemHeight() + 1);
    }

    protected void handleResizeAncestor(int x, int y, int width, int height) {
        if (this.ancestorPane != null) {
            this.ancestorPane.setBounds(x, y, width, height);
        }
    }

    protected void handleResizeLeftRight(int x, int y, int leftWidth, int centerWidth, int rightWidth, int height) {
        if (this.leftPane != null) {
            this.leftPane.setBounds(x, y, leftWidth, height);
        }
        if (this.rightPane != null) {
            this.rightPane.setBounds(x + leftWidth + centerWidth, y, rightWidth, height);
        }
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        DCCompareEditorItem leftItem = (DCCompareEditorItem)left;
        DCCompareEditorItem rightItem = (DCCompareEditorItem)right;
        this.ancestorPane.update(leftItem.getSummary());
        this.setPaneInput(this.leftPane, leftItem, DCChangeRelation.SOURCE);
        this.setPaneInput(this.rightPane, rightItem, DCChangeRelation.TARGET);
        new AbstractUIJob("Read data"){

            protected IStatus runInUIThread(DBRProgressMonitor monitor) {
                DCCompareViewer.this.finishedViewers.clear();
                DCCompareViewer.this.leftPane.refresh();
                DCCompareViewer.this.rightPane.refresh();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void copy(boolean leftToRight) {
        DBWorkbench.getPlatformUI().showError("Data container", "Not supported");
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    protected int getCenterWidth() {
        return 32;
    }

    @NotNull
    public CompareConfiguration getCompareConfiguration() {
        return super.getCompareConfiguration();
    }

    protected void handleDispose(DisposeEvent event) {
        DCSettings settings = this.getSummary().getSettings();
        settings.getLeftInput().close();
        settings.getRightInput().close();
        super.handleDispose(event);
    }

    @NotNull
    public DCCompareViewerPane getOppositePane(@NotNull DCCompareViewerPane pane) {
        return pane == this.leftPane ? this.rightPane : this.leftPane;
    }

    @NotNull
    public DCCompareViewerPane getPane(@NotNull DCChangeRelation relation) {
        return relation == this.leftPane.getRelation() ? this.leftPane : this.rightPane;
    }

    @NotNull
    public DCSummary getSummary() {
        DiffNode input = (DiffNode)this.getInput();
        DCCompareEditorItem item = (DCCompareEditorItem)input.getLeft();
        return item.getSummary();
    }

    public void signalDataLoad(@NotNull DCCompareViewerPane viewerPane) {
        if (!this.finishedViewers.add(viewerPane)) {
            return;
        }
        if (this.finishedViewers.size() < 2) {
            return;
        }
        for (DCCompareViewerPane pane : this.finishedViewers) {
            final Spreadsheet spreadsheet = pane.getSpreadsheet();
            final Spreadsheet oppositeSpreadsheet = this.getOppositePane(pane).getSpreadsheet();
            if (spreadsheet == null || oppositeSpreadsheet == null) continue;
            SelectionAdapter horizontalScrollListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int selection;
                    ScrollBar scroll1 = spreadsheet.getHorizontalBar();
                    ScrollBar scroll2 = oppositeSpreadsheet.getHorizontalBar();
                    if (scroll1.getSelection() > 0) {
                        float ratio = (float)(scroll1.getMaximum() - scroll1.getMinimum()) / (float)scroll1.getSelection();
                        selection = (int)((float)(scroll2.getMaximum() - scroll2.getMinimum()) / ratio);
                    } else {
                        selection = 0;
                    }
                    if (selection != scroll2.getSelection()) {
                        scroll2.setSelection(selection);
                        oppositeSpreadsheet.redrawGrid();
                    }
                }
            };
            SelectionAdapter verticalScrollListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DCCompareViewer.this.redrawRuler();
                }
            };
            UIExecutionQueue.queueExec(() -> this.lambda$2(spreadsheet, (SelectionListener)horizontalScrollListener, (SelectionListener)verticalScrollListener, pane));
        }
        this.finishedViewers.clear();
    }

    public void redrawRuler() {
        this.getCenterControl().redraw();
    }

    private void setPaneInput(@NotNull DCCompareViewerPane pane, @NotNull DCCompareEditorItem item, @NotNull DCChangeRelation relation) {
        CompareConfiguration configuration = this.getCompareConfiguration();
        if (configuration.isMirrored()) {
            relation = relation.opposite();
        }
        if (relation.isSource()) {
            configuration.setLeftLabel(DCCompareViewer.getPaneLabel(item.getInput(), true));
            configuration.setLeftImage(item.getImage());
        } else {
            configuration.setRightLabel(DCCompareViewer.getPaneLabel(item.getInput(), false));
            configuration.setRightImage(item.getImage());
        }
        configuration.setAncestorLabel(DCMessages.data_compare_editor_ancestor_label);
        pane.setInput(item.getSummary(), relation);
        pane.refresh();
    }

    @NotNull
    private static String getPaneLabel(@NotNull DCInput item, boolean left) {
        return "%s - %s".formatted(left ? "Source" : "Target", item.getName());
    }

    private /* synthetic */ void lambda$2(Spreadsheet spreadsheet, SelectionListener selectionListener, SelectionListener selectionListener2, DCCompareViewerPane dCCompareViewerPane) {
        spreadsheet.getHorizontalBar().addSelectionListener(selectionListener);
        spreadsheet.getVerticalBar().addSelectionListener(selectionListener2);
        spreadsheet.addPaintListener(e -> {
            if (!spreadsheet.isDisposed() && dCCompareViewerPane.getResultSetController().getModel().getRowCount() == 0) {
                e.gc.setForeground(UIStyles.getDefaultTextForeground());
                e.gc.setFont(this.largeFont);
                UIUtils.drawMessageOverControl((Control)spreadsheet, (PaintEvent)e, (String)"This table has no changes", (int)0);
            }
        });
        spreadsheet.redraw();
        this.redrawRuler();
    }

    private class AncestorPane
    extends Composite {
        private final Table statisticsTable;
        private final Label leftContainerLabel;
        private final Link leftContainerLink;
        private final Label rightContainerLabel;
        private final Link rightContainerLink;
        private DBSDataContainer leftContainer;
        private DBSDataContainer rightContainer;

        public AncestorPane(Composite parent) {
            super(parent, 0);
            this.setLayoutData(new GridData(1808));
            this.setLayout((Layout)new GridLayout(2, false));
            this.statisticsTable = new Table((Composite)this, 67588);
            UIUtils.createTableColumn((Table)this.statisticsTable, (int)16384, (String)DCMessages.data_compare_editor_ancestor_summary_name_label);
            UIUtils.createTableColumn((Table)this.statisticsTable, (int)16384, (String)DCMessages.data_compare_editor_ancestor_summary_value_label);
            SelectionAdapter adapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DBSDataContainer object = e.getSource() == AncestorPane.this.leftContainerLink ? AncestorPane.this.leftContainer : AncestorPane.this.rightContainer;
                    UIUtils.runUIJob((String)"Open object editor", arg_0 -> 1.lambda$0((DBSObject)object, arg_0));
                }

                private static /* synthetic */ void lambda$0(DBSObject dBSObject, DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DBNDatabaseNode node = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)dBSObject, (boolean)true);
                    if (node != null) {
                        NavigatorUtils.openNavigatorNode((Object)node, (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow());
                    }
                }
            };
            Composite composite = UIUtils.createComposite((Composite)this, (int)3);
            composite.setLayoutData((Object)new GridData(4, 4, false, false));
            UIUtils.createControlLabel((Composite)composite, (String)DCMessages.data_compare_editor_ancestor_container_left_title);
            this.leftContainerLabel = UIUtils.createLabel((Composite)composite, (DBPImage)DBIcon.TREE_TABLE);
            this.leftContainerLink = UIUtils.createLink((Composite)composite, (String)"N/A", (SelectionListener)adapter);
            UIUtils.createControlLabel((Composite)composite, (String)DCMessages.data_compare_editor_ancestor_container_right_title);
            this.rightContainerLabel = UIUtils.createLabel((Composite)composite, (DBPImage)DBIcon.TREE_TABLE);
            this.rightContainerLink = UIUtils.createLink((Composite)composite, (String)"N/A", (SelectionListener)adapter);
        }

        public void update(@NotNull DCSummary summary) {
            DCSettings settings = summary.getSettings();
            if (DCCompareViewer.this.getCompareConfiguration().isMirrored()) {
                this.leftContainer = settings.getRightInput().getContainer();
                this.rightContainer = settings.getLeftInput().getContainer();
            } else {
                this.leftContainer = settings.getLeftInput().getContainer();
                this.rightContainer = settings.getRightInput().getContainer();
            }
            this.statisticsTable.removeAll();
            this.add(DCMessages.data_compare_editor_ancestor_summary_item_elapsed_time_label, RuntimeUtils.formatExecutionTime((long)summary.getCompareTime()));
            this.add(DCMessages.data_compare_editor_ancestor_summary_item_modified_rows_label, summary.getModifiedRowsCount());
            this.add(DCMessages.data_compare_editor_ancestor_summary_item_deleted_rows_label, summary.getDeletedRowsCount());
            this.add(DCMessages.data_compare_editor_ancestor_summary_item_inserted_rows_label, summary.getInsertedRowsCount());
            this.add(DCMessages.data_compare_editor_ancestor_summary_item_total_compared_rows_label, summary.getTotalComparedRowsCount());
            this.add(DCMessages.data_compare_editor_ancestor_summary_item_total_different_rows_label, MessageFormat.format("{0,number} ({1,number,#.##}%)", summary.getTotalDifferentRowsCount(), (double)summary.getTotalDifferentRowsCount() / (double)summary.getTotalComparedRowsCount() * 100.0));
            UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.statisticsTable, (boolean)false));
            this.leftContainerLink.setText("<a>" + settings.getLeftInput().getName() + "</a>");
            this.leftContainerLink.setToolTipText(settings.getLeftInput().getDescription());
            this.rightContainerLink.setText("<a>" + settings.getRightInput().getName() + "</a>");
            this.rightContainerLink.setToolTipText(settings.getRightInput().getDescription());
            UIUtils.runUIJob((String)"Load objects icons", monitor -> {
                DBNDatabaseNode rightContainerNode;
                DBNDatabaseNode leftContainerNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)this.leftContainer, (boolean)true);
                if (leftContainerNode != null) {
                    this.leftContainerLabel.setImage(DBeaverIcons.getImage((DBPImage)leftContainerNode.getNodeIcon()));
                }
                if ((rightContainerNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)this.rightContainer, (boolean)true)) != null) {
                    this.rightContainerLabel.setImage(DBeaverIcons.getImage((DBPImage)rightContainerNode.getNodeIcon()));
                }
                this.leftContainerLabel.getParent().layout(true, true);
            });
        }

        private void add(@NotNull String name, long value) {
            this.add(name, NumberFormat.getInstance().format(value));
        }

        private void add(@NotNull String name, @NotNull Object value) {
            TableItem item = new TableItem(this.statisticsTable, 0);
            item.setText(0, name);
            item.setText(1, DBUtils.getObjectShortName((Object)value));
        }
    }
}

