/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.IWizardPageNavigable;

public class DCCompareTaskWizardPageLog
extends WizardPage
implements IWizardPageNavigable {
    private MessageConsole console;
    private PrintStream writer;

    public DCCompareTaskWizardPageLog() {
        super("Data Compare");
        this.setTitle("Execution log");
        this.setDescription("Data Compare execution log");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new FillLayout());
        this.console = new MessageConsole("data-compare-log-console", null);
        this.console.setWaterMarks(0x300000, 0x400000);
        this.writer = new PrintStream((OutputStream)this.console.newMessageStream(), true, StandardCharsets.UTF_8);
        new LogConsoleViewer(composite, this.console);
        this.setControl((Control)composite);
    }

    public void clear() {
        UIUtils.syncExec(() -> this.console.clearConsole());
    }

    public PrintStream getWriter() {
        return this.writer;
    }

    public boolean isPageNavigable() {
        return false;
    }

    public boolean isPageApplicable() {
        return true;
    }

    private static class LogConsoleViewer
    extends TextConsoleViewer
    implements IDocumentListener {
        private LogConsoleViewer(Composite composite, MessageConsole console) {
            super(composite, (TextConsole)console);
        }

        public void setDocument(IDocument document) {
            IDocument oldDocument = this.getDocument();
            super.setDocument(document);
            if (oldDocument != null) {
                oldDocument.removeDocumentListener((IDocumentListener)this);
            }
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.revealEndOfDocument();
        }
    }
}

