/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.parquet;

import com.dbeaver.data.transfer.parquet.parquetcustom.ParquetCustomPositionOutputStreamWrapper;
import com.dbeaver.data.transfer.parquet.parquetcustom.ParquetCustomStreamOutputFile;
import com.dbeaver.data.transfer.parquet.schema.AbstractParquetExportSchemaFactory;
import com.dbeaver.data.transfer.parquet.schema.ParquetExportSchemaFactoryJdbc;
import com.dbeaver.data.transfer.parquet.schema.ParquetExportSchemaFactoryNonJdbc;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;

public class DataExporterParquet
extends StreamExporterAbstract
implements IStreamDataExporter {
    private MessageType schema = null;
    private ParquetWriter<Group> writer = null;
    private DBDAttributeBinding[] attributeBindings = null;
    private String exportTableName = "parquet-export-table";

    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
    }

    public void exportHeader(DBCSession session) {
        this.attributeBindings = this.getSite().getAttributes();
        if (this.attributeBindings != null && this.attributeBindings.length > 0) {
            this.exportTableName = DTUtils.getTableName((DBPDataSource)this.attributeBindings[0].getDataSource(), (DBPNamedObject)this.getSite().getSource(), (boolean)true);
        }
    }

    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) {
        try {
            if (this.writer == null) {
                this.initWriter(resultSet, row);
            }
            this.writeRow(row);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initWriter(DBCResultSet resultSet, Object[] row) throws Exception {
        DBPDataSource dataSource = resultSet.getSession().getDataSource();
        AbstractParquetExportSchemaFactory schemaFactory = dataSource instanceof JDBCDataSource ? new ParquetExportSchemaFactoryJdbc(this.attributeBindings, this.exportTableName, row) : new ParquetExportSchemaFactoryNonJdbc(this.attributeBindings, this.exportTableName, row);
        this.schema = schemaFactory.getParquetSchema();
        this.writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((OutputFile)new ParquetCustomStreamOutputFile((OutputStream)((Object)new ParquetCustomPositionOutputStreamWrapper(this.getOutputStream())))).withType(this.schema).withCompressionCodec(CompressionCodecName.UNCOMPRESSED)).withDictionaryEncoding(false)).withValidation(false)).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).build();
    }

    public void writeRow(Object[] row) throws Exception {
        SimpleGroup group = new SimpleGroup((GroupType)this.schema);
        List columnDescriptors = this.schema.getColumns();
        int i = 0;
        while (i < this.attributeBindings.length) {
            DBDAttributeBinding column = this.attributeBindings[i];
            String columnName = column.getName();
            Object valueObject = row[i];
            if (valueObject != null) {
                ColumnDescriptor columnDescriptor = (ColumnDescriptor)columnDescriptors.get(i);
                PrimitiveType type = columnDescriptor.getPrimitiveType();
                LogicalTypeAnnotation logicalTypeAnnotation = type.getLogicalTypeAnnotation();
                if (logicalTypeAnnotation != null) {
                    this.handleLogicalTypeAnnotation(logicalTypeAnnotation, valueObject, (Group)group, columnName);
                } else {
                    this.handlePrimitiveTypes(type, valueObject, (Group)group, columnName);
                }
            }
            ++i;
        }
        this.writer.write((Object)group);
    }

    private void handlePrimitiveTypes(PrimitiveType type, Object valueObject, Group group, String columnName) {
        switch (type.getPrimitiveTypeName()) {
            case BOOLEAN: {
                this.handlePrimitiveType(valueObject, columnName, Boolean.class, Boolean::parseBoolean, (arg_0, arg_1) -> ((Group)group).add(arg_0, arg_1));
                break;
            }
            case INT32: {
                this.handlePrimitiveType(valueObject, columnName, Integer.class, Integer::parseInt, (arg_0, arg_1) -> ((Group)group).add(arg_0, arg_1));
                break;
            }
            case INT64: {
                this.handlePrimitiveType(valueObject, columnName, Long.class, Long::parseLong, (arg_0, arg_1) -> ((Group)group).add(arg_0, arg_1));
                break;
            }
            case FLOAT: {
                this.handlePrimitiveType(valueObject, columnName, Float.class, Float::parseFloat, (arg_0, arg_1) -> ((Group)group).add(arg_0, arg_1));
                break;
            }
            case DOUBLE: {
                this.handlePrimitiveType(valueObject, columnName, Double.class, Double::parseDouble, (arg_0, arg_1) -> ((Group)group).add(arg_0, arg_1));
                break;
            }
            case BINARY: {
                if (valueObject instanceof String) {
                    group.add(columnName, Binary.fromString((String)((String)valueObject)));
                    break;
                }
                if (valueObject instanceof byte[]) {
                    group.add(columnName, Binary.fromConstantByteArray((byte[])((byte[])valueObject)));
                    break;
                }
                throw new IllegalArgumentException("Expected Binary (String or byte[]) for column " + columnName);
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
            }
        }
    }

    public void exportFooter(DBRProgressMonitor monitor) {
    }

    public void dispose() {
        super.dispose();
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T tryGetOrNull(Supplier<T> value) {
        try {
            return value.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void handleLogicalTypeAnnotation(@NotNull LogicalTypeAnnotation logicalTypeAnnotation, @NotNull Object valueObject, @NotNull Group group, @NotNull String columnName) {
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
            if (valueObject instanceof Instant) {
                Instant instant = (Instant)valueObject;
                group.add(columnName, instant.toEpochMilli());
            } else if (valueObject instanceof Timestamp) {
                Timestamp timestampValue = (Timestamp)valueObject;
                group.add(columnName, timestampValue.toLocalDateTime().toInstant(ZoneOffset.UTC).toEpochMilli());
            } else if (valueObject instanceof LocalDateTime) {
                LocalDateTime localDateTimeValue = (LocalDateTime)valueObject;
                group.add(columnName, localDateTimeValue.atZone(ZoneOffset.UTC).toInstant().toEpochMilli());
            } else if (valueObject instanceof ZonedDateTime) {
                ZonedDateTime zonedDateTimeValue = (ZonedDateTime)valueObject;
                group.add(columnName, zonedDateTimeValue.toLocalDateTime().toInstant(ZoneOffset.UTC).toEpochMilli());
            } else if (valueObject instanceof OffsetDateTime) {
                OffsetDateTime offsetDateTimeValue = (OffsetDateTime)valueObject;
                group.add(columnName, offsetDateTimeValue.toLocalDateTime().toInstant(ZoneOffset.UTC).toEpochMilli());
            }
        } else if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
            if (valueObject instanceof Time) {
                Time timeValue = (Time)valueObject;
                group.add(columnName, (int)Duration.ofNanos(timeValue.toLocalTime().toNanoOfDay()).toMillis());
            } else if (valueObject instanceof LocalTime) {
                LocalTime localTimeValue = (LocalTime)valueObject;
                group.add(columnName, (int)Duration.ofNanos(localTimeValue.toNanoOfDay()).toMillis());
            } else if (valueObject instanceof OffsetTime) {
                OffsetTime offsetTimeValue = (OffsetTime)valueObject;
                group.add(columnName, (int)Duration.ofNanos(offsetTimeValue.toLocalTime().toNanoOfDay()).toMillis());
            }
        } else if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
            if (valueObject instanceof Date) {
                Date dateValue = (Date)valueObject;
                group.add(columnName, (int)dateValue.toLocalDate().toEpochDay());
            } else if (valueObject instanceof LocalDate) {
                LocalDate localDateValue = (LocalDate)valueObject;
                group.add(columnName, (int)localDateValue.toEpochDay());
            }
        } else {
            group.add(columnName, String.valueOf(valueObject));
        }
    }

    private <T> void handlePrimitiveType(@NotNull Object valueObject, @NotNull String columnName, @NotNull Class<T> targetType, @NotNull Function<String, T> parser, @NotNull BiConsumer<String, T> groupAdder) {
        if (targetType.isInstance(valueObject)) {
            groupAdder.accept(columnName, (String)targetType.cast(valueObject));
        } else {
            String stringObject = valueObject.toString();
            if (stringObject.isBlank()) {
                return;
            }
            Object parsedValue = this.tryGetOrNull(() -> parser.apply(stringObject));
            if (parsedValue != null) {
                groupAdder.accept(columnName, (String)parsedValue);
            } else {
                throw new IllegalArgumentException("Expected " + targetType.getSimpleName() + " for column " + columnName);
            }
        }
    }
}

