/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.parquet.parquetcustom;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.parquet.io.PositionOutputStream;

public class ParquetCustomPositionOutputStreamWrapper
extends PositionOutputStream {
    private final BufferedOutputStream stream;
    private long pos = 0L;

    public ParquetCustomPositionOutputStreamWrapper(OutputStream outputStream) {
        this.stream = new BufferedOutputStream(outputStream);
    }

    public long getPos() {
        return this.pos;
    }

    public void write(int data) throws IOException {
        ++this.pos;
        this.stream.write(data);
    }

    public void write(byte[] data) throws IOException {
        this.pos += (long)data.length;
        this.stream.write(data);
    }

    public void write(byte[] data, int off, int len) throws IOException {
        this.pos += (long)len;
        this.stream.write(data, off, len);
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void close() throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedOutputStream os = this.stream;){
                ((OutputStream)os).flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

