/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.parquet.schema;

import com.dbeaver.data.transfer.parquet.schema.AbstractParquetExportSchemaFactory;
import java.util.logging.Logger;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;

public class ParquetExportSchemaFactoryJdbc
extends AbstractParquetExportSchemaFactory {
    private static final Logger log = Logger.getLogger(ParquetExportSchemaFactoryJdbc.class.getName());

    public ParquetExportSchemaFactoryJdbc(DBDAttributeBinding[] attributeBindings, String dataContainerName, Object[] row) {
        super(attributeBindings, dataContainerName, row);
    }

    @Override
    public MessageType getParquetSchema() {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        int i = 0;
        while (i < this.attributeBindings.length) {
            DBDAttributeBinding column = this.attributeBindings[i];
            int columnType = column.getTypeID();
            DBPDataKind dataKind = column.getDataKind();
            String columnName = column.getName();
            block0 : switch (dataKind) {
                case BOOLEAN: {
                    builder.addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named(column.getName()));
                    break;
                }
                case NUMERIC: {
                    switch (columnType) {
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            builder.addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named(columnName));
                            break block0;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            builder.addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named(columnName));
                            break block0;
                        }
                    }
                    log.warning(String.format("Can't determine the exact type of %s for column: %s, sqlType: %d. Fallback to DOUBLE", dataKind, columnName, columnType));
                    builder.addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named(columnName));
                    break;
                }
                case DATETIME: {
                    if (this.addStringTypeColumnIfDatetimeWithoutType(i, builder)) break;
                    switch (columnType) {
                        case 91: {
                            builder.addField((Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType())).named(columnName));
                            break block0;
                        }
                        case 92: {
                            builder.addField((Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named(columnName));
                            break block0;
                        }
                        case 2013: {
                            builder.addField((Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named(columnName));
                            break block0;
                        }
                        case 93: {
                            builder.addField((Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named(columnName));
                            break block0;
                        }
                        case 2014: {
                            builder.addField((Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named(columnName));
                            break block0;
                        }
                    }
                    log.warning(String.format("Can't determine the exact type of %s for column: %s, sqlType: %d. Fallback to STRING", dataKind, columnName, columnType));
                    builder.addField((Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(columnName));
                    break;
                }
                default: {
                    builder.addField((Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(columnName));
                }
            }
            ++i;
        }
        return builder.named(this.dataContainerName);
    }
}

