/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.ui.ai.wizard;

import com.dbeaver.data.transfer.ui.ai.wizard.MappingMode;
import com.dbeaver.model.ai.prompt.dt.AIPromptResolveDataTypes;
import com.dbeaver.model.ai.prompt.dt.DTTContainer;
import com.dbeaver.model.ai.prompt.dt.DTTargetColumnInfo;
import com.dbeaver.model.ai.prompt.dt.DTTargetTableInfo;
import com.dbeaver.model.ai.prompt.dt.ResolveTargetTypeRequest;
import com.dbeaver.model.ai.prompt.dt.ResolveTargetTypeResponse;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;

public class DTTargetTypeResolver {
    public void resolve(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer targetContainer, @NotNull List<DTTContainer> containerList, @NotNull MappingMode currentMappingMode) throws DBException {
        if (containerList.isEmpty()) {
            return;
        }
        DBPDataSource sourceContainer = containerList.getFirst().container().getSource().getDataSource();
        ResolveTargetTypeRequest resolveTargetTypeRequest = new ResolveTargetTypeRequest(sourceContainer, containerList, targetContainer);
        ResolveTargetTypeResponse resolveTargetTypeResponse = AIPromptResolveDataTypes.resolveTargetType((DBRProgressMonitor)monitor, (DBPWorkspace)DBWorkbench.getPlatform().getWorkspace(), (ResolveTargetTypeRequest)resolveTargetTypeRequest);
        Map<String, DatabaseMappingContainer> nameToMappingContainer = containerList.stream().collect(Collectors.toMap(it -> it.container().getSource().getName(), DTTContainer::container));
        for (DTTargetTableInfo table : resolveTargetTypeResponse.tableList()) {
            DatabaseMappingContainer mappingContainer = nameToMappingContainer.get(table.name());
            if (mappingContainer == null) continue;
            Map<String, DTTargetColumnInfo> byName = table.columns().stream().collect(Collectors.toMap(DTTargetColumnInfo::name, c -> c));
            for (DatabaseMappingAttribute mapping : mappingContainer.getAttributeMappings()) {
                DBSAttributeBase src = mapping.getSource();
                if (src == null) continue;
                DTTargetColumnInfo match = null;
                block0 : switch (currentMappingMode) {
                    case COLUMN_NAMES: {
                        match = byName.get(src.getName());
                        break;
                    }
                    case DATA_TYPES: {
                        for (DTTargetColumnInfo col : table.columns()) {
                            if (!col.targetDataType().equalsIgnoreCase(src.getTypeName())) continue;
                            match = col;
                            break block0;
                        }
                        break;
                    }
                    case ALL: {
                        match = byName.get(src.getName());
                        if (match != null) break;
                        for (DTTargetColumnInfo col : table.columns()) {
                            if (!col.targetDataType().equalsIgnoreCase(src.getTypeName())) continue;
                            match = col;
                            break block0;
                        }
                        break;
                    }
                }
                if (match == null) continue;
                mapping.setTargetType(match.targetDataType(), match.targetDataTypeFullName());
            }
        }
    }
}

