/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.ui.processor.config;

import com.dbeaver.data.transfer.mail.SMTPProfile;
import com.dbeaver.data.transfer.mail.SMTPProfileManager;
import com.dbeaver.data.transfer.ui.internal.DTEEMessages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.ui.IDataTransferEventProcessorConfigurator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class SendMailEventProcessorConfigurator
implements IDataTransferEventProcessorConfigurator<IDataTransferConsumerSettings> {
    private final List<SMTPProfile> profiles = new ArrayList<SMTPProfile>();
    private SMTPProfile profile;
    private String from;
    private String recipient;
    private String subject;
    private String body;
    private boolean sendSuccessReports;
    private boolean sendFailureReports;
    private boolean omitResultFiles;
    private boolean omitEmptyResults;
    private boolean trustServer;
    private boolean splitFiles;
    private int splitFileSize;
    private Combo profileCombo;

    public void createControl(final @NotNull Composite parent, @NotNull IDataTransferConsumerSettings settings, final @NotNull Runnable propertyChangeListener) {
        final Composite group = new Composite(parent, 0);
        group.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(320, -1).create());
        this.profileCombo = UIUtils.createLabelCombo((Composite)group, (String)DTEEMessages.data_transfer_event_processor_send_mail_profile, (int)12);
        ToolBar toolbar = new ToolBar(group, 256);
        UIUtils.createToolItem((ToolBar)toolbar, (String)DTEEMessages.data_transfer_event_processor_send_mail_profile_configure, (DBPImage)UIIcon.CONFIGURATION, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.showPreferencesFor((Shell)group.getShell(), null, (String[])new String[]{"com.dbeaver.preferences.mail"});
                SendMailEventProcessorConfigurator.this.refreshProfiles();
            }
        });
        final Text fromText = UIUtils.createLabelText((Composite)group, (String)DTEEMessages.data_transfer_event_processor_send_mail_from, (String)this.from);
        fromText.setToolTipText(DTEEMessages.data_transfer_event_processor_send_mail_from_tip);
        fromText.addModifyListener(e -> {
            this.from = fromText.getText().trim();
            propertyChangeListener.run();
        });
        ((GridData)fromText.getLayoutData()).horizontalSpan = 2;
        Text recipientText = UIUtils.createLabelText((Composite)group, (String)DTEEMessages.data_transfer_event_processor_send_mail_to, (String)this.recipient);
        recipientText.setToolTipText(DTEEMessages.data_transfer_event_processor_send_mail_to_tip);
        recipientText.addModifyListener(e -> {
            this.recipient = recipientText.getText().trim();
            propertyChangeListener.run();
        });
        ((GridData)recipientText.getLayoutData()).horizontalSpan = 2;
        Text subjectText = UIUtils.createLabelText((Composite)group, (String)DTEEMessages.data_transfer_event_processor_send_mail_subject, (String)this.subject);
        subjectText.addModifyListener(e -> {
            this.subject = subjectText.getText().trim();
            propertyChangeListener.run();
        });
        ((GridData)subjectText.getLayoutData()).horizontalSpan = 2;
        Text bodyText = UIUtils.createLabelText((Composite)group, (String)DTEEMessages.data_transfer_event_processor_send_mail_body, (String)this.body, (int)2626);
        bodyText.addModifyListener(e -> {
            this.body = bodyText.getText().trim();
            propertyChangeListener.run();
        });
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).hint(-1, bodyText.getLineHeight() * 5).applyTo((Control)bodyText);
        ExpandableComposite optionsExpander = UIUtils.createExpandableCompositeWithSeparator((Composite)group, (int)0, (int)2);
        optionsExpander.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        optionsExpander.setText(DTEEMessages.data_transfer_event_processor_send_mail_options);
        optionsExpander.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                Shell shell = parent.getShell();
                Point size = shell.computeSize(-1, -1, true);
                shell.setSize(size);
            }
        });
        Composite optionsGroup = new Composite((Composite)optionsExpander, 0);
        optionsGroup.setLayout((Layout)new GridLayout());
        optionsExpander.setClient((Control)optionsGroup);
        final Button sendSuccessReportsCheckbox = UIUtils.createCheckbox((Composite)optionsGroup, (String)DTEEMessages.data_transfer_event_processor_send_mail_send_success_reports, (String)DTEEMessages.data_transfer_event_processor_send_mail_send_success_reports_tip, (boolean)this.sendSuccessReports, (int)1);
        final Button omitResultFilesCheckbox = UIUtils.createCheckbox((Composite)optionsGroup, (String)DTEEMessages.data_transfer_event_processor_send_mail_omit_result_files, (String)DTEEMessages.data_transfer_event_processor_send_mail_omit_result_files_tip, (boolean)this.omitResultFiles, (int)1);
        omitResultFilesCheckbox.setLayoutData((Object)GridDataFactory.swtDefaults().indent(LayoutConstants.getIndent(), 0).create());
        omitResultFilesCheckbox.setEnabled(this.sendSuccessReports);
        omitResultFilesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SendMailEventProcessorConfigurator.this.omitResultFiles = omitResultFilesCheckbox.getSelection();
                propertyChangeListener.run();
            }
        });
        final Button omitEmptyResultsCheckbox = UIUtils.createCheckbox((Composite)optionsGroup, (String)DTEEMessages.data_transfer_event_processor_send_mail_omit_empty_result_files, (String)DTEEMessages.data_transfer_event_processor_send_mail_omit_empty_result_files_tip, (boolean)this.omitEmptyResults, (int)1);
        omitEmptyResultsCheckbox.setLayoutData((Object)GridDataFactory.swtDefaults().indent(LayoutConstants.getIndent(), 0).create());
        omitEmptyResultsCheckbox.setEnabled(this.sendSuccessReports);
        omitEmptyResultsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SendMailEventProcessorConfigurator.this.omitEmptyResults = omitEmptyResultsCheckbox.getSelection();
                propertyChangeListener.run();
            }
        });
        sendSuccessReportsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SendMailEventProcessorConfigurator.this.sendSuccessReports = sendSuccessReportsCheckbox.getSelection();
                omitResultFilesCheckbox.setEnabled(SendMailEventProcessorConfigurator.this.sendSuccessReports);
                omitEmptyResultsCheckbox.setEnabled(SendMailEventProcessorConfigurator.this.sendSuccessReports);
                propertyChangeListener.run();
            }
        });
        Composite splitFilesComposite = new Composite(optionsGroup, 0);
        splitFilesComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(3).create());
        splitFilesComposite.setLayoutData((Object)GridDataFactory.swtDefaults().indent(LayoutConstants.getIndent(), 0).create());
        Button splitFilesCheckbox = UIUtils.createCheckbox((Composite)splitFilesComposite, (String)DTEEMessages.data_transfer_event_processor_send_mail_split_files, (String)DTEEMessages.data_transfer_event_processor_send_mail_split_files_tip, (boolean)this.splitFiles, (int)1);
        Spinner splitFileSizeSpinner = UIUtils.createSpinner((Composite)splitFilesComposite, null, (int)this.splitFileSize, (int)5, (int)50);
        splitFileSizeSpinner.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.splitFileSize = splitFileSizeSpinner.getSelection();
            propertyChangeListener.run();
        }));
        Label splitFilesLabel = UIUtils.createLabel((Composite)splitFilesComposite, (String)"mB");
        splitFilesCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            splitFileSizeSpinner.setEnabled(splitFilesCheckbox.getSelection());
            splitFilesLabel.setEnabled(splitFilesCheckbox.getSelection());
            this.splitFiles = splitFilesCheckbox.getSelection();
        }));
        splitFilesCheckbox.notifyListeners(13, new Event());
        final Button sendFailureReportsCheckbox = UIUtils.createCheckbox((Composite)optionsGroup, (String)DTEEMessages.data_transfer_event_processor_send_mail_send_failure_reports, (String)DTEEMessages.data_transfer_event_processor_send_mail_send_failure_reports_tip, (boolean)this.sendFailureReports, (int)1);
        sendFailureReportsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SendMailEventProcessorConfigurator.this.sendFailureReports = sendFailureReportsCheckbox.getSelection();
                propertyChangeListener.run();
            }
        });
        final Button trustServerCheckbox = UIUtils.createCheckbox((Composite)optionsGroup, (String)DTEEMessages.data_transfer_event_processor_send_mail_trust_server, (String)DTEEMessages.data_transfer_event_processor_send_mail_trust_server_tip, (boolean)this.trustServer, (int)3);
        trustServerCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SendMailEventProcessorConfigurator.this.trustServer = trustServerCheckbox.getSelection();
                propertyChangeListener.run();
            }
        });
        this.profileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = SendMailEventProcessorConfigurator.this.profileCombo.getSelectionIndex();
                if (selectionIndex >= 0) {
                    SendMailEventProcessorConfigurator.this.profile = SendMailEventProcessorConfigurator.this.profiles.get(selectionIndex);
                    fromText.setMessage(SendMailEventProcessorConfigurator.this.profile.getAuthentication() != null ? SendMailEventProcessorConfigurator.this.profile.getAuthentication().getUsername() : "");
                    propertyChangeListener.run();
                }
            }
        });
        UIUtils.asyncExec(this::refreshProfiles);
    }

    public void loadSettings(@NotNull Map<String, Object> settings) {
        this.profile = SMTPProfileManager.getProfile((String)CommonUtils.toString((Object)settings.get("profile")));
        this.from = CommonUtils.toString((Object)settings.get("from"));
        this.recipient = CommonUtils.toString((Object)settings.get("recipient"));
        this.subject = CommonUtils.toString((Object)settings.get("subject"));
        this.body = CommonUtils.toString((Object)settings.get("body"));
        this.sendSuccessReports = CommonUtils.getBoolean((Object)settings.get("sendOnSuccess"), (boolean)true);
        this.sendFailureReports = CommonUtils.getBoolean((Object)settings.get("sendOnError"), (boolean)true);
        this.omitResultFiles = CommonUtils.toBoolean((Object)settings.get("omitResultFiles"));
        this.omitEmptyResults = CommonUtils.toBoolean((Object)settings.get("omitEmptyResults"));
        this.trustServer = CommonUtils.toBoolean((Object)settings.get("trustServer"));
        this.splitFiles = CommonUtils.toBoolean((Object)settings.get("splitFiles"));
        this.splitFileSize = CommonUtils.toInt((Object)settings.get("splitFileSize"), (int)5);
    }

    public void saveSettings(@NotNull Map<String, Object> settings) {
        settings.put("profile", this.profile.getId());
        settings.put("from", this.from);
        settings.put("recipient", this.recipient);
        settings.put("subject", this.subject);
        settings.put("body", this.body);
        settings.put("sendOnSuccess", this.sendSuccessReports);
        settings.put("sendOnError", this.sendFailureReports);
        settings.put("omitResultFiles", this.omitResultFiles);
        settings.put("omitEmptyResults", this.omitEmptyResults);
        settings.put("trustServer", this.trustServer);
        settings.put("splitFiles", this.splitFiles);
        settings.put("splitFileSize", this.splitFileSize);
    }

    public void resetSettings(@NotNull Map<String, Object> settings) {
    }

    public boolean isComplete() {
        return this.profile != null && !CommonUtils.isEmpty((String)this.recipient) && !CommonUtils.isEmpty((String)this.subject) && (this.sendSuccessReports || this.sendFailureReports);
    }

    public boolean isApplicable(@NotNull IDataTransferConsumerSettings settings) {
        if (settings instanceof StreamConsumerSettings) {
            StreamConsumerSettings streamConsumerSettings = (StreamConsumerSettings)settings;
            return !streamConsumerSettings.isOutputClipboard();
        }
        return true;
    }

    private void resolveProfileSecrets(@Nullable SMTPProfile profile) {
        if (profile == null) {
            return;
        }
        try {
            profile.resolveSecrets();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error loading SMTP profile", "Error loading SMTP profile secrets. Credentials might not be available", (Throwable)e);
        }
    }

    private void refreshProfiles() {
        SMTPProfile previousProfile = this.profile;
        this.profile = null;
        this.profiles.clear();
        this.profiles.addAll(SMTPProfileManager.getProfiles());
        this.profileCombo.removeAll();
        for (SMTPProfile profile : this.profiles) {
            this.resolveProfileSecrets(profile);
            this.profileCombo.add(profile.toString());
        }
        int i = 0;
        while (i < this.profiles.size()) {
            if (previousProfile == null || this.profiles.get(i).getId().equals(previousProfile.getId())) {
                this.profileCombo.select(i);
                break;
            }
            ++i;
        }
        this.profileCombo.notifyListeners(13, new Event());
    }
}

