/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model;

import com.dbeaver.db.bigquery.model.BigQueryTable;
import com.dbeaver.db.bigquery.model.BigQueryUniqueKey;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLConstraintManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableCheckConstraint;

public class BigQueryPrimaryConstraintManager
extends SQLConstraintManager<BigQueryUniqueKey, BigQueryTable> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, BigQueryUniqueKey> getObjectsCache(BigQueryUniqueKey object) {
        return ((BigQueryTable)object.getParentObject()).getSchema().getUniqueConstraintCache();
    }

    protected BigQueryUniqueKey createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        BigQueryTable table = (BigQueryTable)((Object)container);
        return new BigQueryUniqueKey(table.getSchema().getParentObject().getName(), ((GenericStructContainer)table.getContainer()).getName(), (GenericTableBase)table, null, "PK_" + table.getName(), null, DBSEntityConstraintType.PRIMARY_KEY, false, 0, null);
    }

    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, BigQueryTable owner, DBECommandAbstract<BigQueryUniqueKey> command, Map<String, Object> options) {
        StringBuilder scriptBuilder = new StringBuilder();
        scriptBuilder.append(DBSEntityConstraintType.PRIMARY_KEY.getName());
        this.appendConstraintDefinition(scriptBuilder, command);
        scriptBuilder.append(" NOT ENFORCED");
        return scriptBuilder;
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        GenericUniqueKey key = (GenericUniqueKey)command.getObject();
        if (key.getConstraintType() == DBSEntityConstraintType.CHECK && key instanceof DBSTableCheckConstraint) {
            DBSTableCheckConstraint check = (DBSTableCheckConstraint)key;
            actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_constraint, "ALTER TABLE " + ((GenericTableBase)key.getParentObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ADD CONSTRAINT " + DBUtils.getQuotedIdentifier((DBSObject)key) + " CHECK (" + check.getCheckConstraintDefinition() + ")"));
        } else if (key.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY) {
            BigQueryTable table = (BigQueryTable)((BigQueryUniqueKey)command.getObject()).getTable();
            StringBuilder scriptBuilder = new StringBuilder();
            scriptBuilder.append("ALTER TABLE ").append(table.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ADD ").append(DBSEntityConstraintType.PRIMARY_KEY.getName());
            this.appendConstraintDefinition(scriptBuilder, (DBECommandAbstract)command);
            scriptBuilder.append(" NOT ENFORCED");
            actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_constraint, scriptBuilder.toString()));
        } else {
            super.addObjectCreateActions(monitor, executionContext, actions, command, options);
        }
    }

    protected String getDropConstraintPattern(BigQueryUniqueKey constraint) {
        GenericTableBase table = (GenericTableBase)constraint.getTable();
        return "ALTER TABLE " + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + " DROP PRIMARY KEY";
    }
}

