/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model;

import com.dbeaver.db.bigquery.model.BiQueryTypeNameParser;
import com.dbeaver.db.bigquery.model.BigQueryDataSourcePro;
import com.dbeaver.db.bigquery.model.BigQueryTableColumn;
import com.dbeaver.db.bigquery.model.BigQueryTableColumnDataTypeNested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.impl.struct.AbstractAttribute;
import org.jkiss.dbeaver.model.impl.struct.AbstractDataType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;

public abstract class BigQueryTableColumnDataTypeAbstract
extends AbstractDataType<BigQueryDataSourcePro>
implements DBSEntity {
    protected BigQueryTableColumn tableColumn;
    protected BiQueryTypeNameParser.SubType subType;

    public BigQueryTableColumnDataTypeAbstract(BigQueryTableColumn tableColumn, BiQueryTypeNameParser.SubType subType) {
        super((DBPDataSource)tableColumn.getDataSource());
        this.tableColumn = tableColumn;
        this.subType = subType;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TYPE;
    }

    @Nullable
    public List<? extends DBSEntityAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) {
        BiQueryTypeNameParser.SubType subType = this.subType;
        if (subType instanceof BiQueryTypeNameParser.StructType) {
            BiQueryTypeNameParser.StructType structType = (BiQueryTypeNameParser.StructType)subType;
            Map<String, BiQueryTypeNameParser.SubType> items = structType.getNestedItems();
            ArrayList<SubTypeAttribute> attributes = new ArrayList<SubTypeAttribute>(items.size());
            for (Map.Entry<String, BiQueryTypeNameParser.SubType> item : items.entrySet()) {
                attributes.add(new SubTypeAttribute(item.getKey(), item.getValue(), attributes.size()));
            }
            return attributes;
        }
        return null;
    }

    @Nullable
    public DBSDataType getComponentType(@NotNull DBRProgressMonitor monitor) throws DBException {
        BiQueryTypeNameParser.SubType subType = this.subType;
        if (subType instanceof BiQueryTypeNameParser.ArrayType) {
            BiQueryTypeNameParser.ArrayType arrayType = (BiQueryTypeNameParser.ArrayType)subType;
            BiQueryTypeNameParser.SubType itemType = arrayType.getItemType();
            while (itemType instanceof BiQueryTypeNameParser.ArrayType) {
                BiQueryTypeNameParser.ArrayType arrayType2 = (BiQueryTypeNameParser.ArrayType)itemType;
                itemType = arrayType2.getItemType();
            }
            return new BigQueryTableColumnDataTypeNested(this.tableColumn, itemType);
        }
        return super.getComponentType(monitor);
    }

    @Nullable
    public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public static void main(String[] args) {
        BiQueryTypeNameParser parser = new BiQueryTypeNameParser("STRUCT<ID ARRAY<STRING>, Name ARRAY<STRING>, Alias ARRAY<STRING>, Parent ARRAY<STRING>, Target ARRAY<STRING>, Gap ARRAY<STRING>, Derives_from ARRAY<STRING>, Note ARRAY<STRING>, Dbxref ARRAY<STRING>, Ontology_term ARRAY<BOOL>, vendor ARRAY<STRUCT<key STRING, value ARRAY<STRING>>>>");
        BiQueryTypeNameParser.SubType subType = parser.nextSubType();
        subType.parse(parser);
        System.out.println(subType);
    }

    private class SubTypeAttribute
    extends AbstractAttribute
    implements DBSTypedObjectEx,
    DBSEntityAttribute {
        private final BiQueryTypeNameParser.SubType subType;

        public SubTypeAttribute(String name, BiQueryTypeNameParser.SubType subType, int position) {
            this.subType = subType;
            this.name = name;
            this.ordinalPosition = position;
            Object fullTypeName = subType.getName();
            if (subType instanceof BiQueryTypeNameParser.ArrayType) {
                BiQueryTypeNameParser.ArrayType arrayType = (BiQueryTypeNameParser.ArrayType)subType;
                fullTypeName = (String)fullTypeName + "<" + arrayType.getItemType().getName() + ">";
            }
            this.typeName = fullTypeName;
        }

        @Nullable
        public String getDefaultValue() {
            return null;
        }

        @NotNull
        public DBSEntity getParentObject() {
            return BigQueryTableColumnDataTypeAbstract.this;
        }

        public BigQueryDataSourcePro getDataSource() {
            return (BigQueryDataSourcePro)BigQueryTableColumnDataTypeAbstract.this.getDataSource();
        }

        @NotNull
        public DBPDataKind getDataKind() {
            DBSDataType dataType = ((BigQueryDataSourcePro)BigQueryTableColumnDataTypeAbstract.this.getDataSource()).getLocalDataType(this.subType.getName());
            return dataType != null ? dataType.getDataKind() : DBPDataKind.STRING;
        }

        @Nullable
        public DBSDataType getDataType() {
            block3: {
                block2: {
                    if (this.subType instanceof BiQueryTypeNameParser.StructType) break block2;
                    BiQueryTypeNameParser.SubType subType = this.subType;
                    if (!(subType instanceof BiQueryTypeNameParser.ArrayType)) break block3;
                    BiQueryTypeNameParser.ArrayType arrayType = (BiQueryTypeNameParser.ArrayType)subType;
                }
                return new BigQueryTableColumnDataTypeNested(BigQueryTableColumnDataTypeAbstract.this.tableColumn, this.subType);
            }
            return this.getDataSource().getLocalDataType(this.subType.getName());
        }
    }
}

