/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model.data;

import com.dbeaver.db.bigquery.model.BigQueryColumnFieldInfo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import java.io.Reader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.bigquery.model.BigQueryDataSource;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCollection;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCComposite;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeMap;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStructValueHandler;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class BigQueryStructValueHandler
extends JDBCStructValueHandler {
    private static final Log log = Log.getLog(BigQueryStructValueHandler.class);
    private static final Gson gson = new GsonBuilder().setStrictness(Strictness.LENIENT).create();
    private DBSDataType structDataType;
    private DBSDataType arrayDataType;
    private BigQueryColumnFieldInfo[] columnFields;

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        try {
            BigQueryDataSource dataSource = (BigQueryDataSource)session.getDataSource();
            if (dataSource.getContainer().getPreferenceStore().getBoolean("resultset.transform.complex.type") && this.structDataType == null) {
                List rsColumnsMeta;
                Object columnMetaData;
                List nestedTypes;
                this.structDataType = dataSource.getLocalDataType("STRUCT");
                this.arrayDataType = dataSource.getLocalDataType("ARRAY");
                ResultSet bqResultSet = resultSet.getOriginal();
                if (bqResultSet.getClass().getName().startsWith("com.simba.googlebigquery.jdbc") && (nestedTypes = (List)BeanUtils.invokeObjectDeclaredMethod(columnMetaData = (rsColumnsMeta = (List)BeanUtils.invokeObjectDeclaredMethod((Object)bqResultSet, (String)"getResultSetColumns", (Class[])new Class[0], (Object[])new Object[0])).get(index - 1), (String)"getNestedTypes", (Class[])new Class[0], (Object[])new Object[0])) != null) {
                    this.columnFields = this.collectNestedTypes(nestedTypes);
                }
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Error reading BQ struct metadata", e);
        }
        return super.fetchColumnValue(session, resultSet, type, index);
    }

    private BigQueryColumnFieldInfo[] collectNestedTypes(List<?> nestedTypes) throws Exception {
        BigQueryColumnFieldInfo[] fields = new BigQueryColumnFieldInfo[nestedTypes.size()];
        int i = 0;
        while (i < nestedTypes.size()) {
            Object meta = nestedTypes.get(i);
            fields[i] = new BigQueryColumnFieldInfo((String)BeanUtils.readObjectProperty(meta, (String)"name"), (String)BeanUtils.readObjectProperty(meta, (String)"type"), (String)BeanUtils.readObjectProperty(meta, (String)"mode"));
            Object fieldsObj = BeanUtils.readObjectProperty(meta, (String)"fields");
            if (fieldsObj instanceof List) {
                List list = (List)fieldsObj;
                fields[i].setFields(this.collectNestedTypes(list));
            }
            ++i;
        }
        return fields;
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object instanceof DBDValue) {
            return object;
        }
        type.getTypeName();
        if (object == null) {
            return null;
        }
        if (this.structDataType != null) {
            if (object instanceof String) {
                String strValue = (String)object;
                try {
                    Map map = JSONUtils.parseMap((Gson)gson, (Reader)new StringReader(strValue));
                    return this.convertStructToValue(session, this.columnFields, map);
                }
                catch (Exception e) {
                    log.debug((Object)("Malformed JSON received (" + e.getMessage() + "). Show as string"));
                    return strValue;
                }
            }
            return super.getValueFromObject(session, type, object, copy, validateValue);
        }
        return object;
    }

    private Object convertStructToValue(DBCSession session, BigQueryColumnFieldInfo[] columnFields, Map<String, Object> struct) throws DBCException {
        LinkedHashMap result = new LinkedHashMap();
        Map<String, Object> value = struct.get("v");
        if (value == null) {
            value = struct;
        }
        List fieldValues = null;
        if (!(value instanceof Map)) {
            return this.transformValue(session, value, null);
        }
        Map<String, Object> vm = value;
        fieldValues = JSONUtils.getObjectList(vm, (String)"f");
        if (!CommonUtils.isEmpty((Collection)fieldValues)) {
            int i = 0;
            while (i < fieldValues.size()) {
                Map field = (Map)fieldValues.get(i);
                if (!field.containsKey("v")) {
                    log.debug((Object)"Field value missing");
                } else {
                    Object fieldValue = field.get("v");
                    if (columnFields == null) {
                        result.put("1", fieldValue);
                    } else if (i < columnFields.length) {
                        BigQueryColumnFieldInfo columnField = columnFields[i];
                        fieldValue = this.transformValue(session, fieldValue, columnField);
                        result.put(columnField.getName(), fieldValue);
                    } else {
                        log.debug((Object)("Field value out of index (" + i + ">=" + columnFields.length));
                    }
                }
                ++i;
            }
        }
        return new JDBCCompositeMap(session, this.structDataType, result);
    }

    private Object transformValue(DBCSession session, Object fieldValue, BigQueryColumnFieldInfo columnField) throws DBCException {
        if (fieldValue instanceof List) {
            List listValue = (List)fieldValue;
            ArrayList<Object> result = new ArrayList<Object>(listValue.size());
            for (Object item : listValue) {
                result.add(this.transformValue(session, item, columnField));
            }
            fieldValue = new JDBCCollection(session.getProgressMonitor(), this.arrayDataType, (DBDValueHandler)this, result.toArray());
        } else if (fieldValue instanceof Map) {
            Map mapValue = (Map)fieldValue;
            if (columnField != null && !ArrayUtils.isEmpty((Object[])columnField.getFields())) {
                fieldValue = this.convertStructToValue(session, columnField.getFields(), mapValue);
            } else {
                Map fvMap;
                Object v;
                if (mapValue.containsKey("v")) {
                    fieldValue = mapValue.get("v");
                }
                if (fieldValue instanceof Map && (v = (fvMap = (Map)fieldValue).get("f")) instanceof List) {
                    List fieldList = (List)v;
                    LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                    int i = 0;
                    while (i < this.columnFields.length) {
                        BigQueryColumnFieldInfo nextField = this.columnFields[i];
                        Object fv = this.transformValue(session, fieldList.get(i), nextField);
                        result.put(nextField.getName(), fv);
                        ++i;
                    }
                    return result;
                }
                if (fieldValue instanceof Map || fieldValue instanceof List) {
                    return this.transformValue(session, fieldValue, columnField);
                }
            }
        }
        return fieldValue;
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        Object[] values;
        if (value instanceof JDBCComposite && !ArrayUtils.isEmpty((Object[])(values = ((JDBCComposite)value).getValues()))) {
            return DBValueFormatting.getDefaultValueDisplayString((Object)values, (DBDDisplayFormat)format);
        }
        return super.getValueDisplayString(column, value, format);
    }
}

