/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.data.handlers;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.dbeaver.db.cassandra.CasUtils;
import com.dbeaver.db.cassandra.exec.CasPreparedStatement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.data.DateTimeCustomValueHandler;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.StringUtils;

public class CasTimestampValueHandler
extends DateTimeCustomValueHandler {
    public CasTimestampValueHandler(DBDFormatSettings formatSettings) {
        super(formatSettings);
    }

    @NotNull
    public String getFormatterId(DBSTypedObject column) {
        if (column.getTypeID() == DataTypes.DATE.getProtocolCode()) {
            return "date";
        }
        if (column.getTypeID() == DataTypes.TIME.getProtocolCode()) {
            return "time";
        }
        return "timestamp";
    }

    public Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        return resultSet.getAttributeValue(index);
    }

    public final void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject columnMetaData, int index, Object value) throws DBCException {
        try {
            Object dateValue = this.getValueFromObject(session, columnMetaData, value, false, false);
            int dataTypeId = columnMetaData.getTypeID();
            BoundStatement boundStat = ((CasPreparedStatement)statement).getBoundStatement();
            if (dateValue == null) {
                boundStat = (BoundStatement)boundStat.setToNull(index);
            } else if (dataTypeId == DataTypes.DATE.getProtocolCode()) {
                if (dateValue instanceof Number) {
                    boundStat = (BoundStatement)boundStat.setLocalDate(index, CasUtils.toLocalDate(new Date(((Number)dateValue).longValue())));
                } else if (dateValue instanceof LocalDate) {
                    boundStat = (BoundStatement)boundStat.setLocalDate(index, (LocalDate)dateValue);
                } else if (dateValue instanceof Date) {
                    boundStat = (BoundStatement)boundStat.setLocalDate(index, CasUtils.toLocalDate((Date)dateValue));
                }
            } else if (dataTypeId == DataTypes.TIME.getProtocolCode()) {
                if (dateValue instanceof Number) {
                    boundStat = (BoundStatement)boundStat.setLocalTime(index, CasUtils.toCasTime(Date.from(Instant.ofEpochMilli(((Number)dateValue).longValue()))));
                } else if (dateValue instanceof Date) {
                    boundStat = (BoundStatement)boundStat.setLocalTime(index, CasUtils.toCasTime((Date)dateValue));
                }
            } else if (dateValue instanceof Number) {
                Number number = (Number)dateValue;
                boundStat = (BoundStatement)boundStat.setInstant(index, new Date(number.longValue()).toInstant());
            } else if (dateValue instanceof Date) {
                Date date = (Date)dateValue;
                boundStat = (BoundStatement)boundStat.setInstant(index, date.toInstant());
            } else if (dateValue instanceof Instant) {
                Instant instant = (Instant)dateValue;
                boundStat = (BoundStatement)boundStat.setInstant(index, instant);
            }
            ((CasPreparedStatement)statement).updateBoundStatement(boundStat);
        }
        catch (Exception e) {
            throw new DBCException("Error binding statement parameter", (Throwable)e);
        }
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof Number || object instanceof Date || object instanceof LocalDate) {
            return object;
        }
        if (object instanceof String) {
            Object date;
            String value = (String)object;
            try {
                date = this.getFormatter(type).parseValue(value, null);
            }
            catch (ParseException parseException) {
                log.debug((Object)("Unsupported Cassandra date/time value: " + String.valueOf(object)));
                return object;
            }
            if (date == null) {
                return null;
            }
            if (date instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)date;
                return CasUtils.convertLocalDateTime(localDateTime, type);
            }
            if (date instanceof Date) {
                if (type.getTypeID() == DataTypes.TIME.getProtocolCode()) {
                    return CasUtils.toCasTime((Date)date);
                }
                if (type.getTypeID() == DataTypes.DATE.getProtocolCode()) {
                    return CasUtils.toLocalDate((Date)date);
                }
                return date;
            }
        } else if (object instanceof Instant) {
            return object;
        }
        throw new DBCException("Unsupported Cassandra date/time value: " + String.valueOf(object));
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (column instanceof DBSObject && this.formatSettings.isUseNativeDateTimeFormat()) {
            return DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)format);
        }
        if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value;
            if (format == DBDDisplayFormat.NATIVE) {
                value = StringUtils.quoteStringIfNotQuoted((String)localDate.toString());
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.set(1, localDate.getYear());
                calendar.set(2, localDate.getMonthValue() - 1);
                calendar.set(5, localDate.getDayOfMonth());
                value = calendar.getTime();
            }
        } else if (value instanceof Number) {
            Number number = (Number)value;
            if (column.getTypeID() == DataTypes.TIME.getProtocolCode()) {
                long nanos = number.longValue();
                Timestamp timestamp = new Timestamp(nanos / 1000000L - (long)TimeZone.getDefault().getRawOffset());
                timestamp.setNanos((int)(nanos % 1000000L));
                value = timestamp;
            } else {
                value = new Date(number.longValue());
            }
        } else if (value instanceof Instant && format == DBDDisplayFormat.NATIVE) {
            value = StringUtils.quoteStringIfNotQuoted((String)value.toString());
        }
        return super.getValueDisplayString(column, value, format);
    }
}

