/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.data.handlers;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.dbeaver.db.cassandra.data.CasTupleValue;
import com.dbeaver.db.cassandra.data.handlers.CasComplexValueHandler;
import com.dbeaver.db.cassandra.exec.CasPreparedStatement;
import com.dbeaver.db.cassandra.exec.CasSession;
import com.dbeaver.db.cassandra.model.CasDataSource;
import com.dbeaver.db.cassandra.model.CasExecutionContext;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasTupleValueHandler
extends CasComplexValueHandler {
    private static final Log log = Log.getLog(CasTupleValueHandler.class);
    public static final CasTupleValueHandler INSTANCE = new CasTupleValueHandler();

    @NotNull
    public Class<CasTupleValue> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return CasTupleValue.class;
    }

    public CasTupleValue getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            CasDataSource dataSource = (CasDataSource)session.getDataSource();
            return new CasTupleValue((CasExecutionContext)session.getExecutionContext(), dataSource.getDefaultKeyspaceName(), null);
        }
        if (object instanceof CasTupleValue) {
            return copy ? new CasTupleValue((CasTupleValue)object) : (CasTupleValue)object;
        }
        throw new DBCException("Unsupported tuple type: " + object.getClass().getName());
    }

    @Override
    protected void bindParameter(CasSession session, CasPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
        if (((CasTupleValue)value).getRawValue() == null) {
            statement.updateBoundStatement((BoundStatement)statement.getBoundStatement().setToNull(paramIndex));
            return;
        }
        statement.updateBoundStatement((BoundStatement)statement.getBoundStatement().setTupleValue(paramIndex, ((CasTupleValue)value).getRawValue()));
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof CasTupleValue) {
            return value.toString();
        }
        return super.getValueDisplayString(column, value, format);
    }
}

