/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.data.handlers;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.VectorType;
import com.datastax.oss.driver.internal.core.type.PrimitiveType;
import com.dbeaver.db.cassandra.data.handlers.CasBooleanValueHandler;
import com.dbeaver.db.cassandra.data.handlers.CasContentValueHandler;
import com.dbeaver.db.cassandra.data.handlers.CasInetValueHandler;
import com.dbeaver.db.cassandra.data.handlers.CasListValueHandler;
import com.dbeaver.db.cassandra.data.handlers.CasMapValueHandler;
import com.dbeaver.db.cassandra.data.handlers.CasNumberValueHandler;
import com.dbeaver.db.cassandra.data.handlers.CasSetValueHandler;
import com.dbeaver.db.cassandra.data.handlers.CasStringValueHandler;
import com.dbeaver.db.cassandra.data.handlers.CasTimestampValueHandler;
import com.dbeaver.db.cassandra.data.handlers.CasTupleValueHandler;
import com.dbeaver.db.cassandra.data.handlers.CasUDTValueHandler;
import com.dbeaver.db.cassandra.data.handlers.CasUUIDValueHandler;
import com.dbeaver.db.cassandra.data.handlers.CasVectorValueHandler;
import com.dbeaver.db.cassandra.model.CasTypedObject;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasValueHandlerProvider
implements DBDValueHandlerProvider {
    private static final Log log = Log.getLog(CasValueHandlerProvider.class);

    @Nullable
    public DBDValueHandler getValueHandler(DBPDataSource dataSource, DBDFormatSettings preferences, DBSTypedObject typedObject) {
        DataType typeName;
        if (typedObject instanceof CasTypedObject) {
            typeName = ((CasTypedObject)typedObject).getCasDataType();
        } else {
            try {
                if (typedObject.getTypeID() == 0) {
                    switch (typedObject.getDataKind()) {
                        case DATETIME: {
                            return new CasTimestampValueHandler(preferences);
                        }
                        case NUMERIC: {
                            return new CasNumberValueHandler(typedObject, (DataType)new PrimitiveType(9), preferences);
                        }
                        case STRING: {
                            return CasStringValueHandler.INSTANCE;
                        }
                    }
                    return CasContentValueHandler.INSTANCE;
                }
                typeName = new PrimitiveType(typedObject.getTypeID());
            }
            catch (Exception exception) {
                log.debug((Object)("Unknown Cassandra data type: " + typedObject.getTypeName()));
                return CasContentValueHandler.INSTANCE;
            }
        }
        switch (typeName.getProtocolCode()) {
            case 1: 
            case 13: {
                return CasStringValueHandler.INSTANCE;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 19: 
            case 20: {
                return new CasNumberValueHandler(typedObject, typeName, preferences);
            }
            case 4: {
                return CasBooleanValueHandler.INSTANCE;
            }
            case 11: 
            case 17: 
            case 18: {
                return new CasTimestampValueHandler(preferences);
            }
            case 12: 
            case 15: {
                return CasUUIDValueHandler.INSTANCE;
            }
            case 16: {
                return CasInetValueHandler.INSTANCE;
            }
            case 33: {
                return CasMapValueHandler.INSTANCE;
            }
            case 49: {
                return CasTupleValueHandler.INSTANCE;
            }
            case 48: {
                return CasUDTValueHandler.INSTANCE;
            }
            case 32: {
                return CasListValueHandler.INSTANCE;
            }
            case 34: {
                return CasSetValueHandler.INSTANCE;
            }
        }
        if (typeName instanceof VectorType && typeName.getProtocolCode() == 0) {
            return CasVectorValueHandler.INSTANCE;
        }
        return CasContentValueHandler.INSTANCE;
    }
}

