/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.exec;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.dbeaver.db.cassandra.exec.CasBaseStatement;
import com.dbeaver.db.cassandra.exec.CasSession;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.utils.CommonUtils;

public class CasPreparedStatement
extends CasBaseStatement {
    private final PreparedStatement statement;
    private BoundStatement boundStatement;

    public CasPreparedStatement(CasSession session, PreparedStatement statement) {
        super(session, statement.getQuery());
        this.statement = statement;
        this.boundStatement = statement.bind(new Object[0]);
        this.boundStatement = (BoundStatement)this.boundStatement.setConsistencyLevel(((CasSession)this.getSession()).getExecutionContext().getCurrentConsistencyLevel());
        if (CommonUtils.toBoolean((Object)((CasSession)this.getSession()).getDataSource().getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-enable.query.trace@"))) {
            this.boundStatement = (BoundStatement)this.boundStatement.enableTracing();
        }
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public BoundStatement getBoundStatement() {
        return this.boundStatement;
    }

    public void updateBoundStatement(BoundStatement statement) {
        this.boundStatement = statement;
    }

    public boolean executeStatement() throws DBCException {
        if (((CasSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        this.startBlock("Execute Cassandra statement");
        try {
            ((CasSession)this.getSession()).getProgressMonitor().subTask(this.getQueryString());
            CqlSession sessionImpl = ((CasSession)this.getSession()).getImpl();
            long timeoutMs = this.statementTimeout * 1000;
            if (timeoutMs > 0L) {
                this.boundStatement = (BoundStatement)this.boundStatement.setTimeout(Duration.ofMillis(timeoutMs));
            }
            this.resultSetFuture = sessionImpl.executeAsync((Statement)this.boundStatement);
            try {
                this.result = timeoutMs > 0L ? (AsyncResultSet)this.resultSetFuture.toCompletableFuture().get(timeoutMs, TimeUnit.SECONDS) : (AsyncResultSet)this.resultSetFuture.toCompletableFuture().get();
            }
            finally {
                this.resultSetFuture = null;
            }
            boolean bl = this.result != null;
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.endBlock();
            if (((CasSession)this.getSession()).isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }

    @Override
    public Statement getStatementImpl() {
        return this.boundStatement;
    }
}

