/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.model;

import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.dbeaver.db.cassandra.CasUtils;
import com.dbeaver.db.cassandra.exec.CasPreparedStatement;
import com.dbeaver.db.cassandra.exec.CasResultSet;
import com.dbeaver.db.cassandra.exec.CasSession;
import com.dbeaver.db.cassandra.exec.CasSimpleStatement;
import com.dbeaver.db.cassandra.model.CasCQLObject;
import com.dbeaver.db.cassandra.model.CasDataSource;
import com.dbeaver.db.cassandra.model.CasKeyspace;
import com.dbeaver.db.cassandra.model.CasPrivilegeGrant;
import com.dbeaver.db.cassandra.model.CasTableColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.data.ExecuteBatchImpl;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;
import org.jkiss.utils.ArrayUtils;

public abstract class CasTableBase
implements DBSTable,
DBSDataContainer,
DBSDataManipulator,
CasCQLObject,
DBPRefreshableObject {
    private static final Log log = Log.getLog(CasTableBase.class);
    private final CasKeyspace keyspace;
    private final ColumnCache columnCache = new ColumnCache();
    private List<CasPrivilegeGrant> privilegeGrants;

    protected CasTableBase(CasKeyspace keyspace) {
        this.keyspace = keyspace;
    }

    @Property(viewable=true, order=2)
    public CasKeyspace getKeyspace() {
        return this.keyspace;
    }

    public CasKeyspace getParentObject() {
        return this.keyspace;
    }

    @NotNull
    public CasDataSource getDataSource() {
        return this.keyspace.getDataSource();
    }

    public List<CasTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return monitor.isForceCacheUsage() ? this.columnCache.getCachedObjects() : this.columnCache.getAllObjects(monitor, this);
    }

    public CasTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return this.columnCache.getObject(monitor, this, attributeName);
    }

    public Collection<? extends DBSTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) {
        return null;
    }

    public Collection<? extends DBSTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) {
        return null;
    }

    @Association
    public List<CasPrivilegeGrant> getPrivilegeGrants(DBRProgressMonitor monitor) throws DBCException {
        if (this.privilegeGrants == null) {
            this.privilegeGrants = CasUtils.readPermissions(monitor, this.getDataSource(), "select role as username,resource,permissions from system_auth.role_permissions where resource ='data/" + this.getKeyspace().getName() + "/" + this.getName() + "' allow filtering");
        }
        return this.privilegeGrants;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.keyspace, this});
    }

    @NotNull
    public String[] getSupportedFeatures() {
        return new String[]{"data.count", "data.filter", "data.insert", "data.update", "data.delete"};
    }

    @NotNull
    public DBCStatistics readData(@Nullable DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        try {
            DBCStatistics statistics;
            block22: {
                CasSession casSession = (CasSession)session;
                statistics = new DBCStatistics();
                Object cql = "SELECT * FROM " + this.getFullyQualifiedName(DBPEvaluationContext.DML);
                cql = CasUtils.transformCQL(this.getDataSource(), (String)cql, dataFilter);
                if (maxRows > 0L) {
                    cql = (String)cql + " LIMIT " + (maxRows + (firstRow < 0L ? 0L : firstRow));
                }
                if (dataFilter != null && dataFilter.hasFilters()) {
                    cql = (String)cql + " ALLOW FILTERING";
                }
                Throwable throwable = null;
                Object var16_15 = null;
                try (CasSimpleStatement statement = new CasSimpleStatement(casSession, (String)cql);){
                    statement.setStatementSource(source);
                    statement.setLimit(firstRow, maxRows);
                    statistics.setQueryText(statement.getQueryString());
                    statistics.addStatementsCount();
                    if (!statement.executeStatement()) break block22;
                    Throwable throwable2 = null;
                    Object var19_20 = null;
                    try (CasResultSet resultSet = statement.openResultSet();){
                        DBDDataReceiver.startFetchWorkflow((DBDDataReceiver)dataReceiver, (DBCSession)casSession, (DBCResultSet)resultSet, (long)firstRow, (long)maxRows);
                        DBDDataReceiver.fetchRowsWithStatistics((DBDDataReceiver)dataReceiver, (DBCSession)casSession, (DBCResultSet)resultSet, (DBCStatistics)statistics);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            return statistics;
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        try {
            CasSession casSession = (CasSession)session;
            Object cql = "SELECT count(*) FROM " + this.getFullyQualifiedName(DBPEvaluationContext.DML);
            cql = CasUtils.transformCQL(this.getDataSource(), (String)cql, dataFilter);
            Throwable throwable = null;
            Object var9_10 = null;
            try (CasSimpleStatement statement = new CasSimpleStatement(casSession, (String)cql);){
                CasResultSet resultSet;
                statement.setStatementSource(source);
                if (!statement.executeStatement()) return -1L;
                Throwable throwable2 = null;
                Object var12_15 = null;
                try {
                    resultSet = statement.openResultSet();
                    try {
                        if (resultSet.nextRow()) {
                            long l = ((Number)resultSet.getAttributeValue(0)).longValue();
                            if (resultSet == null) return l;
                            resultSet.close();
                            return l;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (resultSet == null) throw throwable3;
                        resultSet.close();
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
                if (resultSet == null) return -1L;
                resultSet.close();
                return -1L;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch insertData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source, @NotNull Map<String, Object> options) throws DBCException {
        try {
            return new ExecuteBatchImpl(attributes, keysReceiver, true){

                @NotNull
                protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                    CasSession casSession = (CasSession)session;
                    StringBuilder cql = new StringBuilder();
                    cql.append("INSERT INTO ").append(CasTableBase.this.getFullyQualifiedName(DBPEvaluationContext.DML)).append(" (");
                    int i = 0;
                    while (i < this.attributes.length) {
                        if (i > 0) {
                            cql.append(",");
                        }
                        cql.append(CasTableBase.this.getAttributeName(this.attributes[i]));
                        ++i;
                    }
                    cql.append(") VALUES (");
                    i = 0;
                    while (i < this.attributes.length) {
                        if (i > 0) {
                            cql.append(',');
                        }
                        cql.append('?');
                        ++i;
                    }
                    cql.append(")");
                    PreparedStatement preparedStatement = CasTableBase.this.getDataSource().getCQLSession().prepare(cql.toString());
                    CasPreparedStatement statement = new CasPreparedStatement(casSession, preparedStatement);
                    statement.setStatementSource(source);
                    return statement;
                }

                protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                    int k = 0;
                    while (k < handlers.length) {
                        handlers[k].bindValueObject(statement.getSession(), statement, (DBSTypedObject)this.attributes[k], k, attributeValues[k]);
                        ++k;
                    }
                }
            };
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch updateData(@NotNull DBCSession session, final @NotNull DBSAttributeBase[] updateAttributes, final @NotNull DBSAttributeBase[] keyAttributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source) throws DBCException {
        try {
            DBSAttributeBase[] attributes = (DBSAttributeBase[])ArrayUtils.concatArrays((Object[])updateAttributes, (Object[])keyAttributes);
            return new ExecuteBatchImpl(attributes, keysReceiver, true){

                @NotNull
                protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                    CasSession casSession = (CasSession)session;
                    StringBuilder cql = new StringBuilder();
                    cql.append("UPDATE ").append(CasTableBase.this.getFullyQualifiedName(DBPEvaluationContext.DML)).append(" SET ");
                    int i = 0;
                    while (i < updateAttributes.length) {
                        if (i > 0) {
                            cql.append(",");
                        }
                        cql.append(CasTableBase.this.getAttributeName(updateAttributes[i])).append("=?");
                        ++i;
                    }
                    if (keyAttributes.length > 0) {
                        cql.append(" WHERE ");
                        i = 0;
                        while (i < keyAttributes.length) {
                            if (i > 0) {
                                cql.append(" AND ");
                            }
                            cql.append(CasTableBase.this.getAttributeName(keyAttributes[i])).append("=?");
                            ++i;
                        }
                    }
                    PreparedStatement preparedStatement = casSession.getImpl().prepare(cql.toString());
                    CasPreparedStatement statement = new CasPreparedStatement(casSession, preparedStatement);
                    statement.setStatementSource(source);
                    return statement;
                }

                protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                    int k = 0;
                    while (k < handlers.length) {
                        handlers[k].bindValueObject(statement.getSession(), statement, (DBSTypedObject)this.attributes[k], k, attributeValues[k]);
                        ++k;
                    }
                }
            };
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch deleteData(@NotNull DBCSession session, final @NotNull DBSAttributeBase[] keyAttributes, final @NotNull DBCExecutionSource source) throws DBCException {
        try {
            return new ExecuteBatchImpl(keyAttributes, null, true){

                @NotNull
                protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                    CasSession casSession = (CasSession)session;
                    StringBuilder cql = new StringBuilder();
                    cql.append("DELETE FROM ").append(CasTableBase.this.getFullyQualifiedName(DBPEvaluationContext.DML)).append(" WHERE ");
                    int i = 0;
                    while (i < keyAttributes.length) {
                        if (i > 0) {
                            cql.append(" AND ");
                        }
                        cql.append(CasTableBase.this.getAttributeName(keyAttributes[i])).append("=?");
                        ++i;
                    }
                    PreparedStatement preparedStatement = casSession.getImpl().prepare(cql.toString());
                    CasPreparedStatement statement = new CasPreparedStatement(casSession, preparedStatement);
                    statement.setStatementSource(source);
                    return statement;
                }

                protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                    int k = 0;
                    while (k < handlers.length) {
                        handlers[k].bindValueObject(statement.getSession(), statement, (DBSTypedObject)this.attributes[k], k, attributeValues[k]);
                        ++k;
                    }
                }
            };
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    @NotNull
    public DBCStatistics truncateData(@NotNull DBCSession session, @NotNull DBCExecutionSource source) throws DBCException {
        DBCStatistics statistics = new DBCStatistics();
        String cql = "TRUNCATE " + this.getFullyQualifiedName(DBPEvaluationContext.DML);
        ((CasSession)session).getImpl().execute(cql);
        statistics.addStatementsCount();
        statistics.addExecuteTime();
        return statistics;
    }

    private String getAttributeName(DBSAttributeBase attribute) {
        return DBUtils.getObjectFullName((DBPNamedObject)attribute, (DBPEvaluationContext)DBPEvaluationContext.DML);
    }

    protected abstract Collection<ColumnMetadata> getMetaColumns();

    @Nullable
    public List<? extends DBSTrigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.columnCache.clearCache();
        if (this.privilegeGrants != null) {
            this.privilegeGrants.clear();
        }
        return this;
    }

    class ColumnCache
    extends AbstractObjectCache<CasTableBase, CasTableColumn> {
        ColumnCache() {
        }

        @NotNull
        public List<CasTableColumn> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CasTableBase table) throws DBException {
            if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
                ArrayList<CasTableColumn> columns = new ArrayList<CasTableColumn>();
                Collection<ColumnMetadata> mdcs = CasTableBase.this.getMetaColumns();
                List<ColumnMetadata> list = mdcs.stream().toList();
                int i = 0;
                while (i < list.size()) {
                    ColumnMetadata tmd = list.get(i);
                    columns.add(new CasTableColumn(table, tmd, i));
                    if (monitor.isCanceled()) break;
                    ++i;
                }
                this.setCache(columns);
            }
            return this.getCachedObjects();
        }

        public CasTableColumn getObject(@NotNull DBRProgressMonitor monitor, @NotNull CasTableBase casKeyspace, @NotNull String name) throws DBException {
            return (CasTableColumn)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }
}

