/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql.ui;

import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class CosmosNoSQLConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private Text endpointText;
    private final DriverPropertiesDialogPage driverPropsPage = new DriverPropertiesDialogPage((ConnectionPageAbstract)this);

    public Image getImage() {
        DBPImage icon = this.getSite().getDriver().getIconBig();
        return DBeaverIcons.getImage((DBPImage)icon);
    }

    public boolean isComplete() {
        return this.endpointText != null;
    }

    public void createControl(Composite composite) {
        Composite settingsGroup = new Composite(composite, 0);
        settingsGroup.setLayout((Layout)new GridLayout(1, false));
        settingsGroup.setLayoutData((Object)new GridData(1808));
        Group addrGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)"Parameters", (int)1, (int)0, (int)0);
        addrGroup.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)addrGroup, (String)"Endpoint");
        Composite filesGroup = UIUtils.createComposite((Composite)addrGroup, (int)1);
        filesGroup.setLayoutData((Object)new GridData(768));
        this.endpointText = new Text(filesGroup, 2048);
        this.endpointText.setToolTipText("Endpoint");
        this.endpointText.setLayoutData((Object)new GridData(768));
        UIUtils.setDefaultTextControlWidthHint((Control)this.endpointText);
        this.createAuthPanel(settingsGroup, 1);
        this.createDriverPanel(settingsGroup);
        this.setControl((Control)settingsGroup);
    }

    @Nullable
    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{this.driverPropsPage};
    }

    public void loadSettings() {
        String endpoint = this.site.getActiveDataSource().getConnectionConfiguration().getServerName();
        this.endpointText.setText(CommonUtils.notEmpty((String)endpoint));
        super.loadSettings();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionConfiguration = dataSource.getConnectionConfiguration();
        connectionConfiguration.setServerName(this.endpointText.getText());
        super.saveSettings(dataSource);
    }

    @NotNull
    protected String getDefaultAuthModelId(DBPDataSourceContainer dataSource) {
        return "cosmos-key";
    }
}

