/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql;

import com.dbeaver.db.cosmos.nosql.DCosmosDatabase;
import com.dbeaver.db.cosmos.nosql.DCosmosNoSQLDataSource;
import com.dbeaver.db.cosmos.nosql.DCosmosSession;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCCachedContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCInvalidatePhase;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;

public class DCosmosNoSQLExecutionContext
extends AbstractExecutionContext<DCosmosNoSQLDataSource>
implements DBCExecutionContextDefaults<DCosmosDatabase, DBSSchema> {
    private static final Log log = Log.getLog(DCosmosNoSQLExecutionContext.class);
    private String selectedDatabase;

    public DCosmosNoSQLExecutionContext(@NotNull DCosmosNoSQLDataSource dataSource, String purpose, @Nullable String selectedDatabase) {
        super((DBPDataSource)dataSource, purpose);
        this.selectedDatabase = selectedDatabase;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((DCosmosNoSQLDataSource)this.dataSource).getContainer());
        try {
            try {
                monitor.subTask("Open Cosmos DB for NoSQL session");
                ((DCosmosNoSQLDataSource)this.dataSource).getContainer().getActualConnectionConfiguration();
                super.initContextBootstrap(monitor, true);
                ((DCosmosNoSQLDataSource)this.dataSource).addExecutionContext((DBCExecutionContext)this);
            }
            catch (Exception e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)this);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((DCosmosNoSQLDataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    public DCosmosNoSQLExecutionContext getContextDefaults() {
        return this;
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return true;
    }

    @NotNull
    public DBCSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String task) {
        return new DCosmosSession(monitor, purpose, task, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
        try {
            ((DCosmosNoSQLDataSource)this.dataSource).getClient().readAllDatabases().blockFirst();
        }
        catch (Exception e) {
            throw new DBException("Error pinging Dynamo", (Throwable)e);
        }
    }

    public void invalidateContext(@NotNull DBRProgressMonitor monitor, @NotNull DBCInvalidatePhase phase) throws DBException {
        if (phase == DBCInvalidatePhase.INVALIDATE) {
            monitor.subTask("Recreating client");
            this.close();
            ((DCosmosNoSQLDataSource)this.dataSource).recreateClient(monitor);
            this.connect(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DCosmosNoSQLExecutionContext dCosmosNoSQLExecutionContext = this;
        synchronized (dCosmosNoSQLExecutionContext) {
            ((DCosmosNoSQLDataSource)this.dataSource).removeExecutionContext((DBCExecutionContext)this);
            super.closeContext();
        }
    }

    @Nullable
    public DCosmosDatabase getDefaultCatalog() {
        try {
            return this.selectedDatabase != null ? ((DCosmosNoSQLDataSource)this.dataSource).getCachedDatabase((DBRProgressMonitor)new VoidProgressMonitor(), this.selectedDatabase) : (DCosmosDatabase)((DCosmosNoSQLDataSource)this.dataSource).getDatabases((DBRProgressMonitor)new VoidProgressMonitor()).stream().findFirst().orElse(null);
        }
        catch (DBException e) {
            log.error((Object)"Error reading database", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public DBSSchema getDefaultSchema() {
        return null;
    }

    public boolean supportsCatalogChange() {
        return true;
    }

    public boolean supportsSchemaChange() {
        return false;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, DCosmosDatabase catalog, @Nullable DBSSchema schema) throws DBCException {
        DCosmosDatabase oldSelectedEntity = this.getDefaultCatalog();
        this.selectedDatabase = catalog.getName();
        DBUtils.fireObjectSelectionChange((DBSObject)oldSelectedEntity, (DBSObject)catalog, (DBCExecutionContext)this);
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, DBSSchema schema) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        return true;
    }

    @NotNull
    public DBCCachedContextDefaults getCachedDefault() {
        return new DBCCachedContextDefaults(this.selectedDatabase, null);
    }

    public String getSelectedDatabase() {
        return this.selectedDatabase;
    }
}

