/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public record DCosmosContainerHint(@NotNull String databaseId, @NotNull String containerId) {
    private static final Pattern HINT = Pattern.compile("^\\s*cosmos\\s*:\\s*db\\s*=\\s*([\\w-]+)\\s+container\\s*=\\s*([\\w-]+)\\s*$", 2);
    private static final Pattern FROM = Pattern.compile("(?i)\\bfrom\\s+([\\w-]+(?:\\s*\\.\\s*[\\w-]+)*)", 2);

    @Nullable
    public static DCosmosContainerHint parseComment(@NotNull String hint) {
        Matcher matcher = HINT.matcher(hint);
        if (matcher.matches()) {
            return new DCosmosContainerHint(matcher.group(1), matcher.group(2));
        }
        return null;
    }

    @Nullable
    public static DCosmosContainerHint extractFromQuery(@Nullable String defaultDatabase, @NotNull String query) {
        Matcher matcher = FROM.matcher(query);
        if (matcher.find()) {
            String from = matcher.group(1);
            String[] parts = from.split("\\.");
            if (parts.length == 1 && defaultDatabase != null) {
                return new DCosmosContainerHint(defaultDatabase, parts[0]);
            }
            if (parts.length >= 2) {
                return new DCosmosContainerHint(parts[0], parts[1]);
            }
        }
        return null;
    }
}

