/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.cassandra.model;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.internal.core.connection.ConstantReconnectionPolicy;
import com.dbeaver.db.cassandra.model.CasDataSource;
import java.time.Duration;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.utils.CommonUtils;

public class CasCosmosDataSource
extends CasDataSource {
    private static final Log log = Log.getLog(CasCosmosDataSource.class);

    public CasCosmosDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        super(monitor, container);
    }

    public void initializeCluster(DBRProgressMonitor monitor) throws DBException {
        DBPConnectionConfiguration actualConnectionConfiguration = this.getContainer().getActualConnectionConfiguration();
        if (CommonUtils.isEmpty((String)actualConnectionConfiguration.getProviderProperty("@dbeaver-cas.net.datacenter@"))) {
            throw new DBException("Available Azure region should be specified in a local datacenter field");
        }
        super.initializeCluster(monitor);
    }

    protected void adjustProviderDriverSettings(ProgrammaticDriverConfigLoaderBuilder configBuilder) {
        ((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)configBuilder.withInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE, 10)).withInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE, 10)).withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, Duration.ofSeconds(90L))).withClass((DriverOption)DefaultDriverOption.RECONNECTION_POLICY_CLASS, ConstantReconnectionPolicy.class)).withBoolean((DriverOption)DefaultDriverOption.METADATA_TOKEN_MAP_ENABLED, false);
    }

    public DBWHandlerConfiguration getCustomSSLConfiguration(DBRProgressMonitor monitor, DBPConnectionConfiguration connectionInfo) {
        NetworkHandlerDescriptor sslHD = NetworkHandlerRegistry.getInstance().getDescriptor("cassandra_ssl");
        if (sslHD == null) {
            log.warn((Object)"No Mongo SSL handler descriptor found");
            return null;
        }
        DBWHandlerConfiguration sslConfig = new DBWHandlerConfiguration((DBWHandlerDescriptor)sslHD, this.getContainer());
        sslConfig.setEnabled(true);
        return sslConfig;
    }

    public boolean supportsPermissions() {
        return false;
    }
}

