/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.data;

import com.couchbase.client.java.json.JsonObject;
import com.dbeaver.db.couchbase3.CouchbaseUtils;
import com.dbeaver.db.couchbase3.model.CouchbaseDataSource;
import com.dbeaver.model.document.data.DBAbstractDocument;
import com.dbeaver.model.document.data.DBMapValue;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.IOUtils;

public class CouchbaseDocument
extends DBAbstractDocument<CouchbaseDataSource, JsonObject>
implements DBDValueCloneable {
    private static final Log log = Log.getLog(CouchbaseDocument.class);

    public CouchbaseDocument(@NotNull CouchbaseDataSource dataSource, @NotNull JsonObject jsonDocument) {
        super((DBPDataSource)dataSource, (Object)jsonDocument);
    }

    @Nullable
    public Object getDocumentId() {
        return ((JsonObject)this.rawValue).get("_id");
    }

    public Object getDocumentProperty(String name) {
        if (name.equals("idAttributeName")) {
            return "_id";
        }
        return null;
    }

    @NotNull
    public String getDocumentContentType() {
        return "text/json";
    }

    protected DBMapValue<CouchbaseDataSource> makeRawMap() {
        return CouchbaseUtils.makeRawMap((CouchbaseDataSource)this.dataSource, (Object)this, (JsonObject)this.rawValue);
    }

    public void serializeDocument(@NotNull DBRProgressMonitor monitor, @NotNull Writer writer) {
        ((CouchbaseDataSource)this.dataSource).serializeDocument((JsonObject)this.getRawValue(), writer);
    }

    public void updateDocument(@NotNull DBRProgressMonitor monitor, @NotNull Reader reader) throws IOException {
        this.rawValue = JsonObject.fromJson((String)IOUtils.readToString((Reader)reader));
        this.rawMap = this.makeRawMap();
        this.markModified();
    }

    public CouchbaseDocument copy() {
        return new CouchbaseDocument((CouchbaseDataSource)this.dataSource, (JsonObject)this.rawValue);
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return this.copy();
    }

    public String toString() {
        return ((JsonObject)this.rawValue).toString();
    }
}

