/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.exec;

import com.couchbase.client.core.diagnostics.ClusterState;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.retry.FailFastRetryStrategy;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.dbeaver.db.couchbase3.exec.CouchbaseSession;
import com.dbeaver.db.couchbase3.model.CouchbaseDataSource;
import java.nio.file.Paths;
import java.time.Duration;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCInvalidatePhase;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.utils.CommonUtils;

public class CouchbaseExecutionContext
extends AbstractExecutionContext<CouchbaseDataSource> {
    private static final Log log = Log.getLog(CouchbaseExecutionContext.class);
    private Cluster cluster;

    public CouchbaseExecutionContext(CouchbaseDataSource dataSource, String purpose) {
        super((DBPDataSource)dataSource, purpose);
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        this.connect(monitor, null, null);
    }

    public void connect(DBRProgressMonitor monitor, Boolean autoCommit, @Nullable Integer txnLevel) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((CouchbaseDataSource)this.dataSource).getContainer());
        try {
            try {
                this.reconnect(monitor);
                super.initContextBootstrap(monitor, true);
                ((CouchbaseDataSource)this.dataSource).addExecutionContext((DBCExecutionContext)this);
            }
            catch (Exception e) {
                this.close();
                throw new DBCException((Throwable)e, (DBCExecutionContext)this);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((CouchbaseDataSource)this.dataSource).getContainer());
        }
    }

    private void reconnect(@NotNull DBRProgressMonitor monitor) throws DBException {
        monitor.subTask("Open Couchbase session");
        this.disconnect();
        monitor.subTask("Setup environment");
        ClusterEnvironment.Builder envBuilder = ClusterEnvironment.builder();
        DBPConnectionConfiguration config = ((CouchbaseDataSource)this.dataSource).getContainer().getConnectionConfiguration();
        envBuilder.retryStrategy((RetryStrategy)FailFastRetryStrategy.INSTANCE);
        if (config.hasProperty("couchbase.connectionTimeout")) {
            envBuilder.timeoutConfig().connectTimeout(Duration.ofMillis(CommonUtils.toLong((Object)config.getProperty("couchbase.connectionTimeout"))));
        }
        if (config.hasProperty("couchbase.analyticsTimeout")) {
            envBuilder.timeoutConfig().analyticsTimeout(Duration.ofMillis(CommonUtils.toLong((Object)config.getProperty("couchbase.analyticsTimeout"))));
        }
        if (config.hasProperty("couchbase.kvTimeout")) {
            envBuilder.timeoutConfig().kvTimeout(Duration.ofMillis(CommonUtils.toLong((Object)config.getProperty("couchbase.kvTimeout"))));
        }
        if (config.hasProperty("couchbase.queryTimeout")) {
            envBuilder.timeoutConfig().queryTimeout(Duration.ofMillis(CommonUtils.toLong((Object)config.getProperty("couchbase.queryTimeout"))));
        }
        if (config.hasProperty("couchbase.managementTimeout")) {
            envBuilder.timeoutConfig().managementTimeout(Duration.ofMillis(CommonUtils.toLong((Object)config.getProperty("couchbase.managementTimeout"))));
        }
        if (config.hasProperty("couchbase.searchTimeout")) {
            envBuilder.timeoutConfig().searchTimeout(Duration.ofMillis(CommonUtils.toLong((Object)config.getProperty("couchbase.searchTimeout"))));
        }
        if (config.hasProperty("couchbase.viewTimeout")) {
            envBuilder.timeoutConfig().viewTimeout(Duration.ofMillis(CommonUtils.toLong((Object)config.getProperty("couchbase.viewTimeout"))));
        }
        if (config.hasProperty("couchbase.sslEnabled")) {
            if (config.hasProperty("couchbase.sslKeystoreFile")) {
                String sslFile = config.getProperty("couchbase.sslKeystoreFile");
                envBuilder.securityConfig().enableTls(true).trustCertificate(Paths.get(sslFile, new String[0]));
            } else {
                envBuilder.securityConfig().enableTls(CommonUtils.toBoolean((Object)config.getProperty("couchbase.sslEnabled")));
            }
        }
        DBPConnectionConfiguration configuration = ((CouchbaseDataSource)this.dataSource).getContainer().getActualConnectionConfiguration();
        String userName = configuration.getUserName();
        String userPassword = configuration.getUserPassword();
        PasswordAuthenticator authenticator = PasswordAuthenticator.create((String)userName, (String)userPassword);
        ClusterEnvironment environment = envBuilder.build();
        String nodeAddress = configuration.getHostName();
        String nodePort = configuration.getHostPort();
        String connectionString = CommonUtils.isNotEmpty((String)nodePort) ? nodeAddress + ":" + nodePort : nodeAddress;
        ClusterOptions clusterOptions = ClusterOptions.clusterOptions((Authenticator)authenticator).environment(environment);
        this.cluster = Cluster.connect((String)connectionString, (ClusterOptions)clusterOptions);
        int duration = CommonUtils.toInt((Object)((CouchbaseDataSource)this.dataSource).getContainer().getConnectionConfiguration().getProperty("couchbase.connectionTimeout"), (int)20000);
        this.cluster.waitUntilReady(Duration.ofMillis(duration));
    }

    @NotNull
    public CouchbaseSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new CouchbaseSession(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
        if (!this.cluster.diagnostics().state().equals((Object)ClusterState.ONLINE)) {
            this.close();
            throw new DBException("No active endpoints, check if you have correct configuration");
        }
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return this.cluster != null && this.cluster.diagnostics().state().equals((Object)ClusterState.ONLINE);
    }

    public void invalidateContext(@NotNull DBRProgressMonitor monitor, @NotNull DBCInvalidatePhase phase) throws DBException {
        if (phase == DBCInvalidatePhase.BEFORE_INVALIDATE) {
            this.disconnect();
        }
        if (phase == DBCInvalidatePhase.INVALIDATE) {
            this.reconnect(monitor);
            ((CouchbaseDataSource)this.dataSource).refreshObject(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.disconnect();
        CouchbaseExecutionContext couchbaseExecutionContext = this;
        synchronized (couchbaseExecutionContext) {
            ((CouchbaseDataSource)this.dataSource).removeExecutionContext((DBCExecutionContext)this);
            super.closeContext();
        }
    }

    private void disconnect() {
        if (this.cluster != null) {
            try {
                this.cluster.disconnect();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            this.cluster = null;
        }
    }
}

