/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.model.plan;

import com.couchbase.client.java.analytics.AnalyticsMetrics;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanNode;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class CouchbasePlanNode
extends AbstractExecutionPlanNode
implements DBPPropertySource {
    @Nullable
    private final CouchbasePlanNode parent;
    private Map<String, String> nodeProps = new LinkedHashMap<String, String>();
    private String nodeName;
    private final List<CouchbasePlanNode> nested = new ArrayList<CouchbasePlanNode>();

    public CouchbasePlanNode(@Nullable CouchbasePlanNode parent, @NotNull String name, @NotNull JsonObject value) {
        this.parent = parent;
        this.nodeName = name;
        this.readObject(value);
    }

    public CouchbasePlanNode(@Nullable CouchbasePlanNode parent, @NotNull Map<String, String> nodeAttributes) {
        this.parent = parent;
        this.nodeProps = nodeAttributes;
    }

    public void injectMetrics(@NotNull AnalyticsMetrics object) {
        this.nodeProps.put("elapsedTime", String.valueOf(object.elapsedTime().toMillis()));
        this.nodeProps.put("executionTime", String.valueOf(object.executionTime().toMillis()));
        this.nodeProps.put("processedObjects", String.valueOf(object.processedObjects()));
        this.nodeProps.put("resultSize", String.valueOf(object.resultSize()));
        this.nodeProps.put("resultCount", String.valueOf(object.resultCount()));
        this.nodeProps.put("warningCount", String.valueOf(object.warningCount()));
    }

    private void readObject(@NotNull JsonObject value) {
        for (Map.Entry prop : value.entrySet()) {
            String propertyKey = (String)prop.getKey();
            JsonElement propertyValue = (JsonElement)prop.getValue();
            if (propertyValue instanceof JsonObject) {
                if (!"plan".equals(propertyKey)) continue;
                this.readObject((JsonObject)propertyValue);
                this.addNested(propertyKey, (JsonObject)propertyValue);
                continue;
            }
            if (propertyValue instanceof JsonArray) {
                boolean isProp = false;
                for (JsonElement jsonElement : (JsonArray)propertyValue) {
                    if (jsonElement instanceof JsonObject) {
                        if ("~children".equals(propertyKey)) continue;
                        isProp = true;
                        break;
                    }
                    isProp = true;
                    break;
                }
                if (!isProp) continue;
                this.nodeProps.put(propertyKey, propertyValue.toString());
                continue;
            }
            if ("#operator".equals(propertyKey) && this.parent != null) {
                this.nodeName = propertyValue.getAsString();
                continue;
            }
            if ("text".equals(propertyKey) || propertyKey.equals("#operator") && propertyValue.getAsString().equals("Sequence")) continue;
            this.nodeProps.put(propertyKey, propertyValue.getAsString());
        }
    }

    private void addNested(@NotNull String name, @NotNull JsonObject value) {
        List<JsonObject> jsonObjects = this.addChildren(value);
        CouchbasePlanNode parentNode = this;
        for (JsonObject jsonObject : jsonObjects) {
            CouchbasePlanNode couchbasePlanNode = new CouchbasePlanNode(parentNode, name, jsonObject);
            parentNode.nested.add(couchbasePlanNode);
            parentNode = couchbasePlanNode;
        }
    }

    @NotNull
    private List<JsonObject> addChildren(@NotNull JsonObject object) {
        ArrayList<JsonObject> objects = new ArrayList<JsonObject>();
        JsonArray jsonArray = object.getAsJsonArray("~children");
        if (jsonArray != null) {
            for (JsonElement jsonElement : jsonArray) {
                if (!(jsonElement instanceof JsonObject)) continue;
                objects.addAll(this.addChildren((JsonObject)jsonElement));
            }
        } else {
            JsonElement childJson = object.get("~child");
            if (childJson != null) {
                if (childJson instanceof JsonObject) {
                    objects.addAll(this.addChildren((JsonObject)childJson));
                }
            } else {
                objects.add(object);
            }
        }
        return objects;
    }

    @Property(order=1, viewable=true)
    public String getNodeName() {
        return this.nodeName;
    }

    @Property(order=2, viewable=true)
    public String getBucket() {
        return this.nodeProps.get("bucket");
    }

    @Property(order=3, viewable=true)
    public String getIndex() {
        return this.nodeProps.get("index");
    }

    @Property(order=4, viewable=true)
    public String getIndexKeys() {
        return this.nodeProps.get("index_keys");
    }

    @Property(order=5, viewable=true, optional=true)
    public String getNamespace() {
        return this.nodeProps.get("namespace");
    }

    public Map<String, String> getNodeProps() {
        return Collections.unmodifiableMap(this.nodeProps);
    }

    public String getNodeType() {
        return this.nodeName;
    }

    public DBCPlanNode getParent() {
        return this.parent;
    }

    public Collection<? extends DBCPlanNode> getNested() {
        return this.nested;
    }

    @NotNull
    public Object getEditableValue() {
        return this;
    }

    @NotNull
    public DBPPropertyDescriptor[] getProperties() {
        DBPPropertyDescriptor[] props = new DBPPropertyDescriptor[this.nodeProps.size()];
        int index = 0;
        for (Map.Entry<String, String> attr : this.nodeProps.entrySet()) {
            props[index++] = new PropertyDescriptor("Details", attr.getKey(), attr.getKey(), null, String.class, false, null, null, false);
        }
        return props;
    }

    @Nullable
    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id) {
        return this.nodeProps.get(id);
    }

    public boolean isPropertySet(@NotNull String id) {
        return false;
    }

    public boolean isPropertyResettable(@NotNull String id) {
        return false;
    }

    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id) {
    }

    public void resetPropertyValueToDefault(@NotNull String id) {
    }

    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id, @Nullable Object value) {
    }
}

