/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchdb.data;

import com.dbeaver.db.couchdb.data.CouchDBDocument;
import com.dbeaver.db.couchdb.model.CouchDBDataSource;
import com.google.gson.JsonObject;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CouchDBDocumentValueHandler
implements DBDValueHandlerComposite {
    public static final CouchDBDocumentValueHandler INSTANCE = new CouchDBDocumentValueHandler();

    @NotNull
    public Class<Object> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Object.class;
    }

    @NotNull
    public String getValueContentType(@NotNull DBSTypedObject attribute) {
        return "text/json";
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof Map || value instanceof DBDValue) {
            return value.toString();
        }
        return DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)format);
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        CouchDBDataSource dataSource = (CouchDBDataSource)session.getDataSource();
        if (object == null) {
            return new CouchDBDocument(dataSource, new JsonObject());
        }
        if (object instanceof CouchDBDocument) {
            CouchDBDocument srcDocument = (CouchDBDocument)((Object)object);
            return copy ? srcDocument.copy() : srcDocument;
        }
        throw new DBCException("Unsupported struct type: " + object.getClass().getName());
    }

    public Object createNewValueObject(@NotNull DBCSession session, @NotNull DBSTypedObject type) throws DBCException {
        return new CouchDBDocument((CouchDBDataSource)session.getDataSource(), new JsonObject());
    }

    public void releaseValueObject(Object value) {
    }

    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(@NotNull DBSTypedObject attribute) {
        return new DBCLogicalOperator[]{DBCLogicalOperator.EQUALS, DBCLogicalOperator.NOT_EQUALS, DBCLogicalOperator.LESS, DBCLogicalOperator.GREATER};
    }

    public final Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        Object attributeValue = resultSet.getAttributeValue(0);
        return this.getValueFromObject(session, type, attributeValue, false, false);
    }

    public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, Object value) throws DBCException {
    }
}

