/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchdb.exec;

import com.dbeaver.db.couchdb.exec.CouchDBAbstractStatement;
import com.dbeaver.db.couchdb.exec.CouchDBResultSet;
import com.dbeaver.db.couchdb.exec.CouchDBSession;
import com.dbeaver.db.couchdb.model.CouchDBDatabase;
import com.google.gson.JsonObject;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.utils.CommonUtils;

public class CouchDBQueryStatement
extends CouchDBAbstractStatement {
    private static final Log log = Log.getLog(CouchDBQueryStatement.class);
    private CouchDBDatabase database;
    private final String queryText;
    private List<JsonObject> results;

    public CouchDBQueryStatement(CouchDBSession session, CouchDBDatabase database, String queryText) {
        super(session);
        this.database = database;
        this.queryText = queryText;
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    public String getQueryString() {
        return this.queryText;
    }

    public boolean executeStatement() throws DBCException {
        if (((CouchDBSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        Exception executeError = null;
        try {
            this.results = this.database.getClient().findDocs(this.queryText, JsonObject.class);
            return true;
        }
        catch (Exception e) {
            executeError = e;
            if (e instanceof DBCException) {
                DBCException dbe = (DBCException)e;
                throw dbe;
            }
            throw new DBCException(CommonUtils.getRootCause((Throwable)e), (DBCExecutionContext)((CouchDBSession)this.getSession()).getExecutionContext());
        }
        finally {
            if (((CouchDBSession)this.getSession()).isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, this.getUpdateRowCount(), (Throwable)executeError);
            }
        }
    }

    public CouchDBResultSet openResultSet() throws DBCException {
        return new CouchDBResultSet(this, this.results);
    }
}

