/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.databricks.ui;

import com.dbeaver.db.databricks.model.auth.DatabricksU2MAuthModel;
import com.dbeaver.db.databricks.ui.DatabricksUIMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class DatabricksU2MAuthConfigurator
implements IObjectPropertyConfigurator<DatabricksU2MAuthModel, DBPDataSourceContainer> {
    private Text httpPathText;

    public void createControl(@NotNull Composite authPanel, @NotNull DatabricksU2MAuthModel object, @NotNull Runnable propertyChangeListener) {
        this.httpPathText = UIUtils.createLabelText((Composite)authPanel, (String)DatabricksUIMessages.auth_configurator_http_path, (String)"", (int)2048);
        this.httpPathText.setMessage(DatabricksUIMessages.auth_configurator_http_path_message);
        this.httpPathText.setToolTipText(DatabricksUIMessages.auth_configurator_http_path_tip);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPConnectionConfiguration connectionInfo = dataSourceContainer.getConnectionConfiguration();
        if (this.httpPathText != null && !this.httpPathText.isDisposed()) {
            this.httpPathText.setText(CommonUtils.notEmpty((String)connectionInfo.getAuthProperty("httpPath")));
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPConnectionConfiguration connectionInfo = dataSourceContainer.getConnectionConfiguration();
        if (this.httpPathText != null && !this.httpPathText.isDisposed()) {
            connectionInfo.setAuthProperty("httpPath", this.httpPathText.getText().trim());
        }
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        this.loadSettings(dataSourceContainer);
    }

    public boolean isComplete() {
        return !this.httpPathText.getText().isEmpty();
    }
}

