/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.databricks.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.utils.CommonUtils;

public class DatabricksUtils {
    public static void setPropIfNotSet(@NotNull Properties connProperties, @NotNull Map<String, String> urlParams, @NotNull String propName, @Nullable String propValue) {
        if (!DatabricksUtils.isPropSpecified(connProperties, urlParams, propName)) {
            if (propValue == null) {
                connProperties.remove(propName);
            } else {
                connProperties.put(propName, propValue);
            }
        }
    }

    public static boolean isPropSpecified(@NotNull Properties connProperties, @NotNull Map<String, String> urlParams, @NotNull String propName) {
        return connProperties.contains(propName) || urlParams.containsKey(propName);
    }

    @NotNull
    public static Map<String, String> extractUrlParameters(@NotNull DBPConnectionConfiguration configuration) {
        int divPos;
        String url = configuration.getUrl();
        LinkedHashMap<String, String> urlParameters = new LinkedHashMap<String, String>();
        if (!CommonUtils.isEmpty((String)url) && (divPos = url.indexOf(59)) != -1 && divPos < url.length() - 1) {
            String[] stringArray = url.substring(divPos + 1).split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                String[] pv = param.split("=");
                if (pv.length == 2) {
                    urlParameters.put(pv[0], pv[1]);
                } else {
                    urlParameters.put(pv[0], null);
                }
                ++n2;
            }
        }
        return urlParameters;
    }
}

