/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.databricks.model.auth;

import com.dbeaver.db.databricks.model.auth.DatabricksPersonalAccessTokenAuthCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DatabricksPersonalAccessTokenAuthModel
implements DBAAuthModel<DatabricksPersonalAccessTokenAuthCredentials> {
    @NotNull
    public DatabricksPersonalAccessTokenAuthCredentials createCredentials() {
        return new DatabricksPersonalAccessTokenAuthCredentials();
    }

    @NotNull
    public DatabricksPersonalAccessTokenAuthCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        DatabricksPersonalAccessTokenAuthCredentials credentials = this.createCredentials();
        credentials.setHttpPath(configuration.getAuthProperty("httpPath"));
        credentials.setPersonalAccessToken(configuration.getAuthProperty("PWD"));
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull DatabricksPersonalAccessTokenAuthCredentials credentials) {
        configuration.setAuthProperty("httpPath", credentials.getHttpPath());
        configuration.setAuthProperty("PWD", credentials.getPersonalAccessToken());
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull DatabricksPersonalAccessTokenAuthCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        String pwd = credentials.getPersonalAccessToken();
        String httpPath = credentials.getHttpPath();
        if (pwd != null && httpPath != null) {
            connProperties.put("transportMode", "http");
            connProperties.put("ssl", "1");
            connProperties.put("httpPath", httpPath);
            connProperties.put("AuthMech", "3");
            connProperties.put("UID", "token");
            connProperties.put("PWD", pwd);
        }
        return credentials;
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
    }

    public void refreshCredentials(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull DatabricksPersonalAccessTokenAuthCredentials credentials) throws DBException {
    }
}

