/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.db2.zos;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.dbeaver.Log;

public class DB2ZOSUtils {
    private static final Log log = Log.getLog(DB2ZOSUtils.class);
    private static final Pattern CREATE_TABLE_PATTERN = Pattern.compile("CREATE +TABLE +", 2);
    private static final Pattern CREATE_INDEX_PATTERN = Pattern.compile("CREATE +[\\w\\s]*INDEX +", 2);

    public static String extractDefinition(Pattern pattern, String rawDDL) {
        StringBuilder ddl = new StringBuilder();
        Matcher matcher = pattern.matcher(rawDDL);
        while (matcher.find()) {
            int startPos = matcher.start();
            int endPos = rawDDL.indexOf(59, startPos);
            if (endPos < 0) {
                endPos = rawDDL.length();
            }
            ddl.append(rawDDL, startPos, endPos);
            ddl.append(";\n\n");
        }
        return ddl.toString();
    }

    public static String extractTableDDL(String rawDDL, boolean showIndexes) {
        StringBuilder ddl = new StringBuilder();
        String tableDDL = DB2ZOSUtils.extractDefinition(CREATE_TABLE_PATTERN, rawDDL);
        if (tableDDL.isEmpty()) {
            log.debug((Object)"Cannot detect table DDL. Show raw DDL");
            return rawDDL;
        }
        ddl.append(tableDDL);
        if (showIndexes) {
            ddl.append(DB2ZOSUtils.extractDefinition(CREATE_INDEX_PATTERN, rawDDL));
        }
        return ddl.toString();
    }
}

