/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.DynamoDBUtils;
import com.dbeaver.db.dynamodb.data.DynamoDocument;
import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoSQL;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;

public class DynamoDeleteStatement
extends DynamoBaseStatement {
    private static final Log log = Log.getLog(DynamoDeleteStatement.class);
    @Nullable
    private DynamoTable table;
    @Nullable
    private DBSAttributeBase[] valueAttributes;
    @Nullable
    private Object[] rowValues;
    @Nullable
    private String statementText;

    public DynamoDeleteStatement(@NotNull DynamoSession session, @NotNull String statementText) {
        super(session);
        this.table = null;
        this.valueAttributes = null;
        this.rowValues = null;
        this.statementText = statementText;
    }

    public DynamoDeleteStatement(@NotNull DynamoSession session, @NotNull DBCExecutionSource source, @NotNull DynamoTable table, @NotNull DBSAttributeBase[] keyAttributes, @NotNull Object[] rowValues) {
        super(session, source);
        this.table = table;
        this.valueAttributes = keyAttributes;
        this.rowValues = rowValues;
        this.statementText = null;
    }

    public void setRowValues(@Nullable Object[] rowValues) {
        this.rowValues = rowValues;
    }

    @Nullable
    public String getQueryString() {
        return this.statementText != null ? this.statementText : (this.statementText = this.makeStatementText());
    }

    @NotNull
    private String makeStatementText() {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(this.table.getName()).append(" WHERE ");
        if (this.valueAttributes.length == 1 && this.valueAttributes[0].getDataKind() == DBPDataKind.DOCUMENT) {
            try {
                Map<String, AttributeValue> keyValue = ((DynamoDocument)((Object)this.rowValues[0])).getKeyValues(((DynamoSession)this.getSession()).getProgressMonitor());
                boolean first = true;
                for (Map.Entry<String, AttributeValue> ae : keyValue.entrySet()) {
                    sql.append("\n");
                    if (!first) {
                        sql.append("AND ");
                    }
                    first = false;
                    sql.append(ae.getKey()).append(" = '").append(DynamoDBUtils.getRawAttributeValue((DynamoDataSource)this.table.getDataSource(), null, ae.getValue())).append("'");
                }
            }
            catch (DBException e) {
                sql.append(e.getMessage());
            }
        } else {
            sql.append("??? -- Unsupported key type");
        }
        return sql.toString();
    }

    public boolean executeStatement() throws DBCException {
        if (this.valueAttributes != null && this.table != null && this.rowValues != null) {
            DeleteItemRequest dir = this.prepareDeleteRequest();
            ((DynamoSession)this.getSession()).getDataSource().getClient().deleteItem(dir);
            log.debug((Object)("DeleteItem request was sent: " + dir.toString()));
        } else if (this.statementText != null) {
            this.executePreparedStatement();
        } else {
            throw new DBCException("Not enough information to prepare delete request");
        }
        return false;
    }

    @NotNull
    private DeleteItemRequest prepareDeleteRequest() throws DBCException {
        try {
            Map<Object, Object> keyValue;
            if (this.valueAttributes.length == 1 && this.valueAttributes[0].getDataKind() == DBPDataKind.DOCUMENT) {
                keyValue = ((DynamoDocument)((Object)this.rowValues[0])).getKeyValues(((DynamoSession)this.getSession()).getProgressMonitor());
            } else {
                keyValue = new LinkedHashMap();
                int i = 0;
                while (i < this.valueAttributes.length) {
                    DBSAttributeBase ka = this.valueAttributes[i];
                    if (this.table.getKey(((DynamoSession)this.getSession()).getProgressMonitor()).containsAttribute(ka.getName())) {
                        keyValue.put(ka.getName(), DynamoDBUtils.getAttributeValueFromPOJO(this.rowValues[i]));
                    }
                    ++i;
                }
            }
            if (keyValue.isEmpty()) {
                throw new DBCException("Empty key specified for delete");
            }
            DeleteItemRequest dir = (DeleteItemRequest)DeleteItemRequest.builder().tableName(this.table.getName()).key(keyValue).build();
            return dir;
        }
        catch (DBException e) {
            if (e instanceof DBCException) {
                throw (DBCException)e;
            }
            throw new DBCException(CommonUtils.getRootCause((Throwable)e), (DBCExecutionContext)((DynamoSession)this.getSession()).getExecutionContext());
        }
    }

    private void executePreparedStatement() throws DBCException {
        Delete delete;
        Statement statement = SQLSemanticProcessor.parseQuery((String)this.statementText);
        if (statement instanceof Delete) {
            delete = (Delete)statement;
            if (delete.getTables().size() != 1 && delete.getTable() == null || delete.getLimit() != null || delete.getWhere() != null || !CommonUtils.isEmpty((Collection)delete.getJoins()) || !CommonUtils.isEmpty((Collection)delete.getOrderByElements()) || !CommonUtils.isEmpty((Collection)delete.getUsingList()) || !CommonUtils.isEmpty((Collection)delete.getWithItemsList())) {
                throw new DBCException("Unsupported SQL query");
            }
        } else {
            throw new DBCException("This type of statement is not supported");
        }
        DynamoTable table = this.getDynamoTable(delete.getTable().getName());
        DeleteItemRequest dir = this.prepareParsedDeleteItemRequest(table, delete.getWhere());
        ((DynamoSession)this.getSession()).getDataSource().getClient().deleteItem(dir);
    }

    @NotNull
    private DeleteItemRequest prepareParsedDeleteItemRequest(@NotNull DynamoTable table, @NotNull Expression where) throws DBCException {
        DeleteItemRequest.Builder dir = DeleteItemRequest.builder();
        dir.tableName(table.getName());
        DynamoSQL.RequestConditionsInfo condition = DynamoSQL.prepareMutationConditions(table, where);
        if (condition.getFilterExpression().length() > 0) {
            dir.conditionExpression(condition.getFilterExpression());
        }
        if (!condition.getExprAttrNames().isEmpty()) {
            dir.expressionAttributeNames(condition.getExprAttrNames());
        }
        if (!condition.getExprAttrValues().isEmpty()) {
            dir.expressionAttributeValues(condition.getExprAttrValues());
        }
        if (!condition.getKeyValues().isEmpty()) {
            dir.key(condition.getKeyValues());
        }
        return (DeleteItemRequest)dir.build();
    }

    @Override
    @Nullable
    public DBCResultSet openResultSet() throws DBCException {
        return null;
    }

    @Override
    @Nullable
    public DynamoTable getSourceEntity() {
        return this.table;
    }
}

