/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.model.DynamoKeyType;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.dbeaver.db.dynamodb.model.DynamoTableAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.schema.Column;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.ImmutableMap;

public class DynamoSQL {
    @Nullable
    public static Object parseValueExpression(@NotNull Expression expr) throws DBCException {
        if (expr instanceof StringValue) {
            return ((StringValue)expr).getValue();
        }
        if (expr instanceof LongValue) {
            try {
                return ((LongValue)expr).getValue();
            }
            catch (NumberFormatException numberFormatException) {
                return ((LongValue)expr).getBigIntegerValue();
            }
        }
        if (expr instanceof DoubleValue) {
            return ((DoubleValue)expr).getValue();
        }
        if (expr instanceof TimestampValue) {
            return ((TimestampValue)expr).getValue();
        }
        if (expr instanceof TimeValue) {
            return ((TimeValue)expr).getValue();
        }
        if (expr instanceof DateValue) {
            return ((DateValue)expr).getValue();
        }
        if (expr instanceof Column) {
            String literal = DynamoSQL.unquote(((Column)expr).getFullyQualifiedName());
            if (literal.equals("true") || literal.equals("false")) {
                return Boolean.valueOf(literal);
            }
            throw new DBCException("Unexpected literal: " + String.valueOf(expr));
        }
        if (expr instanceof NullValue) {
            return null;
        }
        throw new DBCException("Unsupported value: " + String.valueOf(expr));
    }

    @NotNull
    public static String unquote(@NotNull String name) {
        return name.replace("\"", "");
    }

    public static RequestConditionsInfo prepareSelectionConditions(@NotNull DynamoTable table, @NotNull Expression expr) throws DBCException {
        DynamoSQLExpressionAnalyzer analyzer = new DynamoSQLExpressionAnalyzer(table);
        analyzer.analyze(expr);
        DynamoConditionFormatter formatter = new DynamoConditionFormatter();
        if (analyzer.hasComposableKeyCondition()) {
            String keyCondExpression = formatter.format(analyzer.combineKeyConditions());
            String filterCondExpression = formatter.format(analyzer.combineOtherConditions());
            return new RequestConditionsInfo(keyCondExpression, filterCondExpression, formatter.getAttributeNamesMap(), formatter.getExpressionValuesMap(), Collections.emptyMap());
        }
        String completeCondExpression = formatter.format(analyzer.combineAllConditions());
        return new RequestConditionsInfo("", completeCondExpression, formatter.getAttributeNamesMap(), formatter.getExpressionValuesMap(), Collections.emptyMap());
    }

    public static RequestConditionsInfo preparePartialScanConditions(@NotNull DynamoTable table, @NotNull Expression expr) throws DBCException {
        DynamoSQLExpressionAnalyzer analyzer = new DynamoSQLExpressionAnalyzer(table);
        analyzer.analyze(expr);
        DynamoConditionFormatter formatter = new DynamoConditionFormatter();
        String completeCondExpression = formatter.format(analyzer.combineAllConditions());
        return new RequestConditionsInfo("", completeCondExpression, formatter.getAttributeNamesMap(), formatter.getExpressionValuesMap(), analyzer.getItemKeyValues());
    }

    public static RequestConditionsInfo prepareMutationConditions(@NotNull DynamoTable table, @NotNull Expression expr) throws DBCException {
        DynamoSQLExpressionAnalyzer analyzer = new DynamoSQLExpressionAnalyzer(table);
        analyzer.analyze(expr);
        if (!analyzer.hasCompleteItemKey()) {
            throw new DBCException("Incomplete item key condition while one fixed value for each key attribute expected");
        }
        if (analyzer.hasExcessiveMutationKeyValues()) {
            throw new DBCException("Excessive key values presented while one fixed value for each key attribute expected.");
        }
        if (analyzer.hasExcessiveMutationKeyConditions()) {
            throw new DBCException("Excessive key conditions presented while one fixed value for each key attribute expected.");
        }
        DynamoConditionFormatter formatter = new DynamoConditionFormatter();
        String mutationFilterExpression = formatter.format(analyzer.combineOtherConditions());
        return new RequestConditionsInfo("", mutationFilterExpression, formatter.getAttributeNamesMap(), formatter.getExpressionValuesMap(), analyzer.getItemKeyValues());
    }

    static class DynamoAndExpr
    extends DynamoCondGroupExpr {
        protected DynamoAndExpr(@NotNull List<DynamoCondExpr> exprs) {
            super(exprs);
        }

        @Override
        @NotNull
        protected <T, R> R applyImpl(@NotNull DynamoConditionPartsVisitor<T, R> visitor, @NotNull T arg) {
            return visitor.visitAndExpr(this, arg);
        }
    }

    static class DynamoAttrRefOpnd
    extends DynamoCondOpnd {
        @NotNull
        public final String name;

        public DynamoAttrRefOpnd(@NotNull String name) {
            this.name = name;
        }

        @Override
        @NotNull
        protected <T, R> R applyImpl(@NotNull DynamoConditionPartsVisitor<T, R> visitor, @NotNull T arg) {
            return visitor.visitAttrRefOperand(this, arg);
        }
    }

    static class DynamoBetweenExpr
    extends DynamoCondExpr {
        @NotNull
        public final DynamoCondOpnd subj;
        @NotNull
        public final DynamoCondOpnd from;
        @NotNull
        public final DynamoCondOpnd to;

        public DynamoBetweenExpr(@NotNull DynamoCondOpnd subj, @NotNull DynamoCondOpnd from, @NotNull DynamoCondOpnd to) {
            this.subj = subj;
            this.from = from;
            this.to = to;
        }

        @Override
        @NotNull
        protected <T, R> R applyImpl(@NotNull DynamoConditionPartsVisitor<T, R> visitor, @NotNull T arg) {
            return visitor.visitBetweenExpr(this, arg);
        }
    }

    static class DynamoCompareExpr
    extends DynamoCondExpr {
        @NotNull
        public final DynamoCompareOperator operator;
        @NotNull
        public final DynamoCondOpnd left;
        @NotNull
        public final DynamoCondOpnd right;

        public DynamoCompareExpr(@NotNull DynamoCompareOperator operator, @NotNull DynamoCondOpnd left, @NotNull DynamoCondOpnd right) {
            this.operator = operator;
            this.left = left;
            this.right = right;
        }

        @Override
        @NotNull
        protected <T, R> R applyImpl(@NotNull DynamoConditionPartsVisitor<T, R> visitor, @NotNull T arg) {
            return visitor.visitCompareExpr(this, arg);
        }
    }

    static enum DynamoCompareOperator {
        Equal("=", true),
        NotEqual("<>", true),
        Greater(">", true),
        Less("<", true),
        GreaterOrEqual(">=", false),
        LessOrEqual("<=", false);

        @NotNull
        public final String symbol;
        public final boolean isStrictComparison;

        private DynamoCompareOperator(String symbol, boolean isStrictComparison) {
            this.symbol = symbol;
            this.isStrictComparison = isStrictComparison;
        }
    }

    static abstract class DynamoCondExpr
    extends DynamoCondPart {
        DynamoCondExpr() {
        }
    }

    static class DynamoCondExprBuilder {
        private int exprIdCount = 0;
        private int totalPartsCount = 0;
        private int valuePartsCount = 0;
        @Nullable
        private DynamoAttrRefOpnd lastAttrRefOpnd = null;
        @Nullable
        private DynamoValueOpnd lastValueOpnd = null;
        @Nullable
        private DynamoCompareExpr lastCompareExpr = null;
        @Nullable
        private DynamoBetweenExpr lastBetweenExpr = null;
        @Nullable
        private DynamoCondFuncExpr lastFunctionExpr;
        @NotNull
        private Set<String> referencedAttributeNames = new HashSet<String>();

        public int nextExprId() {
            return ++this.exprIdCount;
        }

        public int getPartsCount() {
            return this.totalPartsCount;
        }

        @Nullable
        public DynamoAttrRefOpnd getLastAttrRefOpnd() {
            return this.lastAttrRefOpnd;
        }

        @Nullable
        public DynamoValueOpnd getLastValueOpnd() {
            return this.lastValueOpnd;
        }

        @Nullable
        public DynamoCompareExpr getLastCompareExpr() {
            return this.lastCompareExpr;
        }

        @Nullable
        public Set<String> getReferencedAttributeNames() {
            return this.referencedAttributeNames;
        }

        public boolean seemsAttributeComparisonWasBuild() {
            return this.totalPartsCount == 3 && this.lastAttrRefOpnd != null && this.lastValueOpnd != null && this.lastCompareExpr != null;
        }

        public boolean seemsAttributeRangeCheckWasBuild() {
            return this.totalPartsCount == 4 && this.valuePartsCount == 2 && this.lastAttrRefOpnd != null && this.lastBetweenExpr != null;
        }

        public boolean seemsAttributePrefixCheckWasBuild() {
            return this.totalPartsCount == 3 && this.lastAttrRefOpnd != null && this.lastValueOpnd != null && this.lastFunctionExpr != null && this.lastFunctionExpr.kind == DynamoCondFunctionKind.BeginsWith;
        }

        @NotNull
        private <T extends DynamoCondPart> T registerPart(@NotNull T part) {
            ++this.totalPartsCount;
            return part;
        }

        @NotNull
        public DynamoOrExpr makeOr(@NotNull List<DynamoCondExpr> exprs) {
            return this.registerPart(new DynamoOrExpr(exprs));
        }

        @NotNull
        public DynamoAndExpr makeAnd(@NotNull List<DynamoCondExpr> exprs) {
            return this.registerPart(new DynamoAndExpr(exprs));
        }

        @NotNull
        public DynamoNotExpr makeNot(@NotNull DynamoCondExpr child) {
            return this.registerPart(new DynamoNotExpr(child));
        }

        @NotNull
        public DynamoCompareExpr makeCompare(@NotNull DynamoCompareOperator operator, @NotNull DynamoCondOpnd left, @NotNull DynamoCondOpnd right) {
            this.lastCompareExpr = new DynamoCompareExpr(operator, left, right);
            return this.registerPart(this.lastCompareExpr);
        }

        @NotNull
        public DynamoInExpr makeIn(@NotNull DynamoCondOpnd subj, @NotNull List<DynamoCondOpnd> entries) {
            return this.registerPart(new DynamoInExpr(subj, entries));
        }

        @NotNull
        public DynamoBetweenExpr makeBetween(@NotNull DynamoCondOpnd subj, @NotNull DynamoCondOpnd from, @NotNull DynamoCondOpnd to) {
            this.lastBetweenExpr = new DynamoBetweenExpr(subj, from, to);
            return this.registerPart(this.lastBetweenExpr);
        }

        @NotNull
        public DynamoCondFuncExpr makeAttributeExists(@NotNull DynamoAttrRefOpnd attr) {
            this.lastFunctionExpr = DynamoCondFuncExpr.makeAttributeExists(attr);
            return this.registerPart(this.lastFunctionExpr);
        }

        @NotNull
        public DynamoCondFuncExpr makeAttributeNotExists(@NotNull DynamoAttrRefOpnd attr) {
            this.lastFunctionExpr = DynamoCondFuncExpr.makeAttributeNotExists(attr);
            return this.registerPart(this.lastFunctionExpr);
        }

        @NotNull
        public DynamoCondFuncExpr makeContains(@NotNull DynamoAttrRefOpnd attr, @NotNull DynamoCondOpnd part) {
            this.lastFunctionExpr = DynamoCondFuncExpr.makeContains(attr, part);
            return this.registerPart(this.lastFunctionExpr);
        }

        @NotNull
        public DynamoCondFuncExpr makeBeginsWith(@NotNull DynamoAttrRefOpnd attr, @NotNull DynamoValueOpnd part) {
            this.lastFunctionExpr = DynamoCondFuncExpr.makeBeginsWith(attr, part);
            return this.registerPart(this.lastFunctionExpr);
        }

        @NotNull
        public DynamoCondFuncExpr makeAttributeType(@NotNull DynamoAttrRefOpnd attrRef, @NotNull DynamoValueOpnd typeNameStr) {
            this.lastFunctionExpr = DynamoCondFuncExpr.makeAttributeType(attrRef, typeNameStr);
            return this.registerPart(this.lastFunctionExpr);
        }

        @NotNull
        public DynamoAttrRefOpnd makeAttributeRef(@NotNull String name) {
            this.referencedAttributeNames.add(name);
            this.lastAttrRefOpnd = new DynamoAttrRefOpnd(name);
            return this.registerPart(this.lastAttrRefOpnd);
        }

        @NotNull
        public DynamoValueOpnd makeNullValue() {
            return this.makeLiteralValue(DynamoValueOpnd.NULL_VALUE);
        }

        @NotNull
        public DynamoValueOpnd makeLiteralValue(@NotNull AttributeValue value) {
            return this.makeLiteralValue(null, value);
        }

        @NotNull
        public DynamoValueOpnd makeLiteralValue(@NotNull String preferredName, @NotNull AttributeValue value) {
            ++this.valuePartsCount;
            this.lastValueOpnd = new DynamoValueOpnd(preferredName, value);
            return this.registerPart(this.lastValueOpnd);
        }

        @NotNull
        public DynamoSizeFuncOpnd makeSize(@NotNull DynamoAttrRefOpnd attr) {
            return this.registerPart(new DynamoSizeFuncOpnd(attr));
        }
    }

    static class DynamoCondFuncExpr
    extends DynamoCondExpr {
        @NotNull
        private static final Map<String, DynamoCondFunctionKind> funcKindByName = Stream.of(DynamoCondFunctionKind.values()).collect(Collectors.toUnmodifiableMap(k -> k.name.toLowerCase(), k -> k));
        @NotNull
        public final DynamoCondFunctionKind kind;
        @NotNull
        public final List<DynamoCondOpnd> args;

        private DynamoCondFuncExpr(@NotNull DynamoCondFunctionKind kind, @NotNull List<DynamoCondOpnd> args) {
            this.kind = kind;
            this.args = args;
        }

        @Nullable
        public static DynamoCondFunctionKind tryParseName(@NotNull String name) {
            return funcKindByName.get(name.toLowerCase());
        }

        @NotNull
        public static Set<String> getKnownNames() {
            return funcKindByName.keySet();
        }

        @Override
        protected <T, R> R applyImpl(@NotNull DynamoConditionPartsVisitor<T, R> visitor, @NotNull T arg) {
            return visitor.visitFunctionExpr(this, arg);
        }

        @NotNull
        public static DynamoCondFuncExpr makeAttributeExists(@NotNull DynamoAttrRefOpnd attr) {
            return new DynamoCondFuncExpr(DynamoCondFunctionKind.AttributeExists, List.of(attr));
        }

        @NotNull
        public static DynamoCondFuncExpr makeAttributeNotExists(@NotNull DynamoAttrRefOpnd attr) {
            return new DynamoCondFuncExpr(DynamoCondFunctionKind.AttributeNotExists, List.of(attr));
        }

        @NotNull
        public static DynamoCondFuncExpr makeBeginsWith(@NotNull DynamoAttrRefOpnd attr, @NotNull DynamoValueOpnd prefix) {
            return new DynamoCondFuncExpr(DynamoCondFunctionKind.BeginsWith, List.of(attr, prefix));
        }

        @NotNull
        public static DynamoCondFuncExpr makeContains(@NotNull DynamoAttrRefOpnd attr, @NotNull DynamoCondOpnd attrValuePart) {
            return new DynamoCondFuncExpr(DynamoCondFunctionKind.Contains, List.of(attr, attrValuePart));
        }

        @NotNull
        public static DynamoCondFuncExpr makeAttributeType(@NotNull DynamoAttrRefOpnd attrRef, @NotNull DynamoValueOpnd typeNameStr) {
            return new DynamoCondFuncExpr(DynamoCondFunctionKind.AttributeType, List.of(attrRef, typeNameStr));
        }
    }

    static enum DynamoCondFunctionKind {
        AttributeExists("attribute_exists", 1),
        AttributeNotExists("attribute_not_exists", 1),
        AttributeType("attribute_type", 2),
        BeginsWith("begins_with", 2),
        Contains("contains", 2);

        @NotNull
        public final String name;
        public final int paramsCount;

        private DynamoCondFunctionKind(String name, int paramsCount) {
            this.name = name;
            this.paramsCount = paramsCount;
        }
    }

    static abstract class DynamoCondGroupExpr
    extends DynamoCondExpr {
        @NotNull
        public final List<DynamoCondExpr> children;

        protected DynamoCondGroupExpr(@NotNull List<DynamoCondExpr> exprs) {
            this.children = exprs;
        }
    }

    static abstract class DynamoCondOpnd
    extends DynamoCondPart {
        DynamoCondOpnd() {
        }
    }

    static abstract class DynamoCondPart {
        DynamoCondPart() {
        }

        @NotNull
        public <T, R> R apply(@NotNull DynamoConditionPartsVisitor<T, R> visitor, @NotNull T arg) {
            return this.applyImpl(visitor, arg);
        }

        @NotNull
        protected abstract <T, R> R applyImpl(@NotNull DynamoConditionPartsVisitor<T, R> var1, @NotNull T var2);

        @NotNull
        public String toString() {
            return super.getClass().getName() + "[" + String.valueOf(this.apply(new DynamoConditionFormatter(), new StringBuilder())) + "]";
        }
    }

    static class DynamoConditionFormatter
    implements DynamoConditionPartsVisitor<StringBuilder, StringBuilder> {
        @NotNull
        private final Map<String, String> attributeNameParts = new HashMap<String, String>();
        @NotNull
        private final Map<String, AttributeValue> expressionValues = new HashMap<String, AttributeValue>();
        @NotNull
        private final Map<String, String> attributeNamePartKeys = new HashMap<String, String>();

        private DynamoConditionFormatter() {
        }

        @NotNull
        public Map<String, String> getAttributeNamesMap() {
            return this.attributeNameParts;
        }

        @NotNull
        public Map<String, AttributeValue> getExpressionValuesMap() {
            return this.expressionValues;
        }

        @NotNull
        public String format(@NotNull DynamoCondExpr condition) {
            return condition.apply(this, new StringBuilder()).toString();
        }

        @NotNull
        private StringBuilder visit(@NotNull DynamoCondPart parent, @NotNull DynamoCondPart node, @NotNull StringBuilder sb) {
            boolean needsWrapping;
            boolean bl = needsWrapping = parent instanceof DynamoCondGroupExpr && node instanceof DynamoCondGroupExpr && parent.getClass() != node.getClass() || parent instanceof DynamoNotExpr && node instanceof DynamoCondGroupExpr;
            if (needsWrapping) {
                sb.append("(");
            }
            node.apply(this, sb);
            if (needsWrapping) {
                sb.append(")");
            }
            return sb;
        }

        @NotNull
        private StringBuilder visitGroup(@NotNull DynamoCondGroupExpr group, @NotNull StringBuilder sb, @NotNull String separator) {
            Iterator<DynamoCondExpr> it = group.children.iterator();
            if (it.hasNext()) {
                this.visit(group, it.next(), sb);
                while (it.hasNext()) {
                    sb.append(separator);
                    this.visit(group, it.next(), sb);
                }
            }
            return sb;
        }

        @NotNull
        private StringBuilder visitOperandsList(@NotNull DynamoCondPart expr, @NotNull List<DynamoCondOpnd> items, @NotNull StringBuilder arg) {
            arg.append("(");
            Iterator<DynamoCondOpnd> it = items.iterator();
            if (it.hasNext()) {
                this.visit(expr, it.next(), arg);
                while (it.hasNext()) {
                    arg.append(", ");
                    this.visit(expr, it.next(), arg);
                }
            }
            arg.append(")");
            return arg;
        }

        @Override
        @NotNull
        public StringBuilder visitOrExpr(@NotNull DynamoOrExpr orExpr, @NotNull StringBuilder arg) {
            return this.visitGroup(orExpr, arg, " OR ");
        }

        @Override
        @NotNull
        public StringBuilder visitAndExpr(@NotNull DynamoAndExpr andExpr, @NotNull StringBuilder arg) {
            return this.visitGroup(andExpr, arg, " AND ");
        }

        @Override
        @NotNull
        public StringBuilder visitNotExpr(@NotNull DynamoNotExpr notExpr, @NotNull StringBuilder arg) {
            return this.visit(notExpr, notExpr.child, arg.append("NOT "));
        }

        @Override
        @NotNull
        public StringBuilder visitCompareExpr(@NotNull DynamoCompareExpr compareExpr, @NotNull StringBuilder arg) {
            this.visit(compareExpr, compareExpr.left, arg);
            arg.append(" ").append(compareExpr.operator.symbol).append(" ");
            this.visit(compareExpr, compareExpr.right, arg);
            return arg;
        }

        @Override
        @NotNull
        public StringBuilder visitInExpr(@NotNull DynamoInExpr inExpr, @NotNull StringBuilder arg) {
            this.visit(inExpr, inExpr.subj, arg).append(" IN ");
            return this.visitOperandsList(inExpr, inExpr.entries, arg);
        }

        @Override
        @NotNull
        public StringBuilder visitBetweenExpr(@NotNull DynamoBetweenExpr betweenExpr, @NotNull StringBuilder arg) {
            this.visit(betweenExpr, betweenExpr.subj, arg);
            arg.append(" BETWEEN ");
            this.visit(betweenExpr, betweenExpr.from, arg);
            arg.append(" AND ");
            this.visit(betweenExpr, betweenExpr.to, arg);
            return arg;
        }

        @Override
        @NotNull
        public StringBuilder visitFunctionExpr(@NotNull DynamoCondFuncExpr funcExpr, @NotNull StringBuilder arg) {
            arg.append(funcExpr.kind.name);
            return this.visitOperandsList(funcExpr, funcExpr.args, arg);
        }

        @Override
        @NotNull
        public StringBuilder visitAttrRefOperand(@NotNull DynamoAttrRefOpnd attrRefOpnd, @NotNull StringBuilder arg) {
            String[] nameParts = SQLUtils.splitFullIdentifier((String)attrRefOpnd.name, (String)".", (String[][])SQLConstants.DOUBLE_QUOTE_STRINGS, (boolean)false);
            int i = 0;
            while (i < nameParts.length) {
                String namePart = nameParts[i];
                Object namePartKey = this.attributeNamePartKeys.get(namePart);
                if (namePartKey == null) {
                    namePartKey = "#np" + this.attributeNameParts.size() + "_" + CommonUtils.escapeIdentifier((String)namePart);
                    this.attributeNamePartKeys.put(namePart, (String)namePartKey);
                    this.attributeNameParts.put((String)namePartKey, namePart);
                }
                if (i > 0) {
                    arg.append(".");
                }
                arg.append((String)namePartKey);
                ++i;
            }
            return arg;
        }

        @Override
        @NotNull
        public StringBuilder visitLiteralValueOperand(@NotNull DynamoValueOpnd valueOpnd, @NotNull StringBuilder arg) {
            Object refKeyValue;
            if (DynamoValueOpnd.NULL_VALUE.equals((Object)valueOpnd.value)) {
                refKeyValue = ":null";
            } else {
                refKeyValue = ":v" + this.expressionValues.size();
                if (CommonUtils.isNotEmpty((String)valueOpnd.preferredKeyName)) {
                    refKeyValue = (String)refKeyValue + "_" + CommonUtils.escapeIdentifier((String)valueOpnd.preferredKeyName);
                }
                if (this.expressionValues.containsKey(refKeyValue)) {
                    throw new IllegalStateException("Duplicate value key");
                }
            }
            this.expressionValues.put((String)refKeyValue, valueOpnd.value);
            return arg.append((String)refKeyValue);
        }

        @Override
        @NotNull
        public StringBuilder visitSizeFuncOperand(@NotNull DynamoSizeFuncOpnd sizeFunc, @NotNull StringBuilder arg) {
            arg.append("size");
            return this.visitOperandsList(sizeFunc, List.of(sizeFunc.attribute), arg);
        }
    }

    static interface DynamoConditionPartsVisitor<T, R> {
        @NotNull
        public R visitOrExpr(@NotNull DynamoOrExpr var1, @NotNull T var2);

        @NotNull
        public R visitAndExpr(@NotNull DynamoAndExpr var1, @NotNull T var2);

        @NotNull
        public R visitNotExpr(@NotNull DynamoNotExpr var1, @NotNull T var2);

        @NotNull
        public R visitCompareExpr(@NotNull DynamoCompareExpr var1, @NotNull T var2);

        @NotNull
        public R visitInExpr(@NotNull DynamoInExpr var1, @NotNull T var2);

        @NotNull
        public R visitBetweenExpr(@NotNull DynamoBetweenExpr var1, @NotNull T var2);

        @NotNull
        public R visitFunctionExpr(@NotNull DynamoCondFuncExpr var1, @NotNull T var2);

        @NotNull
        public R visitAttrRefOperand(@NotNull DynamoAttrRefOpnd var1, @NotNull T var2);

        @NotNull
        public R visitLiteralValueOperand(@NotNull DynamoValueOpnd var1, @NotNull T var2);

        @NotNull
        public R visitSizeFuncOperand(@NotNull DynamoSizeFuncOpnd var1, @NotNull T var2);
    }

    static class DynamoInExpr
    extends DynamoCondExpr {
        @NotNull
        public final DynamoCondOpnd subj;
        @NotNull
        public final List<DynamoCondOpnd> entries;

        public DynamoInExpr(@NotNull DynamoCondOpnd subj, @NotNull List<DynamoCondOpnd> entries) {
            this.subj = subj;
            this.entries = entries;
        }

        @Override
        @NotNull
        protected <T, R> R applyImpl(@NotNull DynamoConditionPartsVisitor<T, R> visitor, @NotNull T arg) {
            return visitor.visitInExpr(this, arg);
        }
    }

    static class DynamoNotExpr
    extends DynamoCondExpr {
        @NotNull
        public final DynamoCondExpr child;

        public DynamoNotExpr(@NotNull DynamoCondExpr child) {
            this.child = child;
        }

        @Override
        @NotNull
        protected <T, R> R applyImpl(@NotNull DynamoConditionPartsVisitor<T, R> visitor, @NotNull T arg) {
            return visitor.visitNotExpr(this, arg);
        }
    }

    static class DynamoOrExpr
    extends DynamoCondGroupExpr {
        protected DynamoOrExpr(@NotNull List<DynamoCondExpr> exprs) {
            super(exprs);
        }

        @Override
        @NotNull
        protected <T, R> R applyImpl(@NotNull DynamoConditionPartsVisitor<T, R> visitor, @NotNull T arg) {
            return visitor.visitOrExpr(this, arg);
        }
    }

    static class DynamoSQLExpressionAnalyzer {
        @NotNull
        private static final Map<Class<?>, DynamoCompareOperator> compareOperatorByExprClass = ImmutableMap.builder().put(EqualsTo.class, (Object)DynamoCompareOperator.Equal).put(NotEqualsTo.class, (Object)DynamoCompareOperator.NotEqual).put(GreaterThan.class, (Object)DynamoCompareOperator.Greater).put(GreaterThanEquals.class, (Object)DynamoCompareOperator.GreaterOrEqual).put(MinorThan.class, (Object)DynamoCompareOperator.Less).put(MinorThanEquals.class, (Object)DynamoCompareOperator.LessOrEqual).build();
        @NotNull
        private final Map<String, DynamoTableAttribute> tableAttrByName = new HashMap<String, DynamoTableAttribute>();
        @NotNull
        private final Set<String> tableAllKeyAttrNames = new HashSet<String>();
        @NotNull
        private final Set<String> tablePartitionKeyNames = new HashSet<String>();
        @NotNull
        private final Map<String, DynamoCondExpr> keyConditions = new HashMap<String, DynamoCondExpr>();
        @NotNull
        private final Map<String, AttributeValue> itemKeyValues = new HashMap<String, AttributeValue>();
        @NotNull
        private final List<DynamoCondExpr> otherConditions = new ArrayList<DynamoCondExpr>();
        private boolean badKeyConditionsPresented = false;
        private boolean excessiveKeyValuesPresented = false;

        public DynamoSQLExpressionAnalyzer(@NotNull DynamoTable table) throws DBCException {
            for (DynamoTableAttribute attr : table.getAttributes((DBRProgressMonitor)new VoidProgressMonitor())) {
                this.tableAttrByName.put(attr.getName(), attr);
                if (attr.getKeyType() != null) {
                    this.tableAllKeyAttrNames.add(attr.getName());
                }
                if (attr.getKeyType() != DynamoKeyType.PARTITION) continue;
                this.tablePartitionKeyNames.add(attr.getName());
            }
        }

        public boolean hasComposableKeyCondition() {
            return !this.badKeyConditionsPresented && this.keyConditions.size() > 0 && this.itemKeyValues.keySet().containsAll(this.tablePartitionKeyNames);
        }

        public boolean hasCompleteItemKey() {
            return this.itemKeyValues.keySet().containsAll(this.tableAllKeyAttrNames);
        }

        public boolean hasExcessiveMutationKeyValues() {
            return this.excessiveKeyValuesPresented;
        }

        public boolean hasExcessiveMutationKeyConditions() {
            return this.keyConditions.size() > this.itemKeyValues.size();
        }

        public void analyze(@NotNull Expression expr) throws DBCException {
            this.traverseTopLevelConjunction(expr);
        }

        @NotNull
        public DynamoCondExpr combineKeyConditions() {
            return new DynamoAndExpr(List.copyOf(this.keyConditions.values()));
        }

        @NotNull
        public DynamoCondExpr combineOtherConditions() {
            return new DynamoAndExpr(this.otherConditions);
        }

        @NotNull
        public DynamoCondExpr combineAllConditions() {
            ArrayList<DynamoCondExpr> exprs = new ArrayList<DynamoCondExpr>(this.keyConditions.size() + this.otherConditions.size());
            exprs.addAll(this.keyConditions.values());
            exprs.addAll(this.otherConditions);
            return new DynamoAndExpr(exprs);
        }

        @NotNull
        public Map<String, AttributeValue> getItemKeyValues() {
            return this.itemKeyValues;
        }

        private void traverseTopLevelConjunction(@NotNull Expression expr) throws DBCException {
            ParenthesedExpressionList parenthesis;
            if (expr instanceof AndExpression) {
                this.traverseTopLevelConjunction(((AndExpression)expr).getLeftExpression());
                this.traverseTopLevelConjunction(((AndExpression)expr).getRightExpression());
            } else if (expr instanceof ParenthesedExpressionList && (parenthesis = (ParenthesedExpressionList)expr).size() == 1) {
                this.traverseTopLevelConjunction((Expression)parenthesis.get(0));
            } else {
                DynamoCondExprBuilder condBuilder = new DynamoCondExprBuilder();
                DynamoCondExpr condExpr = this.translateExpression(condBuilder, expr);
                if (!this.tryRegisterKeyCondition(condBuilder, condExpr)) {
                    Set<String> attrNames = condBuilder.getReferencedAttributeNames();
                    attrNames.retainAll(this.tableAllKeyAttrNames);
                    if (!attrNames.isEmpty()) {
                        this.badKeyConditionsPresented = true;
                    }
                    this.otherConditions.add(condExpr);
                }
            }
        }

        private boolean tryRegisterKeyCondition(@NotNull DynamoCondExprBuilder condBuilder, @NotNull DynamoCondExpr condExpr) {
            boolean isValidSortKeyTest;
            boolean isComparison = condBuilder.seemsAttributeComparisonWasBuild();
            boolean isRangeCheck = condBuilder.seemsAttributeRangeCheckWasBuild();
            boolean isPrefixCheck = condBuilder.seemsAttributePrefixCheckWasBuild();
            if (!(isComparison || isRangeCheck || isPrefixCheck)) {
                return false;
            }
            DynamoAttrRefOpnd attrRef = condBuilder.getLastAttrRefOpnd();
            DynamoTableAttribute attrInfo = this.tableAttrByName.get(attrRef.name);
            if (attrInfo == null) {
                return false;
            }
            String attrName = attrInfo.getName();
            boolean isEquilityComparison = isComparison && condBuilder.getLastCompareExpr().operator == DynamoCompareOperator.Equal;
            boolean isKeyTest = attrInfo.getKeyType() != null;
            boolean isValidPartitionKeyTest = attrInfo.getKeyType() == DynamoKeyType.PARTITION && isEquilityComparison;
            boolean bl = isValidSortKeyTest = attrInfo.getKeyType() == DynamoKeyType.SORT && (isPrefixCheck || isRangeCheck || isComparison && condBuilder.getLastCompareExpr().operator != DynamoCompareOperator.NotEqual);
            if (isKeyTest && isEquilityComparison) {
                if (this.itemKeyValues.containsKey(attrName)) {
                    this.excessiveKeyValuesPresented = true;
                } else {
                    this.itemKeyValues.put(attrName, condBuilder.getLastValueOpnd().value);
                }
            }
            if (isValidPartitionKeyTest || isValidSortKeyTest) {
                DynamoCondExpr existingCond = this.keyConditions.get(attrName);
                if (existingCond == null) {
                    this.keyConditions.put(attrName, condExpr);
                    return true;
                }
                if (isValidSortKeyTest && isComparison && existingCond instanceof DynamoCompareExpr) {
                    DynamoBetweenExpr newExpr = this.tryInferRangeCheck(condBuilder, attrRef, (DynamoCompareExpr)existingCond, condBuilder.getLastCompareExpr());
                    if (newExpr != null) {
                        this.keyConditions.put(attrName, newExpr);
                        return true;
                    }
                    this.badKeyConditionsPresented = true;
                } else {
                    this.badKeyConditionsPresented = true;
                }
            } else if (isKeyTest) {
                this.badKeyConditionsPresented = true;
            }
            return false;
        }

        @NotNull
        private DynamoBetweenExpr tryInferRangeCheck(@NotNull DynamoCondExprBuilder condBuilder, @NotNull DynamoAttrRefOpnd subject, @NotNull DynamoCompareExpr a, @NotNull DynamoCompareExpr b) {
            boolean fromY;
            CompareExprInfo x = this.tryAnalyzeRangeCheckPart(a);
            CompareExprInfo y = this.tryAnalyzeRangeCheckPart(b);
            if (x == null || y == null || x.isFrom == y.isFrom) {
                return null;
            }
            boolean fromX = x.isFrom && x.rawValue < y.rawValue;
            boolean bl = fromY = y.isFrom && y.rawValue < x.rawValue;
            if (fromX == fromY) {
                return null;
            }
            String preferredValueKeyName = this.tryMakePreferredValueKeyName(condBuilder, subject, "keyBetween");
            return condBuilder.makeBetween(subject, condBuilder.makeLiteralValue(preferredValueKeyName + "_from", fromX ? x.value : y.value), condBuilder.makeLiteralValue(preferredValueKeyName + "_to", fromX ? y.value : x.value));
        }

        @NotNull
        private CompareExprInfo tryAnalyzeRangeCheckPart(@NotNull DynamoCompareExpr expr) {
            boolean valueOnTheRight = expr.right instanceof DynamoValueOpnd;
            DynamoValueOpnd valueExpr = (DynamoValueOpnd)(valueOnTheRight ? expr.right : expr.left);
            if (CommonUtils.isEmpty((String)valueExpr.value.n()) || expr.operator.isStrictComparison) {
                return null;
            }
            boolean isFrom = valueOnTheRight && expr.operator == DynamoCompareOperator.GreaterOrEqual || !valueOnTheRight && expr.operator == DynamoCompareOperator.LessOrEqual;
            try {
                double rawValue = Double.parseDouble(valueExpr.value.n());
                return new CompareExprInfo(valueExpr.value, rawValue, isFrom);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        @NotNull
        private DynamoCondExpr translateExpression(@NotNull DynamoCondExprBuilder condBuilder, @NotNull Expression expr) throws DBCException {
            ParenthesedExpressionList parenthesis;
            DynamoCondExpr result;
            if (expr instanceof AndExpression) {
                result = condBuilder.makeAnd(List.of(this.translateExpression(condBuilder, ((AndExpression)expr).getLeftExpression()), this.translateExpression(condBuilder, ((AndExpression)expr).getRightExpression())));
            } else if (expr instanceof OrExpression) {
                result = condBuilder.makeOr(List.of(this.translateExpression(condBuilder, ((OrExpression)expr).getLeftExpression()), this.translateExpression(condBuilder, ((OrExpression)expr).getRightExpression())));
            } else if (expr instanceof NotExpression) {
                result = condBuilder.makeNot(this.translateExpression(condBuilder, ((NotExpression)expr).getExpression()));
            } else if (expr instanceof InExpression) {
                result = this.translateInTestExpr(condBuilder, (InExpression)expr);
            } else if (expr instanceof LikeExpression) {
                result = this.translateLikeExpr(condBuilder, (LikeExpression)expr);
            } else if (expr instanceof BinaryExpression) {
                result = this.translateBinaryExpr(condBuilder, (BinaryExpression)expr);
            } else if (expr instanceof Between) {
                result = this.translateBetweenExpr(condBuilder, (Between)expr);
            } else if (expr instanceof ParenthesedExpressionList && (parenthesis = (ParenthesedExpressionList)expr).size() == 1) {
                result = this.translateExpression(condBuilder, (Expression)parenthesis.get(0));
            } else if (expr instanceof IsNullExpression) {
                result = this.translateNullTestExpr(condBuilder, (IsNullExpression)expr);
            } else if (expr instanceof Function) {
                result = this.translateFunctionExpr(condBuilder, (Function)expr);
            } else {
                throw new DBCException("Unsupported expression: " + String.valueOf(expr));
            }
            return result;
        }

        @NotNull
        private DynamoCondExpr translateLikeExpr(@NotNull DynamoCondExprBuilder condBuilder, @NotNull LikeExpression expr) throws DBCException {
            DynamoCondExpr result;
            DynamoAttrRefOpnd subject = this.translateAttrRef(condBuilder, expr.getLeftExpression());
            Expression paramExpr = expr.getRightExpression();
            if (!(paramExpr instanceof StringValue) || !"LIKE".equals(expr.getStringExpression()) || expr.isCaseInsensitive() || expr.getEscape() != null) {
                throw new DBCException("Unsupported kind of pattern matching expression, only leading and trailing wildcards with exact pattern are supported: " + String.valueOf(expr));
            }
            String pattern = ((StringValue)paramExpr).getValue();
            int head = 0;
            while (head < pattern.length() && pattern.charAt(head) == '%') {
                ++head;
            }
            int tail = pattern.length();
            while (tail > 0 && pattern.charAt(tail - 1) == '%') {
                --tail;
            }
            if (head >= tail) {
                result = condBuilder.makeContains(subject, this.makeStringValueOperand(condBuilder, subject, "like", ""));
            } else {
                String patternBody = pattern.substring(head, tail);
                if (patternBody.contains("%") || patternBody.contains("_")) {
                    throw new DBCException("Wildcard characters in the middle of the LIKE pattern are not supported: " + String.valueOf(expr));
                }
                if (head == 0 && tail == pattern.length()) {
                    result = condBuilder.makeCompare(DynamoCompareOperator.Equal, subject, this.makeStringValueOperand(condBuilder, subject, "like", pattern));
                } else if (head == 0 && tail < pattern.length()) {
                    result = condBuilder.makeBeginsWith(subject, this.makeStringValueOperand(condBuilder, subject, "like", patternBody));
                } else if (head > 0 && tail < pattern.length()) {
                    result = condBuilder.makeContains(subject, this.makeStringValueOperand(condBuilder, subject, "like", patternBody));
                } else {
                    throw new DBCException("Single wildcard character in the begginning of the LIKE pattern is not supported: " + String.valueOf(expr));
                }
            }
            if (expr.isNot()) {
                result = condBuilder.makeNot(result);
            }
            return result;
        }

        @NotNull
        private DynamoCondExpr translateFunctionExpr(@NotNull DynamoCondExprBuilder condBuilder, @NotNull Function expr) throws DBCException {
            DynamoCondFunctionKind kind = DynamoCondFuncExpr.tryParseName(expr.getName());
            if (kind == null) {
                throw new DBCException("Unsupported function name: " + String.valueOf(expr));
            }
            ExpressionList paramsList = expr.getParameters();
            if (paramsList == null || paramsList.getExpressions().size() != kind.paramsCount) {
                throw new DBCException("Unsupported function parameters list while " + kind.paramsCount + " simple parameters expected: " + String.valueOf(expr));
            }
            List paramsExprs = paramsList.getExpressions();
            DynamoAttrRefOpnd attrRef = this.translateAttrRef(condBuilder, (Expression)paramsExprs.get(0));
            switch (kind) {
                case AttributeExists: {
                    return condBuilder.makeAttributeExists(attrRef);
                }
                case AttributeNotExists: {
                    return condBuilder.makeAttributeNotExists(attrRef);
                }
                case Contains: {
                    return condBuilder.makeContains(attrRef, this.translateOperand(condBuilder, (Expression)paramsExprs.get(1), this.tryMakePreferredValueKeyName(condBuilder, attrRef, "contains")));
                }
                case BeginsWith: {
                    DynamoCondOpnd param = this.translateOperand(condBuilder, (Expression)paramsExprs.get(1), this.tryMakePreferredValueKeyName(condBuilder, attrRef, "beginsWith"));
                    if (!(param instanceof DynamoValueOpnd)) {
                        throw new DBCException("Expected fixed string value as the second parameter: " + String.valueOf(expr));
                    }
                    return condBuilder.makeBeginsWith(attrRef, (DynamoValueOpnd)param);
                }
                case AttributeType: {
                    Expression paramExpr = (Expression)paramsExprs.get(1);
                    if (!(paramExpr instanceof StringValue) || !DynamoValueOpnd.KNOWN_TYPE_SIGNATURES.contains(((StringValue)paramExpr).getValue())) {
                        throw new DBCException("Expected type signature string (" + String.join((CharSequence)", ", DynamoValueOpnd.KNOWN_TYPE_SIGNATURES) + ") as the second parameter: " + String.valueOf(expr));
                    }
                    return condBuilder.makeAttributeType(attrRef, this.makeStringValueOperand(condBuilder, attrRef, "type", ((StringValue)paramExpr).getValue()));
                }
            }
            throw new DBCException("Unsupported function expression while expecting one of [" + String.join((CharSequence)", ", DynamoCondFuncExpr.getKnownNames()) + "]: " + String.valueOf(expr));
        }

        @NotNull
        private DynamoValueOpnd makeStringValueOperand(@NotNull DynamoCondExprBuilder condBuilder, @NotNull DynamoAttrRefOpnd attrRef, @NotNull String context, @NotNull String value) {
            return condBuilder.makeLiteralValue(this.tryMakePreferredValueKeyName(condBuilder, attrRef, context), (AttributeValue)AttributeValue.builder().s(value).build());
        }

        @NotNull
        private String tryMakePreferredValueKeyName(@NotNull DynamoCondExprBuilder condBuilder, @NotNull DynamoCondOpnd subject, @NotNull String contextKind) {
            return subject instanceof DynamoAttrRefOpnd ? ((DynamoAttrRefOpnd)subject).name + "_" + contextKind + condBuilder.nextExprId() : null;
        }

        @NotNull
        private DynamoCondExpr translateBetweenExpr(@NotNull DynamoCondExprBuilder condBuilder, @NotNull Between expr) throws DBCException {
            DynamoCondOpnd subject = this.translateOperand(condBuilder, expr.getLeftExpression(), null);
            String preferredValueKeyName = this.tryMakePreferredValueKeyName(condBuilder, subject, "between");
            DynamoCondExpr result = condBuilder.makeBetween(subject, this.translateOperand(condBuilder, expr.getBetweenExpressionStart(), preferredValueKeyName + "_from"), this.translateOperand(condBuilder, expr.getBetweenExpressionEnd(), preferredValueKeyName + "_to"));
            if (expr.isNot()) {
                result = condBuilder.makeNot(result);
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        private DynamoCondExpr translateInTestExpr(@NotNull DynamoCondExprBuilder condBuilder, @NotNull InExpression expr) throws DBCException {
            void subexprs;
            Expression itemsList = expr.getRightExpression();
            if (!(itemsList instanceof ExpressionList)) {
                throw new DBCException("Unsupported item list of IN expression while expecting explicit operands list: " + String.valueOf(itemsList));
            }
            ExpressionList expressionList = (ExpressionList)itemsList;
            DynamoCondOpnd subject = this.translateOperand(condBuilder, expr.getLeftExpression(), null);
            String preferredValueKeyName = this.tryMakePreferredValueKeyName(condBuilder, subject, "in");
            ArrayList<DynamoCondOpnd> values = new ArrayList<DynamoCondOpnd>();
            int i = 0;
            while (i < subexprs.size()) {
                values.add(this.translateOperand(condBuilder, (Expression)subexprs.get(i), preferredValueKeyName + "_" + i));
                ++i;
            }
            DynamoCondExpr result = condBuilder.makeIn(subject, values);
            if (expr.isNot()) {
                result = condBuilder.makeNot(result);
            }
            return result;
        }

        @NotNull
        private DynamoCondExpr translateBinaryExpr(@NotNull DynamoCondExprBuilder condBuilder, @NotNull BinaryExpression expr) throws DBCException {
            DynamoCompareOperator op = compareOperatorByExprClass.get(expr.getClass());
            if (op == null) {
                throw new DBCException("Unsupported binary expression: " + String.valueOf(expr));
            }
            return condBuilder.makeCompare(op, this.translateOperand(condBuilder, expr.getLeftExpression(), null), this.translateOperand(condBuilder, expr.getRightExpression(), null));
        }

        @NotNull
        private DynamoCondExpr translateNullTestExpr(@NotNull DynamoCondExprBuilder condBuilder, @NotNull IsNullExpression nullTest) throws DBCException {
            DynamoAttrRefOpnd subj = this.translateAttrRef(condBuilder, nullTest.getLeftExpression());
            if (nullTest.isNot()) {
                return condBuilder.makeAnd(List.of(condBuilder.makeAttributeExists(subj), condBuilder.makeCompare(DynamoCompareOperator.NotEqual, subj, condBuilder.makeNullValue())));
            }
            return condBuilder.makeOr(List.of(condBuilder.makeAttributeNotExists(subj), condBuilder.makeCompare(DynamoCompareOperator.Equal, subj, condBuilder.makeNullValue())));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        private DynamoCondOpnd translateOperand(@NotNull DynamoCondExprBuilder condBuilder, @NotNull Expression expr, @NotNull String preferredKeyName) throws DBCException {
            AttributeValue.Builder builder = AttributeValue.builder();
            if (expr instanceof StringValue) {
                builder.s(((StringValue)expr).getValue());
                return condBuilder.makeLiteralValue(preferredKeyName, (AttributeValue)builder.build());
            } else if (expr instanceof LongValue) {
                builder.n(((LongValue)expr).getStringValue());
                return condBuilder.makeLiteralValue(preferredKeyName, (AttributeValue)builder.build());
            } else if (expr instanceof DoubleValue) {
                builder.n(((Object)((DoubleValue)expr).getValue()).toString());
                return condBuilder.makeLiteralValue(preferredKeyName, (AttributeValue)builder.build());
            } else if (expr instanceof Column) {
                String literal = DynamoSQL.unquote(((Column)expr).getFullyQualifiedName());
                if (!literal.equals("true") && !literal.equals("false")) return condBuilder.makeAttributeRef(literal);
                builder.bool(Boolean.valueOf(literal));
                return condBuilder.makeLiteralValue(preferredKeyName, (AttributeValue)builder.build());
            } else if (expr instanceof NullValue) {
                builder.nul(Boolean.valueOf(true));
                return condBuilder.makeLiteralValue(preferredKeyName, (AttributeValue)builder.build());
            } else {
                if (!(expr instanceof Function)) throw new DBCException("Unsupported operand while expecting literal value or attribute reference: " + String.valueOf(expr));
                Function function = (Function)expr;
                if (!((Function)expr).getName().toLowerCase().equals("size")) throw new DBCException("Unsupported operand while expecting literal value or attribute reference: " + String.valueOf(expr));
                ExpressionList exprs = function.getParameters();
                if (exprs.size() == 1) return new DynamoSizeFuncOpnd(this.translateAttrRef(condBuilder, (Expression)exprs.get(0)));
                throw new DBCException("Unexpected number of parameters for a function: " + String.valueOf(expr));
            }
        }

        @NotNull
        private DynamoAttrRefOpnd translateAttrRef(@NotNull DynamoCondExprBuilder condBuilder, @NotNull Expression expr) throws DBCException {
            if (expr instanceof Column) {
                String attrName = DynamoSQL.unquote(((Column)expr).getFullyQualifiedName());
                return condBuilder.makeAttributeRef(attrName);
            }
            throw new DBCException("Unsupported expression while expecting attribute reference: " + String.valueOf(expr));
        }

        private static class CompareExprInfo {
            @NotNull
            public final AttributeValue value;
            @NotNull
            public final Double rawValue;
            public final boolean isFrom;

            public CompareExprInfo(@NotNull AttributeValue value, @NotNull Double rawValue, boolean isFrom) {
                this.value = value;
                this.rawValue = rawValue;
                this.isFrom = isFrom;
            }
        }
    }

    static class DynamoSizeFuncOpnd
    extends DynamoCondOpnd {
        @NotNull
        public final DynamoAttrRefOpnd attribute;

        public DynamoSizeFuncOpnd(@NotNull DynamoAttrRefOpnd attribute) {
            this.attribute = attribute;
        }

        @Override
        @NotNull
        protected <T, R> R applyImpl(@NotNull DynamoConditionPartsVisitor<T, R> visitor, @NotNull T arg) {
            return visitor.visitSizeFuncOperand(this, arg);
        }
    }

    static class DynamoValueOpnd
    extends DynamoCondOpnd {
        @NotNull
        public static final AttributeValue NULL_VALUE = (AttributeValue)AttributeValue.builder().nul(Boolean.valueOf(true)).build();
        @NotNull
        public static final Set<String> KNOWN_TYPE_SIGNATURES = Set.of("S", "SS", "N", "NS", "B", "BS", "BOOL", "NULL", "L", "M");
        @NotNull
        public final String preferredKeyName;
        @NotNull
        public final AttributeValue value;

        public DynamoValueOpnd(@NotNull String preferredKeyName, @NotNull AttributeValue value) {
            this.preferredKeyName = preferredKeyName;
            this.value = value;
        }

        @Override
        @NotNull
        protected <T, R> R applyImpl(@NotNull DynamoConditionPartsVisitor<T, R> visitor, @NotNull T arg) {
            return visitor.visitLiteralValueOperand(this, arg);
        }
    }

    public static class RequestConditionsInfo {
        @NotNull
        private final String keyExpression;
        @NotNull
        private final String filterExpression;
        @NotNull
        private final Map<String, String> exprAttrNames;
        @NotNull
        private final Map<String, AttributeValue> exprAttrValues;
        @NotNull
        private final Map<String, AttributeValue> keyValues;

        protected RequestConditionsInfo(@NotNull String keyExpression, @NotNull String filterExpression, @NotNull Map<String, String> exprAttrNames, @NotNull Map<String, AttributeValue> exprAttrValues, @NotNull Map<String, AttributeValue> keyValues) {
            this.keyExpression = keyExpression;
            this.filterExpression = filterExpression;
            this.exprAttrNames = exprAttrNames;
            this.exprAttrValues = exprAttrValues;
            this.keyValues = keyValues;
        }

        @NotNull
        public String getKeyExpression() {
            return this.keyExpression;
        }

        @NotNull
        public String getFilterExpression() {
            return this.filterExpression;
        }

        @NotNull
        public Map<String, String> getExprAttrNames() {
            return this.exprAttrNames;
        }

        @NotNull
        public Map<String, AttributeValue> getExprAttrValues() {
            return this.exprAttrValues;
        }

        @NotNull
        public Map<String, AttributeValue> getKeyValues() {
            return this.keyValues;
        }
    }
}

