/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.model;

import com.dbeaver.db.dynamodb.exec.DynamoExecutionContext;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.struct.DirectObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class DynamoStructureAssistant
implements DBSStructureAssistant<DynamoExecutionContext> {
    private final DynamoDataSource dataSource;

    public DynamoStructureAssistant(DynamoDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @NotNull
    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE};
    }

    @NotNull
    public DBSObjectType[] getSearchObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    @NotNull
    public DBSObjectType[] getHyperlinkObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    @NotNull
    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(@NotNull DBRProgressMonitor monitor, @NotNull DynamoExecutionContext executionContext, @NotNull DBSStructureAssistant.ObjectsSearchParams params) throws DBException {
        ArrayList<DBSObjectReference> references = new ArrayList<DBSObjectReference>();
        Throwable throwable = null;
        Object var6_7 = null;
        try (DynamoSession session = (DynamoSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)(params.getParentObject() != null ? params.getParentObject() : this.dataSource), (String)"Find DynamoDB objects");){
            this.findCollections(session, params, references);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return references;
    }

    private void findCollections(DynamoSession session, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws DBException {
        String likePattern = SQLUtils.makeLikePattern((String)params.getMask());
        Pattern pattern = Pattern.compile(likePattern, (params.isCaseSensitive() ? 0 : 2) | 8);
        DynamoDataSource dataSource = session.getDataSource();
        for (DynamoTable table : dataSource.getTables(session.getProgressMonitor())) {
            if (!pattern.matcher(table.getName()).matches()) continue;
            objects.add((DBSObjectReference)new DirectObjectReference((DBSObject)dataSource, RelationalObjectType.TYPE_TABLE, (DBSObject)table));
        }
    }
}

