/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.model;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPNamedObject;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;

public enum DynamoValueType implements DBPNamedObject
{
    STRING("String", ScalarAttributeType.S),
    NUMBER("Number", ScalarAttributeType.N),
    BINARY("Binary", ScalarAttributeType.B),
    UNKNOWN("Unknown", ScalarAttributeType.UNKNOWN_TO_SDK_VERSION);

    private final String name;
    private final ScalarAttributeType type;

    private DynamoValueType(String name, ScalarAttributeType type) {
        this.name = name;
        this.type = type;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public ScalarAttributeType getType() {
        return this.type;
    }

    @NotNull
    public DBPDataKind getKind() {
        switch (this) {
            case STRING: {
                return DBPDataKind.STRING;
            }
            case NUMBER: {
                return DBPDataKind.NUMERIC;
            }
            case BINARY: {
                return DBPDataKind.BINARY;
            }
        }
        return DBPDataKind.OBJECT;
    }

    @NotNull
    public static DynamoValueType from(@NotNull ScalarAttributeType type) {
        switch (type) {
            case S: {
                return STRING;
            }
            case N: {
                return NUMBER;
            }
            case B: {
                return BINARY;
            }
        }
        return UNKNOWN;
    }
}

