/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.files.ui.views;

import com.dbeaver.db.files.ui.views.FilePathInfoProvider;
import com.dbeaver.db.files.ui.views.FilePathSelector;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class FlatFilesConnectionPage
extends ConnectionPageAbstract
implements IDialogPageProvider,
FilePathInfoProvider {
    private static final boolean SHOW_FILE_TYPE_ICONS = false;
    private Text urlText;
    private Table filesTable;
    private CustomTableEditor filesTableEditor;
    private FilePathSelector pathSelector;
    private FilePathSelector addPathSelector;
    private Button removeButton;
    private Control descriptionLabel;
    private final DriverPropertiesDialogPage driverPropsPage = new DriverPropertiesDialogPage((ConnectionPageAbstract)this);

    public void dispose() {
        super.dispose();
    }

    protected boolean isHideNonApplicableControls() {
        return true;
    }

    public void createControl(Composite composite) {
        Composite settingsGroup = new Composite(composite, 0);
        settingsGroup.setLayout((Layout)new GridLayout(1, false));
        settingsGroup.setLayoutData((Object)new GridData(1808));
        ModifyListener cfr_ignored_0 = e -> {
            this.saveSettings(this.site.getActiveDataSource());
            this.updateUrlFromSettings(this.urlText);
            this.site.updateButtons();
        };
        Group addrGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)"Parameters", (int)4, (int)0, (int)0);
        addrGroup.setLayoutData((Object)new GridData(1808));
        this.createConnectionModeSwitcher((Composite)addrGroup, SelectionListener.widgetSelectedAdapter(e -> {
            this.setupConnectionModeSelection(this.typeURLRadio.getSelection(), GROUP_URL_ARR, GROUP_CONNECTION_ARR);
            this.updateUrlFromSettings(this.urlText);
        }));
        if (this.typeManualRadio != null) {
            this.typeManualRadio.setText("Path");
        }
        Label urlLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)UIConnectionMessages.dialog_connection_url_label);
        this.urlText = new Text((Composite)addrGroup, 2048);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        gd.widthHint = 355;
        this.urlText.setLayoutData((Object)gd);
        this.urlText.addModifyListener(e -> this.site.updateButtons());
        this.addControlToGroup("url", new Control[]{urlLabel, this.urlText});
        Label filePathsLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)"File paths");
        filePathsLabel.setLayoutData((Object)new GridData(2));
        this.createFilesTable((Composite)addrGroup);
        Composite buttonsPanel = UIUtils.createComposite((Composite)addrGroup, (int)1);
        GridData gd2 = new GridData(2);
        gd2.horizontalSpan = 2;
        buttonsPanel.setLayoutData((Object)gd2);
        this.pathSelector = new FilePathSelector(buttonsPanel, this);
        this.pathSelector.setLayoutData(new GridData(768));
        this.addPathSelector = new FilePathSelector(buttonsPanel, new LocalPathInfoProvider(this){

            @Override
            public void setFilePath(@NotNull String filePath) {
                this.updatePathList(filePath, true);
            }
        }, "Add", (DBPImage)UIIcon.ADD);
        this.addPathSelector.setLayoutData(new GridData(768));
        this.removeButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Remove", (String)"Remove path", (DBPImage)UIIcon.REMOVE, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.removeSelectedPath()));
        this.removeButton.setEnabled(false);
        this.filesTable.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> this.updateButtonsState()));
        this.addControlToGroup("connection", new Control[]{filePathsLabel, this.filesTable, buttonsPanel});
        this.descriptionLabel = UIUtils.createInfoLabel((Composite)settingsGroup, (String)"");
        this.updateUrlFromSettings(this.urlText);
        this.createDriverPanel(settingsGroup);
        this.setControl((Control)settingsGroup);
        this.updateButtonsState();
    }

    private void createFilesTable(Composite parent) {
        this.filesTable = new Table(parent, 67586);
        this.filesTable.setHeaderVisible(false);
        TableColumn column = new TableColumn(this.filesTable, 16384);
        column.setText("Path");
        this.filesTableEditor = new CustomTableEditor(this.filesTable){

            protected Control createEditor(Table table, int index, TableItem item) {
                Text text = new Text((Composite)table, 2048);
                String textValue = item.getText();
                text.setText(textValue);
                text.addModifyListener(e -> {
                    item.setText(0, text.getText());
                    FlatFilesConnectionPage.this.updateButtonsState();
                });
                text.setSelection(0, textValue.length());
                return text;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
            }

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    FlatFilesConnectionPage.this.pathSelector.setFocus();
                }
                super.keyTraversed(e);
            }
        };
        this.filesTable.addFocusListener(FocusListener.focusGainedAdapter(focusEvent -> {
            TableItem[] selection = this.filesTable.getSelection();
            if (selection.length == 0) {
                this.filesTable.setSelection(0);
                selection = this.filesTable.getSelection();
            }
            this.filesTableEditor.showEditor(selection[0]);
        }));
        GridData gd = new GridData(1808);
        gd.widthHint = 20 * UIUtils.getFontHeight((Control)this.filesTable);
        gd.heightHint = 10 * UIUtils.getFontHeight((Control)this.filesTable);
        this.filesTable.setLayoutData((Object)gd);
    }

    public void activateEditor() {
        UIUtils.packColumns((Table)this.filesTable, (boolean)true);
    }

    private void removeSelectedPath() {
        TableItem firstItem = this.filesTable.getItem(0);
        TableItem[] selection = this.filesTable.getSelection();
        if (selection.length == 0) {
            return;
        }
        int lastItemIndex = this.filesTable.indexOf(selection[selection.length - 1]);
        TableItem[] tableItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (!item.equals(firstItem)) {
                item.dispose();
                --lastItemIndex;
            }
            ++n2;
        }
        if (lastItemIndex < this.filesTable.getItemCount() - 1) {
            ++lastItemIndex;
        }
        if (lastItemIndex < this.filesTable.getItemCount()) {
            this.filesTable.setSelection(lastItemIndex);
        } else {
            this.filesTable.setSelection(firstItem);
        }
        this.updateButtonsState();
        this.filesTable.setFocus();
    }

    private void updateButtonsState() {
        this.removeButton.setEnabled(this.filesTable.getSelectionIndex() > 0);
        this.getSite().updateButtons();
    }

    private TableItem createFilesItem(String text, DBPImage icon) {
        DBPImage fileIcon = icon;
        TableItem item = new TableItem(this.filesTable, 0);
        item.setText(0, text);
        if (fileIcon != null) {
            item.setImage(DBeaverIcons.getImage((DBPImage)fileIcon));
        }
        return item;
    }

    private TableItem createOrUpdateFilesItem(String path) {
        TableItem[] tableItemArray = this.filesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getText(0).equals(path)) {
                return item;
            }
            ++n2;
        }
        return this.createFilesItem(path, null);
    }

    public boolean isComplete() {
        if (this.typeManualRadio == null) {
            return false;
        }
        return this.typeManualRadio.getSelection() ? !CommonUtils.isEmpty((String)this.getFilePath()) : this.urlText != null && !CommonUtils.isEmpty((String)this.urlText.getText());
    }

    public void loadSettings() {
        String[] pathList;
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        boolean useURL = connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL;
        this.setupConnectionModeSelection(useURL, GROUP_URL_ARR, GROUP_CONNECTION_ARR);
        this.updateUrlFromSettings(this.urlText);
        this.filesTable.removeAll();
        String[] stringArray = pathList = CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()).split(";");
        int n = pathList.length;
        int n2 = 0;
        while (n2 < n) {
            String pathItem = stringArray[n2];
            this.createFilesItem(pathItem, null);
            ++n2;
        }
        Control control = this.descriptionLabel;
        if (control instanceof CLabel) {
            CLabel cl = (CLabel)control;
            cl.setText("You can configure a single file or a folder path.\nEach individual file (" + String.join((CharSequence)",", this.getFileExtensions(false)) + ") is represented as a table. Folder is represented as a schema.");
            this.descriptionLabel.getParent().layout(true, true);
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.typeURLRadio != null) {
            connectionInfo.setConfigurationType(this.typeURLRadio.getSelection() ? DBPDriverConfigurationType.URL : DBPDriverConfigurationType.MANUAL);
        }
        if (connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL) {
            connectionInfo.setUrl(this.urlText.getText().trim());
        } else {
            StringBuilder fullPath = new StringBuilder();
            TableItem[] tableItemArray = this.filesTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (!fullPath.isEmpty()) {
                    fullPath.append(";");
                }
                fullPath.append(item.getText(0));
                ++n2;
            }
            connectionInfo.setDatabaseName(fullPath.toString());
        }
        super.saveSettings(dataSource);
    }

    protected boolean supportsDriverSubstitution() {
        return false;
    }

    public Image getImage() {
        DBPImage icon = this.getSite().getDriver().getIconBig();
        return DBeaverIcons.getImage((DBPImage)icon);
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{this.driverPropsPage};
    }

    @Override
    @Nullable
    public DBPProject getProject() {
        return this.getSite().getProject();
    }

    @Override
    @NotNull
    public String[] getFileExtensions(boolean addAll) {
        DBPDriver driver = this.site.getActiveDataSource().getDriver();
        String databaseFileExtensionList = (String)driver.getDriverParameter("database-file-extensions");
        ArrayList<String> extensionList = new ArrayList<String>();
        if (databaseFileExtensionList != null && !databaseFileExtensionList.isBlank()) {
            String[] supportedExtension;
            String[] stringArray = supportedExtension = databaseFileExtensionList.split(",");
            int n = supportedExtension.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                extensionList.add(String.format("*.%s", extension));
                ++n2;
            }
        }
        if (addAll) {
            extensionList.add("*.*");
        }
        return extensionList.toArray(new String[0]);
    }

    @Override
    @Nullable
    public String getFilePath() {
        if (this.filesTable.getItemCount() < 1) {
            return null;
        }
        return this.filesTable.getItem(0).getText(0);
    }

    @Override
    public void setFilePath(@NotNull String filePath) {
        this.updatePathList(filePath, false);
    }

    private void updatePathList(@NotNull String filePath, boolean addNew) {
        this.filesTableEditor.closeEditor();
        String[] filesPaths = filePath.split(";");
        if (addNew && CommonUtils.isEmpty((String)this.getFilePath())) {
            addNew = false;
        }
        TableItem activeItem = null;
        if (!addNew) {
            TableItem[] selection = this.filesTable.getSelection();
            activeItem = selection.length == 0 ? this.filesTable.getItem(0) : selection[0];
            activeItem.setText(0, filesPaths[0]);
            if (filesPaths.length > 1) {
                String[] stringArray = filesPaths;
                int n = filesPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    this.createOrUpdateFilesItem(path);
                    ++n2;
                }
            }
        } else {
            String[] stringArray = filesPaths;
            int n = filesPaths.length;
            int n3 = 0;
            while (n3 < n) {
                String path = stringArray[n3];
                activeItem = this.createOrUpdateFilesItem(path);
                ++n3;
            }
            if (activeItem != null) {
                this.filesTable.setSelection(activeItem);
            }
            this.filesTable.setFocus();
        }
        if (activeItem != null) {
            this.filesTableEditor.showEditor(activeItem);
        }
        this.updateButtonsState();
    }

    public static enum FileSelectorType {
        FILE,
        FOLDER,
        REMOTE;

    }

    private abstract class LocalPathInfoProvider
    implements FilePathInfoProvider {
        private LocalPathInfoProvider() {
        }

        @Override
        @Nullable
        public DBPProject getProject() {
            return FlatFilesConnectionPage.this.getSite().getProject();
        }

        @Override
        @Nullable
        public String[] getFileExtensions(boolean addAll) {
            return FlatFilesConnectionPage.this.getFileExtensions(addAll);
        }

        @Override
        @Nullable
        public String getFilePath() {
            return FlatFilesConnectionPage.this.getFilePath();
        }
    }
}

