/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.firestore.exec;

import com.dbeaver.db.google.firestore.exec.FireStoreBaseStatement;
import com.dbeaver.db.google.firestore.exec.FireStoreSession;
import com.dbeaver.db.google.firestore.exec.query.FireStoreQueryBuilder;
import com.dbeaver.db.google.firestore.exec.query.FireStoreSQLQueryProcessor;
import com.dbeaver.db.google.firestore.model.FireStoreCollection;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QuerySnapshot;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public class FireStoreDatabaseStatement
extends FireStoreBaseStatement {
    private final int offset;
    private final int limit;
    private final DBDDataFilter filter;
    private final FireStoreCollection collection;

    public FireStoreDatabaseStatement(FireStoreSession session, FireStoreCollection collection, long firstRow, long maxRows, DBDDataFilter dataFilter) throws DBException {
        super(session, FireStoreSQLQueryProcessor.makeSQLQuery(collection, dataFilter));
        this.offset = (int)firstRow;
        this.limit = (int)maxRows;
        this.filter = dataFilter;
        this.collection = collection;
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    public boolean executeStatement() throws DBCException {
        try {
            Query query = FireStoreQueryBuilder.buildQueryFromSelect(((FireStoreSession)this.getSession()).getExecutionContext(), this.makeQueryFromString(this.getQueryString()), this.collection.getPath(), this.offset, this.limit);
            QuerySnapshot queryDocumentSnapshots = (QuerySnapshot)query.get().get((long)this.timeout, TimeUnit.SECONDS);
            this.result = queryDocumentSnapshots.getDocuments().stream().filter(DocumentSnapshot::exists).collect(Collectors.toList());
        }
        catch (Throwable ex) {
            throw this.handleExecuteError(ex);
        }
        return true;
    }

    public DBSEntity getSourceEntity() {
        return this.collection;
    }

    private PlainSelect makeQueryFromString(String queryString) throws DBException {
        Statement statement = SQLSemanticProcessor.parseQuery((SQLDialect)((FireStoreSession)this.getSession()).getDataSource().getSQLDialect(), (String)queryString);
        if (statement instanceof PlainSelect) {
            PlainSelect select = (PlainSelect)statement;
            return select;
        }
        throw new DBCException("Non selects are not supported");
    }
}

