/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.firestore.exec.query;

import com.dbeaver.db.google.firestore.model.FireStoreCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class FireStoreSQLQueryProcessor {
    public static final String[][] QUOTE_STRINGS = new String[][]{{"\"", "\""}};

    @NotNull
    public static String makeSQLQuery(@NotNull FireStoreCollection collection, @Nullable DBDDataFilter filter) throws DBException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ").append(collection.getFullyQualifiedName(DBPEvaluationContext.DML));
        if (filter != null && filter.hasConditions()) {
            sql.append(" WHERE ");
            SQLUtils.appendConditionString((DBDDataFilter)filter, (DBPDataSource)collection.getDataSource(), null, (StringBuilder)sql, (boolean)true);
        }
        if (filter != null && filter.hasOrdering()) {
            sql.append(" ORDER BY ");
            SQLUtils.appendOrderString((DBDDataFilter)filter, (DBPDataSource)collection.getDataSource(), null, (boolean)false, (StringBuilder)sql);
        }
        return sql.toString();
    }

    public static String unquote(String name) {
        CharSequence[] attrNameParts = SQLUtils.splitFullIdentifier((String)name, (String)".", (String[][])QUOTE_STRINGS, (boolean)false);
        return String.join((CharSequence)".", attrNameParts);
    }

    @NotNull
    public static List<Pair<Column, Boolean>> getOrdering(@NotNull PlainSelect select) throws DBCException {
        List orderBy = select.getOrderByElements();
        ArrayList<Pair<Column, Boolean>> orderList = new ArrayList<Pair<Column, Boolean>>();
        if (!CommonUtils.isEmpty((Collection)orderBy)) {
            for (OrderByElement item : orderBy) {
                Expression expr = item.getExpression();
                if (expr instanceof Column) {
                    Column column = (Column)expr;
                    orderList.add((Pair<Column, Boolean>)new Pair((Object)column, (Object)item.isAsc()));
                    continue;
                }
                throw new DBCException("Unsupported ORDER BY item: " + String.valueOf(item));
            }
        }
        return orderList;
    }
}

